/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.DiscreteBlock;
import nl.basjes.modbus.device.api.ModbusBlock;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDeviceToTableKt;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.fetcher.ModbusBlockFetcher;
import nl.basjes.modbus.schema.fetcher.ModbusQuery;
import nl.basjes.modbus.schema.fetcher.OptimizingModbusBlockFetcher;
import nl.basjes.modbus.schema.test.TestScenario;
import nl.basjes.modbus.schema.test.TestScenarioResultsList;
import nl.basjes.modbus.schema.utils.StringTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 ^2\u00020\u0001:\u0003]^_B\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0018\u001a\u00020\u000eJ\u000e\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u001dJ\u0010\u0010%\u001a\u0004\u0018\u00010\u001d2\u0006\u0010&\u001a\u00020\u0003J\u0006\u00101\u001a\u00020\u0016J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000203J\u0006\u00105\u001a\u00020\u0003J\u000e\u0010B\u001a\u00020\u00002\u0006\u00106\u001a\u000207J\u001a\u0010C\u001a\u00020\u00002\u0006\u00106\u001a\u0002072\b\b\u0002\u0010D\u001a\u00020\u0005H\u0007J\u0018\u0010H\u001a\b\u0012\u0004\u0012\u00020I0 2\b\b\u0002\u0010J\u001a\u00020KH\u0007J\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020I0 2\u0006\u0010L\u001a\u00020FJ\u0018\u0010M\u001a\b\u0012\u0004\u0012\u00020I0 2\b\b\u0002\u0010J\u001a\u00020KH\u0007J\u000e\u0010N\u001a\u00020\u00162\u0006\u0010L\u001a\u00020FJ\u000e\u0010O\u001a\u00020\u00162\u0006\u0010L\u001a\u00020FJ\u0006\u0010P\u001a\u00020\u0016J\u0006\u0010Q\u001a\u00020\u0016J\f\u0010R\u001a\b\u0012\u0004\u0012\u00020F0 J\u000e\u0010W\u001a\u00020\u00162\u0006\u0010X\u001a\u00020TJ\u0006\u0010Y\u001a\u00020\u0016J\u0006\u0010Z\u001a\u00020[J\b\u0010\\\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001d0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010'\u001a\u00020\u00058F\u00a2\u0006\f\u0012\u0004\b(\u0010)\u001a\u0004\b*\u0010\u0012R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001c\u00106\u001a\u0004\u0018\u000107X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001c\u0010<\u001a\u0004\u0018\u00010=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u0017\u0010E\u001a\b\u0012\u0004\u0012\u00020F0 8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010\"R\u0014\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010U\u001a\b\u0012\u0004\u0012\u00020T0 \u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\"\u00a8\u0006`"}, d2={"Lnl/basjes/modbus/schema/SchemaDevice;", "", "description", "", "maxRegistersPerModbusRequest", "", "<init>", "(Ljava/lang/String;I)V", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "modbusBlocks", "", "Lnl/basjes/modbus/device/api/AddressClass;", "Lnl/basjes/modbus/device/api/ModbusBlock;", "value", "getMaxRegistersPerModbusRequest", "()I", "setMaxRegistersPerModbusRequest", "(I)V", "clearModbusBlocks", "", "getModbusBlock", "addressClass", "schemaFeatureLevel", "getSchemaFeatureLevel", "mutableBlocks", "", "Lnl/basjes/modbus/schema/Block;", "mutableBlocksMap", "blocks", "", "getBlocks", "()Ljava/util/List;", "addBlock", "newBlock", "getBlock", "blockId", "maxBlockIdLength", "getMaxBlockIdLength$annotations", "()V", "getMaxBlockIdLength", "lastFieldModificationTimestamp", "Ljava/time/Instant;", "getLastFieldModificationTimestamp", "()Ljava/time/Instant;", "setLastFieldModificationTimestamp", "(Ljava/time/Instant;)V", "aFieldWasChanged", "initialize", "", "initializeAndVerify", "initializationProblems", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "getModbusDevice", "()Lnl/basjes/modbus/device/api/ModbusDevice;", "setModbusDevice", "(Lnl/basjes/modbus/device/api/ModbusDevice;)V", "modbusBlockFetcher", "Lnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher;", "getModbusBlockFetcher", "()Lnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher;", "setModbusBlockFetcher", "(Lnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher;)V", "connectBase", "connect", "allowedGapReadSize", "fields", "Lnl/basjes/modbus/schema/Field;", "getFields", "update", "Lnl/basjes/modbus/schema/fetcher/ModbusQuery;", "maxAge", "", "field", "updateAll", "need", "unNeed", "needAll", "unNeedAll", "neededFields", "mutableTests", "Lnl/basjes/modbus/schema/test/TestScenario;", "tests", "getTests", "addTestScenario", "testScenario", "createTestsUsingCurrentRealData", "verifyProvidedTests", "Lnl/basjes/modbus/schema/test/TestScenarioResultsList;", "toString", "TestResult", "Companion", "SchemaDeviceBuilder", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nSchemaDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaDevice.kt\nnl/basjes/modbus/schema/SchemaDevice\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n1869#2,2:395\n1869#2:398\n1869#2,2:399\n1870#2:401\n1563#2:402\n1634#2,3:403\n1869#2,2:406\n1869#2,2:408\n1374#2:410\n1460#2,5:411\n1617#2,9:416\n1869#2:425\n1870#2:427\n1626#2:428\n1#3:397\n1#3:426\n*S KotlinDebug\n*F\n+ 1 SchemaDevice.kt\nnl/basjes/modbus/schema/SchemaDevice\n*L\n74#1:395,2\n164#1:398\n166#1:399,2\n164#1:401\n219#1:402\n219#1:403,3\n272#1:406,2\n279#1:408,2\n285#1:410\n285#1:411,5\n306#1:416,9\n306#1:425\n306#1:427\n306#1:428\n306#1:426\n*E\n"})
public class SchemaDevice {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String description;
    @NotNull
    private final Map<AddressClass, ModbusBlock<?, ?, ?>> modbusBlocks;
    private int maxRegistersPerModbusRequest;
    private final int schemaFeatureLevel;
    @NotNull
    private final List<Block> mutableBlocks;
    @NotNull
    private final Map<String, Block> mutableBlocksMap;
    @NotNull
    private final List<Block> blocks;
    @NotNull
    private Instant lastFieldModificationTimestamp;
    @Nullable
    private ModbusDevice modbusDevice;
    @Nullable
    private ModbusBlockFetcher modbusBlockFetcher;
    @NotNull
    private final List<TestScenario> mutableTests;
    @NotNull
    private final List<TestScenario> tests;
    public static final int CURRENT_SCHEMA_FEATURE_LEVEL = 2;
    @NotNull
    private static final Logger LOG;

    @JvmOverloads
    public SchemaDevice(@NotNull String description, int maxRegistersPerModbusRequest) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.description = description;
        this.modbusBlocks = new TreeMap();
        this.maxRegistersPerModbusRequest = maxRegistersPerModbusRequest;
        this.schemaFeatureLevel = 2;
        this.mutableBlocks = new ArrayList();
        this.mutableBlocksMap = new LinkedHashMap();
        this.blocks = this.mutableBlocks;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.lastFieldModificationTimestamp = instant;
        this.mutableTests = new ArrayList();
        this.tests = this.mutableTests;
    }

    public /* synthetic */ SchemaDevice(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 2) != 0) {
            n = 125;
        }
        this(string, n);
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.description = string;
    }

    public final int getMaxRegistersPerModbusRequest() {
        return this.maxRegistersPerModbusRequest;
    }

    public final void setMaxRegistersPerModbusRequest(int value) {
        if (value < 1 || value > 125) {
            throw new ModbusException("The maxRegistersPerModbusRequest must be between 1 and 125 (was set to " + value + ").", null, 2, null);
        }
        this.maxRegistersPerModbusRequest = value;
    }

    public final void clearModbusBlocks() {
        Iterable $this$forEach$iv = this.modbusBlocks.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModbusBlock it = (ModbusBlock)element$iv;
            boolean bl = false;
            it.clear();
        }
    }

    @NotNull
    public final ModbusBlock<?, ?, ?> getModbusBlock(@NotNull AddressClass addressClass) {
        Intrinsics.checkNotNullParameter((Object)addressClass, (String)"addressClass");
        ModbusBlock modbusBlock = this.modbusBlocks.computeIfAbsent(addressClass, arg_0 -> SchemaDevice.getModbusBlock$lambda$2(arg_0 -> SchemaDevice.getModbusBlock$lambda$1(addressClass, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)modbusBlock, (String)"computeIfAbsent(...)");
        return modbusBlock;
    }

    public final int getSchemaFeatureLevel() {
        return this.schemaFeatureLevel;
    }

    @NotNull
    public final List<Block> getBlocks() {
        return this.blocks;
    }

    public final void addBlock(@NotNull Block newBlock) {
        Intrinsics.checkNotNullParameter((Object)newBlock, (String)"newBlock");
        if (!this.mutableBlocks.contains(newBlock)) {
            this.mutableBlocks.add(newBlock);
            this.mutableBlocksMap.putIfAbsent(newBlock.getId(), newBlock);
        }
    }

    @Nullable
    public final Block getBlock(@NotNull String blockId) {
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        return this.mutableBlocksMap.get(blockId);
    }

    public final int getMaxBlockIdLength() {
        Comparable comparable;
        Iterator iterator = ((Iterable)this.mutableBlocksMap.keySet()).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            String it = (String)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.length());
            while (iterator.hasNext()) {
                String it2 = (String)iterator.next();
                $i$a$-maxOfOrNull-SchemaDevice$maxBlockIdLength$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.length());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    public static /* synthetic */ void getMaxBlockIdLength$annotations() {
    }

    @NotNull
    public final Instant getLastFieldModificationTimestamp() {
        return this.lastFieldModificationTimestamp;
    }

    public final void setLastFieldModificationTimestamp(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.lastFieldModificationTimestamp = instant;
    }

    public final void aFieldWasChanged() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.lastFieldModificationTimestamp = instant;
    }

    public final boolean initialize() {
        boolean allOk = true;
        for (Block block : this.blocks) {
            if (block.initialize()) continue;
            allOk = false;
        }
        return allOk;
    }

    public final boolean initializeAndVerify() throws ModbusException {
        if (!this.initialize()) {
            return false;
        }
        TestScenarioResultsList results = this.verifyProvidedTests();
        if (!results.getAllPassed()) {
            LOG.error("Logical device initialization: These Schema tests failed: " + results.getFailedTests() + ".");
            results.logResults();
            return false;
        }
        return true;
    }

    @NotNull
    public final String initializationProblems() {
        StringTable stringTable = new StringTable();
        String[] stringArray = new String[]{"Block", "Field", "Problem"};
        stringTable.withHeaders(stringArray);
        Iterable $this$forEach$iv = this.blocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block block = (Block)element$iv;
            boolean bl = false;
            SchemaDevice $this$initializationProblems_u24lambda_u247_u24lambda_u246 = this;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = block.getFields();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Field field = (Field)element$iv2;
                boolean bl3 = false;
                SchemaDevice $this$initializationProblems_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244 = $this$initializationProblems_u24lambda_u247_u24lambda_u246;
                boolean bl4 = false;
                Expression parsedExpression = field.getParsedExpression();
                if (parsedExpression == null) {
                    String[] stringArray2 = new String[]{block.getId(), field.getId(), "Unable to parse the expression"};
                    stringTable.addRow(stringArray2);
                    continue;
                }
                List<Expression.Problem> problemList = parsedExpression.getProblems();
                if (!(!((Collection)problemList).isEmpty())) continue;
                String[] stringArray3 = new String[]{block.getId(), field.getId(), CollectionsKt.joinToString$default((Iterable)problemList, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)};
                stringTable.addRow(stringArray3);
            }
        }
        return stringTable.toString();
    }

    @Nullable
    public final ModbusDevice getModbusDevice() {
        return this.modbusDevice;
    }

    public final void setModbusDevice(@Nullable ModbusDevice modbusDevice) {
        this.modbusDevice = modbusDevice;
    }

    @Nullable
    public final ModbusBlockFetcher getModbusBlockFetcher() {
        return this.modbusBlockFetcher;
    }

    public final void setModbusBlockFetcher(@Nullable ModbusBlockFetcher modbusBlockFetcher) {
        this.modbusBlockFetcher = modbusBlockFetcher;
    }

    @NotNull
    public final SchemaDevice connectBase(@NotNull ModbusDevice modbusDevice) {
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        this.clearModbusBlocks();
        this.modbusDevice = modbusDevice;
        modbusDevice.setMaxRegistersPerModbusRequest(this.maxRegistersPerModbusRequest);
        this.modbusBlockFetcher = new ModbusBlockFetcher(this, modbusDevice);
        return this;
    }

    @JvmOverloads
    @NotNull
    public final SchemaDevice connect(@NotNull ModbusDevice modbusDevice, int allowedGapReadSize) {
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        this.clearModbusBlocks();
        this.modbusDevice = modbusDevice;
        modbusDevice.setMaxRegistersPerModbusRequest(this.maxRegistersPerModbusRequest);
        OptimizingModbusBlockFetcher optimizingFetcher = new OptimizingModbusBlockFetcher(this, modbusDevice);
        optimizingFetcher.setAllowedGapReadSize(allowedGapReadSize);
        this.modbusBlockFetcher = optimizingFetcher;
        return this;
    }

    public static /* synthetic */ SchemaDevice connect$default(SchemaDevice schemaDevice, ModbusDevice modbusDevice, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: connect");
        }
        if ((n2 & 2) != 0) {
            n = 100;
        }
        return schemaDevice.connect(modbusDevice, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Field> getFields() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.blocks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Block block = (Block)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFields());
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @JvmOverloads
    @NotNull
    public final List<ModbusQuery> update(long maxAge) {
        Object object = this.modbusBlockFetcher;
        if (object == null || (object = ((ModbusBlockFetcher)object).update(maxAge)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static /* synthetic */ List update$default(SchemaDevice schemaDevice, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return schemaDevice.update(l);
    }

    @NotNull
    public final List<ModbusQuery> update(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Object object = this.modbusBlockFetcher;
        if (object == null || (object = ModbusBlockFetcher.update$default((ModbusBlockFetcher)object, field, 0L, 2, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @JvmOverloads
    @NotNull
    public final List<ModbusQuery> updateAll(long maxAge) throws ModbusException {
        this.initialize();
        this.needAll();
        List<ModbusQuery> fetched = this.update(maxAge);
        this.unNeedAll();
        return fetched;
    }

    public static /* synthetic */ List updateAll$default(SchemaDevice schemaDevice, long l, int n, Object object) throws ModbusException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateAll");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return schemaDevice.updateAll(l);
    }

    public final void need(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        field.need();
    }

    public final void unNeed(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        field.unNeed();
    }

    public final void needAll() {
        Iterable $this$forEach$iv = this.blocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block it = (Block)element$iv;
            boolean bl = false;
            it.needAll();
        }
    }

    public final void unNeedAll() {
        Iterable $this$forEach$iv = this.blocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block it = (Block)element$iv;
            boolean bl = false;
            it.unNeedAll();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Field> neededFields() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.blocks;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Block it = (Block)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.neededFields();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<TestScenario> getTests() {
        return this.tests;
    }

    public final void addTestScenario(@NotNull TestScenario testScenario) {
        Intrinsics.checkNotNullParameter((Object)testScenario, (String)"testScenario");
        this.mutableTests.add(testScenario);
    }

    /*
     * WARNING - void declaration
     */
    public final void createTestsUsingCurrentRealData() {
        long oldestTimestampOfData = 0L;
        for (ModbusBlock<?, ?, ?> modbusBlock : this.modbusBlocks.values()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = modbusBlock.getValues();
            long l = oldestTimestampOfData;
            boolean $i$f$mapNotNull = false;
            void var8_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Long it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ModbusValue p0 = (ModbusValue)element$iv$iv;
                boolean bl2 = false;
                if (p0.getTimestamp() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            Long l2 = (Long)CollectionsKt.minOrNull((Iterable)list);
            oldestTimestampOfData = RangesKt.coerceAtLeast((long)l, (long)(l2 != null ? l2 : 0L));
        }
        DateTimeFormatter dateTimeFormatterCompact = DateTimeFormatter.ofPattern("_uuuu_MM_dd_HH_mm_ss").withZone(ZoneOffset.UTC);
        DateTimeFormatter dateTimeFormatterISO = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneOffset.UTC);
        Instant oldestInstantOfData = Instant.ofEpochMilli(oldestTimestampOfData);
        String name = "TestAt" + dateTimeFormatterCompact.format(oldestInstantOfData);
        String description = "Test generated from device data at " + dateTimeFormatterISO.format(oldestInstantOfData);
        TestScenario test = new TestScenario(name, description);
        this.mutableTests.add(test);
        for (ModbusBlock<?, ?, ?> modbusBlock : this.modbusBlocks.values()) {
            test.addModbusBlock(modbusBlock.clone());
        }
        test.recreateExpectedValues(this);
    }

    @NotNull
    public final TestScenarioResultsList verifyProvidedTests() throws ModbusException {
        TestScenarioResultsList allTestResults = new TestScenarioResultsList();
        for (TestScenario test : this.tests) {
            allTestResults.add(test.verify(this));
        }
        return allTestResults;
    }

    @NotNull
    public String toString() {
        return SchemaDeviceToTableKt.toTable(this, false, true);
    }

    @JvmOverloads
    public SchemaDevice(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this(description, 0, 2, null);
    }

    @JvmOverloads
    public SchemaDevice() {
        this(null, 0, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final SchemaDevice connect(@NotNull ModbusDevice modbusDevice) {
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        return SchemaDevice.connect$default(this, modbusDevice, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final List<ModbusQuery> update() {
        return SchemaDevice.update$default(this, 0L, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final List<ModbusQuery> updateAll() throws ModbusException {
        return SchemaDevice.updateAll$default(this, 0L, 1, null);
    }

    private static final ModbusBlock getModbusBlock$lambda$1(AddressClass $addressClass, AddressClass it) {
        ModbusBlock modbusBlock;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        switch (WhenMappings.$EnumSwitchMapping$0[$addressClass.getType().ordinal()]) {
            case 1: {
                modbusBlock = (ModbusBlock)new DiscreteBlock($addressClass);
                break;
            }
            case 2: {
                modbusBlock = (ModbusBlock)new RegisterBlock($addressClass);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return modbusBlock;
    }

    private static final ModbusBlock getModbusBlock$lambda$2(Function1 $tmp0, Object p0) {
        return (ModbusBlock)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final SchemaDeviceBuilder builder() {
        return Companion.builder();
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnl/basjes/modbus/schema/SchemaDevice$Companion;", "", "<init>", "()V", "builder", "Lnl/basjes/modbus/schema/SchemaDevice$SchemaDeviceBuilder;", "CURRENT_SCHEMA_FEATURE_LEVEL", "", "LOG", "Lorg/apache/logging/log4j/Logger;", "modbus-schema-device"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SchemaDeviceBuilder builder() {
            return new SchemaDeviceBuilder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\u000eR\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lnl/basjes/modbus/schema/SchemaDevice$SchemaDeviceBuilder;", "", "<init>", "()V", "description", "", "value", "getDescription", "()Ljava/lang/String;", "maxRegistersPerModbusRequest", "", "getMaxRegistersPerModbusRequest", "()I", "build", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbus-schema-device"})
    @SourceDebugExtension(value={"SMAP\nSchemaDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaDevice.kt\nnl/basjes/modbus/schema/SchemaDevice$SchemaDeviceBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n1#2:395\n*E\n"})
    public static class SchemaDeviceBuilder {
        @NotNull
        private String description = "";
        private int maxRegistersPerModbusRequest = 125;

        @NotNull
        public final SchemaDeviceBuilder description(@NotNull String description) {
            SchemaDeviceBuilder schemaDeviceBuilder;
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            SchemaDeviceBuilder $this$description_u24lambda_u240 = schemaDeviceBuilder = this;
            boolean bl = false;
            $this$description_u24lambda_u240.description = description;
            return schemaDeviceBuilder;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final SchemaDeviceBuilder maxRegistersPerModbusRequest(int maxRegistersPerModbusRequest) {
            SchemaDeviceBuilder schemaDeviceBuilder;
            SchemaDeviceBuilder $this$maxRegistersPerModbusRequest_u24lambda_u241 = schemaDeviceBuilder = this;
            boolean bl = false;
            $this$maxRegistersPerModbusRequest_u24lambda_u241.maxRegistersPerModbusRequest = maxRegistersPerModbusRequest;
            return schemaDeviceBuilder;
        }

        public final int getMaxRegistersPerModbusRequest() {
            return this.maxRegistersPerModbusRequest;
        }

        @NotNull
        public final SchemaDevice build() {
            return new SchemaDevice(this.description, this.maxRegistersPerModbusRequest);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0006\u001a\u00020\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lnl/basjes/modbus/schema/SchemaDevice$TestResult;", "", "expectedValue", "", "", "actualValue", "passed", "", "<init>", "(Ljava/util/List;Ljava/util/List;Z)V", "getExpectedValue", "()Ljava/util/List;", "getActualValue", "isPassed", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "modbus-schema-device"})
    public static final class TestResult {
        @NotNull
        private final List<String> expectedValue;
        @NotNull
        private final List<String> actualValue;
        private final boolean passed;

        public TestResult(@NotNull List<String> expectedValue, @NotNull List<String> actualValue, boolean passed) {
            Intrinsics.checkNotNullParameter(expectedValue, (String)"expectedValue");
            Intrinsics.checkNotNullParameter(actualValue, (String)"actualValue");
            this.expectedValue = expectedValue;
            this.actualValue = actualValue;
            this.passed = passed;
        }

        @NotNull
        public final List<String> getExpectedValue() {
            return this.expectedValue;
        }

        @NotNull
        public final List<String> getActualValue() {
            return this.actualValue;
        }

        @JvmName(name="isPassed")
        public final boolean isPassed() {
            return this.passed;
        }

        @NotNull
        public final List<String> component1() {
            return this.expectedValue;
        }

        @NotNull
        public final List<String> component2() {
            return this.actualValue;
        }

        public final boolean component3() {
            return this.passed;
        }

        @NotNull
        public final TestResult copy(@NotNull List<String> expectedValue, @NotNull List<String> actualValue, boolean passed) {
            Intrinsics.checkNotNullParameter(expectedValue, (String)"expectedValue");
            Intrinsics.checkNotNullParameter(actualValue, (String)"actualValue");
            return new TestResult(expectedValue, actualValue, passed);
        }

        public static /* synthetic */ TestResult copy$default(TestResult testResult, List list, List list2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                list = testResult.expectedValue;
            }
            if ((n & 2) != 0) {
                list2 = testResult.actualValue;
            }
            if ((n & 4) != 0) {
                bl = testResult.passed;
            }
            return testResult.copy(list, list2, bl);
        }

        @NotNull
        public String toString() {
            return "TestResult(expectedValue=" + this.expectedValue + ", actualValue=" + this.actualValue + ", passed=" + this.passed + ")";
        }

        public int hashCode() {
            int result = ((Object)this.expectedValue).hashCode();
            result = result * 31 + ((Object)this.actualValue).hashCode();
            result = result * 31 + Boolean.hashCode(this.passed);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TestResult)) {
                return false;
            }
            TestResult testResult = (TestResult)other;
            if (!Intrinsics.areEqual(this.expectedValue, testResult.expectedValue)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.actualValue, testResult.actualValue)) {
                return false;
            }
            return this.passed == testResult.passed;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AddressClass.Type.values().length];
            try {
                nArray[AddressClass.Type.DISCRETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressClass.Type.REGISTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

