/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.modbus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0017\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u00178DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u0082\u0001\u0002\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lnl/basjes/modbus/schema/expression/modbus/ModbusExpression;", "Lnl/basjes/modbus/schema/expression/Expression;", "addresses", "", "Lnl/basjes/modbus/device/api/Address;", "<init>", "(Ljava/util/List;)V", "getAddresses", "()Ljava/util/List;", "requiredAddresses", "getRequiredAddresses", "isImmutable", "", "()Z", "setImmutable", "(Z)V", "requiredMutableAddresses", "getRequiredMutableAddresses", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "isSortedList", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "getAddressClass", "()Lnl/basjes/modbus/device/api/AddressClass;", "toString", "", "Lnl/basjes/modbus/schema/expression/modbus/DiscreteModbusExpression;", "Lnl/basjes/modbus/schema/expression/modbus/RegistersModbusExpression;", "modbus-schema-device"})
public abstract class ModbusExpression
implements Expression {
    @NotNull
    private final List<Address> addresses;
    private boolean isImmutable;

    private ModbusExpression(List<Address> addresses) {
        this.addresses = addresses;
    }

    @NotNull
    protected final List<Address> getAddresses() {
        return this.addresses;
    }

    @Override
    @NotNull
    public List<Address> getRequiredAddresses() {
        return this.addresses;
    }

    @Override
    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public void setImmutable(boolean bl) {
        this.isImmutable = bl;
    }

    @Override
    @NotNull
    public List<Address> getRequiredMutableAddresses() {
        return this.addresses;
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        if (this.addresses.isEmpty()) {
            return CollectionsKt.listOf((Object)new Expression.Problem("No addresses"));
        }
        TreeSet sortedSet = new TreeSet(this.addresses);
        if (sortedSet.size() != this.addresses.size()) {
            return CollectionsKt.listOf((Object)new Expression.Problem("Duplicate addresses: " + this.addresses));
        }
        Address expectedAddress = null;
        Iterator iterator = sortedSet.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Address address = (Address)iterator2.next();
            if (expectedAddress == null) {
                expectedAddress = address;
            }
            Address address2 = expectedAddress;
            Intrinsics.checkNotNull((Object)address2);
            if (!Intrinsics.areEqual((Object)address2, (Object)address)) {
                return CollectionsKt.listOf((Object)new Expression.Problem("Illegal Address range specified: " + this.addresses));
            }
            expectedAddress = Address.increment$default((Address)expectedAddress, (int)0, (int)1, null);
        }
        return CollectionsKt.emptyList();
    }

    private final boolean isSortedList() {
        return this.getProblems().isEmpty() ? Intrinsics.areEqual(this.addresses, new ArrayList(new TreeSet(this.addresses))) : false;
    }

    @NotNull
    protected final AddressClass getAddressClass() {
        return this.addresses.get(0).getAddressClass();
    }

    @NotNull
    public String toString() {
        if (this.isSortedList()) {
            if (this.addresses.size() > 1) {
                return this.addresses.get(0) + " # " + this.addresses.size();
            }
            return this.addresses.get(0).toString();
        }
        return CollectionsKt.joinToString$default((Iterable)this.addresses, (CharSequence)", ", null, null, (int)0, null, ModbusExpression::toString$lambda$0, (int)30, null);
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return Expression.super.toString(isTop);
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        return Expression.super.initialize(containingField);
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return Expression.super.getSubExpressions();
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return Expression.super.getRequiredFields();
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return Expression.super.getReturnType();
    }

    @Override
    @NotNull
    public List<ModbusValue<?, ?>> getModbusValues(@NotNull SchemaDevice schemaDevice) {
        return Expression.super.getModbusValues(schemaDevice);
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return Expression.super.check(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return Expression.super.checkFatal(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return Expression.super.combine(function, problems);
    }

    private static final CharSequence toString$lambda$0(Address it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    public /* synthetic */ ModbusExpression(List addresses, DefaultConstructorMarker $constructor_marker) {
        this(addresses);
    }
}

