/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.fetcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.DiscreteBlock;
import nl.basjes.modbus.device.api.DiscreteValue;
import nl.basjes.modbus.device.api.ModbusBlock;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusApiException;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.fetcher.HoleModbusQuery;
import nl.basjes.modbus.schema.fetcher.MergedModbusQuery;
import nl.basjes.modbus.schema.fetcher.ModbusQuery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rH\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J<\u0010\u001d\u001a*\u0012\u0012\b\u0001\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f\u0012\u0002\b\u00030\u001e*\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0013H\u0002JT\u0010 \u001a\u00020!**\u0012\u0012\b\u0001\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f\u0012\u0002\b\u00030\u001e2\u001e\u0010\"\u001a\u001a\u0012\u0002\b\u0003\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f\u0012\u0002\b\u00030\u001eH\u0002J\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001a\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b$J\u001b\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001a\u001a\u00020&H\u0010\u00a2\u0006\u0002\b'J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u0017J$\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006,"}, d2={"Lnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher;", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;Lnl/basjes/modbus/device/api/ModbusDevice;)V", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "getModbusDevice", "()Lnl/basjes/modbus/device/api/ModbusDevice;", "calculateFetchGroupToAddressesMapping", "", "", "", "Lnl/basjes/modbus/device/api/Address;", "update", "", "Lnl/basjes/modbus/schema/fetcher/ModbusQuery;", "field", "Lnl/basjes/modbus/schema/Field;", "maxAge", "", "getDiscretes", "Lnl/basjes/modbus/device/api/DiscreteBlock;", "modbusQuery", "getRegisters", "Lnl/basjes/modbus/device/api/RegisterBlock;", "executeQuery", "Lnl/basjes/modbus/device/api/ModbusBlock;", "Lnl/basjes/modbus/device/api/ModbusValue;", "mergeFetched", "", "fetchedModbusBlock", "fetch", "fetch$modbus_schema_device", "retryFetchOfFailedMergedModbusQuery", "Lnl/basjes/modbus/schema/fetcher/MergedModbusQuery;", "retryFetchOfFailedMergedModbusQuery$modbus_schema_device", "calculateModbusQueries", "fields", "allFieldsThatMustBeUpdated", "Companion", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nModbusBlockFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModbusBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,317:1\n1#2:318\n37#3:319\n36#3,3:320\n1563#4:323\n1634#4,3:324\n1761#4,3:327\n1761#4,3:330\n1869#4,2:333\n1869#4,2:335\n1374#4:337\n1460#4,2:338\n1563#4:340\n1634#4,3:341\n295#4,2:344\n1462#4,3:346\n*S KotlinDebug\n*F\n+ 1 ModbusBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher\n*L\n97#1:319\n97#1:320,3\n100#1:323\n100#1:324,3\n127#1:327,3\n146#1:330,3\n209#1:333,2\n222#1:335,2\n294#1:337\n294#1:338,2\n301#1:340\n301#1:341,3\n302#1:344,2\n294#1:346,3\n*E\n"})
public class ModbusBlockFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaDevice schemaDevice;
    @NotNull
    private final ModbusDevice modbusDevice;
    @NotNull
    private static final Logger LOG;

    public ModbusBlockFetcher(@NotNull SchemaDevice schemaDevice, @NotNull ModbusDevice modbusDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        this.schemaDevice = schemaDevice;
        this.modbusDevice = modbusDevice;
    }

    @NotNull
    protected final SchemaDevice getSchemaDevice() {
        return this.schemaDevice;
    }

    @NotNull
    protected final ModbusDevice getModbusDevice() {
        return this.modbusDevice;
    }

    private final Map<String, List<Address>> calculateFetchGroupToAddressesMapping() {
        Map fetchGroupToAddresses = new TreeMap();
        for (Block entry : this.schemaDevice.getBlocks()) {
            for (Field field : entry.getFields()) {
                String fieldFetchGroup = field.getFetchGroup();
                boolean fieldImmutable = field.isImmutable();
                List<Address> requiredAddresses = field.getRequiredAddresses();
                for (Address requiredAddress : requiredAddresses) {
                    ModbusValue modbusValue = this.schemaDevice.getModbusBlock(requiredAddress.getAddressClass()).getOrCreateIfAbsent(requiredAddress);
                    modbusValue.setImmutable(fieldImmutable);
                    modbusValue.setFetchGroup(fieldFetchGroup);
                }
                fetchGroupToAddresses.computeIfAbsent(fieldFetchGroup, arg_0 -> ModbusBlockFetcher.calculateFetchGroupToAddressesMapping$lambda$1(ModbusBlockFetcher::calculateFetchGroupToAddressesMapping$lambda$0, arg_0)).addAll((Collection)requiredAddresses);
            }
        }
        for (Map.Entry entry : fetchGroupToAddresses.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            List fetchGroupAddresses = CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)value)));
            if (fetchGroupAddresses.isEmpty()) continue;
            Address firstAddress = (Address)fetchGroupAddresses.get(0);
            int numberOfAddresses = fetchGroupAddresses.size();
            Address lastAddress = (Address)fetchGroupAddresses.get(numberOfAddresses - 1);
            if (Intrinsics.areEqual((Object)firstAddress.increment(numberOfAddresses - 1), (Object)lastAddress)) continue;
            boolean bl = false;
            String string = "There are gaps in the addresses for fetch group \"" + key + "\": " + fetchGroupAddresses;
            throw new IllegalStateException(string.toString());
        }
        return fetchGroupToAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<ModbusQuery> update(@NotNull Field field, long maxAge) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        ModbusBlockFetcher modbusBlockFetcher = this;
        synchronized (modbusBlockFetcher) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = false;
            if (!field.getInitialized()) {
                boolean $i$a$-require-ModbusBlockFetcher$update$1$22 = false;
                String $i$a$-require-ModbusBlockFetcher$update$1$22 = "You cannot fetch the registers for a Field if the field has not yet been initialized. (Field ID=" + field.getId() + ")";
                throw new IllegalArgumentException($i$a$-require-ModbusBlockFetcher$update$1$22.toString());
            }
            Object $i$a$-require-ModbusBlockFetcher$update$1$22 = new SpreadBuilder(2);
            $i$a$-require-ModbusBlockFetcher$update$1$22.add((Object)field);
            Collection $this$toTypedArray$iv = field.getRequiredFields();
            boolean $i$f$toTypedArray22 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $i$a$-require-ModbusBlockFetcher$update$1$22.addSpread((Object)thisCollection$iv.toArray(new Field[0]));
            List allFields = CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.listOf((Object[])$i$a$-require-ModbusBlockFetcher$update$1$22.toArray((Object[])new Field[$i$a$-require-ModbusBlockFetcher$update$1$22.size()])))));
            $i$a$-require-ModbusBlockFetcher$update$1$22 = this.calculateModbusQueries(allFields, maxAge);
            boolean $i$f$map = false;
            void $i$f$toTypedArray22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ModbusQuery modbusQuery = (ModbusQuery)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.fetch$modbus_schema_device((ModbusQuery)it));
            }
            List list = CollectionsKt.toList((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
            return list;
        }
    }

    public static /* synthetic */ List update$default(ModbusBlockFetcher modbusBlockFetcher, Field field, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        return modbusBlockFetcher.update(field, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final List<ModbusQuery> update(long maxAge) {
        ModbusBlockFetcher modbusBlockFetcher = this;
        synchronized (modbusBlockFetcher) {
            boolean bl = false;
            List fetched = new ArrayList();
            for (ModbusQuery modbusQuery : this.calculateModbusQueries(maxAge)) {
                fetched.addAll((Collection)this.fetch$modbus_schema_device(modbusQuery));
            }
            List list = fetched;
            return list;
        }
    }

    public static /* synthetic */ List update$default(ModbusBlockFetcher modbusBlockFetcher, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return modbusBlockFetcher.update(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DiscreteBlock getDiscretes(ModbusDevice $this$getDiscretes, ModbusQuery modbusQuery) {
        long start = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        try {
            boolean bl;
            Iterable $this$any$iv;
            DiscreteBlock discreteBlock;
            block9: {
                discreteBlock = $this$getDiscretes.getDiscretes(modbusQuery.getStart(), modbusQuery.getCount());
                modbusQuery.setStatus(ModbusQuery.Status.SUCCESS);
                $this$any$iv = discreteBlock.getValues();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DiscreteValue it = (DiscreteValue)element$iv;
                        boolean bl2 = false;
                        if (!it.isReadError()) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                modbusQuery.setStatus(ModbusQuery.Status.ERROR);
            }
            $this$any$iv = discreteBlock;
            return $this$any$iv;
        }
        catch (ModbusException modbusException) {
            modbusQuery.setStatus(ModbusQuery.Status.ERROR);
            throw modbusException;
        }
        finally {
            long stop = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            modbusQuery.setDuration-BwNAW2A(Duration.box-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)stop, (long)start)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RegisterBlock getRegisters(ModbusDevice $this$getRegisters, ModbusQuery modbusQuery) {
        long start = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        try {
            boolean bl;
            Iterable $this$any$iv;
            RegisterBlock registerBlock;
            block9: {
                registerBlock = $this$getRegisters.getRegisters(modbusQuery.getStart(), modbusQuery.getCount());
                modbusQuery.setStatus(ModbusQuery.Status.SUCCESS);
                $this$any$iv = registerBlock.getValues();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RegisterValue it = (RegisterValue)element$iv;
                        boolean bl2 = false;
                        if (!it.isReadError()) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                modbusQuery.setStatus(ModbusQuery.Status.ERROR);
            }
            $this$any$iv = registerBlock;
            return $this$any$iv;
        }
        catch (ModbusException modbusException) {
            modbusQuery.setStatus(ModbusQuery.Status.ERROR);
            throw modbusException;
        }
        finally {
            long stop = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            modbusQuery.setDuration-BwNAW2A(Duration.box-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)stop, (long)start)));
        }
    }

    private final ModbusBlock<? extends ModbusBlock<?, ?, ?>, ? extends ModbusValue<?, ?>, ?> executeQuery(ModbusDevice $this$executeQuery, ModbusQuery modbusQuery) {
        ModbusBlock modbusBlock;
        switch (WhenMappings.$EnumSwitchMapping$0[modbusQuery.getType().ordinal()]) {
            case 1: {
                modbusBlock = (ModbusBlock)this.getDiscretes($this$executeQuery, modbusQuery);
                break;
            }
            case 2: {
                modbusBlock = (ModbusBlock)this.getRegisters($this$executeQuery, modbusQuery);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return modbusBlock;
    }

    private final void mergeFetched(ModbusBlock<? extends ModbusBlock<?, ?, ?>, ? extends ModbusValue<?, ?>, ?> $this$mergeFetched, ModbusBlock<?, ? extends ModbusValue<?, ?>, ?> fetchedModbusBlock) {
        ModbusBlock<ModbusBlock<?, ?, ?>, ModbusValue<?, ?>, ?> modbusBlock = $this$mergeFetched;
        if (modbusBlock instanceof DiscreteBlock && fetchedModbusBlock instanceof DiscreteBlock) {
            ((DiscreteBlock)$this$mergeFetched).merge(fetchedModbusBlock);
        } else if (modbusBlock instanceof RegisterBlock && fetchedModbusBlock instanceof RegisterBlock) {
            ((RegisterBlock)$this$mergeFetched).merge(fetchedModbusBlock);
        } else {
            throw new ModbusApiException("Type mismatch existingModbusBlock (" + $this$mergeFetched.getClass().getName() + ") and fetchedModbusBlock (" + fetchedModbusBlock.getClass().getName() + ")", null, 2, null);
        }
    }

    @NotNull
    public final List<ModbusQuery> fetch$modbus_schema_device(@NotNull ModbusQuery modbusQuery) {
        Intrinsics.checkNotNullParameter((Object)modbusQuery, (String)"modbusQuery");
        List fetchedQueries = new ArrayList();
        try {
            ModbusBlock<? extends ModbusBlock<?, ?, ?>, ? extends ModbusValue<?, ?>, ?> fetchedModbusBlock = this.executeQuery(this.modbusDevice, modbusQuery);
            fetchedQueries.add(modbusQuery);
            switch (WhenMappings.$EnumSwitchMapping$1[modbusQuery.getStatus().ordinal()]) {
                case 1: {
                    throw new ModbusApiException("This should not happen. After fetching a modbus query it is still not fetched??", null, 2, null);
                }
                case 2: {
                    this.mergeFetched(this.schemaDevice.getModbusBlock(fetchedModbusBlock.getAddressClass()), fetchedModbusBlock);
                    break;
                }
                case 3: {
                    ModbusQuery modbusQuery2 = modbusQuery;
                    if (modbusQuery2 instanceof HoleModbusQuery) {
                        this.mergeFetched(this.schemaDevice.getModbusBlock(fetchedModbusBlock.getAddressClass()), fetchedModbusBlock);
                    } else {
                        if (modbusQuery2 instanceof MergedModbusQuery) {
                            List<ModbusQuery> retries = this.retryFetchOfFailedMergedModbusQuery$modbus_schema_device((MergedModbusQuery)modbusQuery);
                            if (retries.isEmpty()) {
                                Iterable $this$forEach$iv = fetchedModbusBlock.getValues();
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    ModbusValue it = (ModbusValue)element$iv;
                                    boolean bl = false;
                                    it.setHardReadError();
                                }
                                this.mergeFetched(this.schemaDevice.getModbusBlock(fetchedModbusBlock.getAddressClass()), fetchedModbusBlock);
                            } else {
                                fetchedQueries.addAll((Collection)retries);
                            }
                            return fetchedQueries;
                        }
                        Iterable $this$forEach$iv = fetchedModbusBlock.getValues();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ModbusValue it = (ModbusValue)element$iv;
                            boolean bl = false;
                            it.setHardReadError();
                        }
                        this.mergeFetched(this.schemaDevice.getModbusBlock(fetchedModbusBlock.getAddressClass()), fetchedModbusBlock);
                    }
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (ModbusException me) {
            LOG.error("Got ModbusException on {} --> {}", (Object)modbusQuery, (Object)me);
        }
        return fetchedQueries;
    }

    @NotNull
    public List<ModbusQuery> retryFetchOfFailedMergedModbusQuery$modbus_schema_device(@NotNull MergedModbusQuery modbusQuery) {
        Intrinsics.checkNotNullParameter((Object)modbusQuery, (String)"modbusQuery");
        throw new ModbusApiException("If you create MergedModbusQuery instances then you must implement this also.", null, 2, null);
    }

    @NotNull
    public final List<ModbusQuery> calculateModbusQueries(long maxAge) {
        return this.calculateModbusQueries(this.schemaDevice.neededFields(), maxAge);
    }

    @NotNull
    public List<ModbusQuery> calculateModbusQueries(@NotNull List<Field> fields, long maxAge) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        List<Field> fieldsThatMustBeUpdated = this.allFieldsThatMustBeUpdated(fields, maxAge);
        Map<String, List<Address>> fetchGroupToAddresses = this.calculateFetchGroupToAddressesMapping();
        Map modbusQueryMap = new LinkedHashMap();
        for (Field field : fieldsThatMustBeUpdated) {
            List<Address> addresses;
            ModbusQuery modbusQuery = (ModbusQuery)modbusQueryMap.get(field.getFetchGroup());
            if (modbusQuery != null) {
                modbusQuery.addField(field);
                continue;
            }
            Intrinsics.checkNotNull(fetchGroupToAddresses.get(field.getFetchGroup()));
            modbusQuery = new ModbusQuery(addresses.get(0), addresses.size());
            modbusQuery.addField(field);
            modbusQueryMap.put(field.getFetchGroup(), modbusQuery);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)modbusQueryMap.values()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Field> allFieldsThatMustBeUpdated(List<Field> fields, long maxAge) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        long now = System.currentTimeMillis();
        Iterable iterable = fields;
        boolean $i$f$flatMap = false;
        void var8_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object v0;
            Field field;
            block4: {
                void $this$firstOrNull$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                field = (Field)element$iv$iv;
                boolean bl = false;
                if (!field.getInitialized()) {
                    boolean $i$a$-require-ModbusBlockFetcher$allFieldsThatMustBeUpdated$1$22 = false;
                    String $i$a$-require-ModbusBlockFetcher$allFieldsThatMustBeUpdated$1$22 = "You cannot fetch the registers for a Field if the field has not yet been initialized. (Field ID=" + field.getId() + ")";
                    throw new IllegalArgumentException($i$a$-require-ModbusBlockFetcher$allFieldsThatMustBeUpdated$1$22.toString());
                }
                Iterable iterable2 = field.getRequiredAddresses();
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Address address = (Address)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(this.schemaDevice.getModbusBlock(it.getAddressClass()).get((Address)it));
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ModbusValue it = (ModbusValue)element$iv;
                    boolean bl3 = false;
                    if (!it.needsToBeUpdated(now, maxAge)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Iterable list$iv$iv = v0 != null ? CollectionsKt.listOf((Object)field) : CollectionsKt.emptyList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @JvmOverloads
    @NotNull
    public final List<ModbusQuery> update() {
        return ModbusBlockFetcher.update$default(this, 0L, 1, null);
    }

    private static final List calculateFetchGroupToAddressesMapping$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List calculateFetchGroupToAddressesMapping$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher$Companion;", "", "<init>", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "modbus-schema-device"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AddressClass.Type.values().length];
            try {
                nArray[AddressClass.Type.DISCRETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressClass.Type.REGISTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ModbusQuery.Status.values().length];
            try {
                nArray[ModbusQuery.Status.NOT_FETCHED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModbusQuery.Status.SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModbusQuery.Status.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

