/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.fetcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.fetcher.HoleModbusQuery;
import nl.basjes.modbus.schema.fetcher.MergedModbusQuery;
import nl.basjes.modbus.schema.fetcher.ModbusBlockFetcher;
import nl.basjes.modbus.schema.fetcher.ModbusQuery;
import nl.basjes.modbus.schema.fetcher.OptimizingModbusBlockFetcherKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u0019J7\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0017\u001a\u00020\u00182!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u001cJ*\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tR$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lnl/basjes/modbus/schema/fetcher/OptimizingModbusBlockFetcher;", "Lnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;Lnl/basjes/modbus/device/api/ModbusDevice;)V", "value", "", "allowedGapReadSize", "getAllowedGapReadSize", "()I", "setAllowedGapReadSize", "(I)V", "calculateModbusQueries", "", "Lnl/basjes/modbus/schema/fetcher/ModbusQuery;", "fields", "Lnl/basjes/modbus/schema/Field;", "maxAge", "", "retryFetchOfFailedMergedModbusQuery", "modbusQuery", "Lnl/basjes/modbus/schema/fetcher/MergedModbusQuery;", "retryFetchOfFailedMergedModbusQuery$modbus_schema_device", "splitMergedModbusRequest", "isFull", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "query", "", "mergeQueries", "providedModbusQueries", "maxRegistersPerModbusRequest", "maxDiscretesPerModbusRequest", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nOptimizingModbusBlockFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptimizingModbusBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/OptimizingModbusBlockFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n1#2:251\n774#3:252\n865#3,2:253\n1563#3:255\n1634#3,3:256\n1563#3:259\n1634#3,3:260\n1374#3:263\n1460#3,5:264\n1374#3:269\n1460#3,5:270\n1374#3:275\n1460#3,5:276\n1563#3:281\n1634#3,3:282\n1374#3:285\n1460#3,5:286\n774#3:291\n865#3,2:292\n1563#3:294\n1634#3,3:295\n1374#3:298\n1460#3,5:299\n*S KotlinDebug\n*F\n+ 1 OptimizingModbusBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/OptimizingModbusBlockFetcher\n*L\n50#1:252\n50#1:253,2\n79#1:255\n79#1:256,3\n90#1:259\n90#1:260,3\n121#1:263\n121#1:264,5\n140#1:269\n140#1:270,5\n141#1:275\n141#1:276,5\n142#1:281\n142#1:282,3\n148#1:285\n148#1:286,5\n149#1:291\n149#1:292,2\n150#1:294\n150#1:295,3\n230#1:298\n230#1:299,5\n*E\n"})
public final class OptimizingModbusBlockFetcher
extends ModbusBlockFetcher {
    private int allowedGapReadSize;

    public OptimizingModbusBlockFetcher(@NotNull SchemaDevice schemaDevice, @NotNull ModbusDevice modbusDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        super(schemaDevice, modbusDevice);
    }

    public final int getAllowedGapReadSize() {
        return this.allowedGapReadSize;
    }

    public final void setAllowedGapReadSize(int value) {
        if (!(value >= 0)) {
            boolean bl = false;
            String string = "A negative Gap Read Size is not allowed";
            throw new IllegalArgumentException(string.toString());
        }
        this.allowedGapReadSize = value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ModbusQuery> calculateModbusQueries(@NotNull List<Field> fields, long maxAge) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        List<ModbusQuery> rawModbusQueryList = super.calculateModbusQueries(fields, maxAge);
        Iterable iterable = rawModbusQueryList;
        boolean $i$f$filter = false;
        void var8_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block2: {
                ModbusQuery it = (ModbusQuery)element$iv$iv;
                boolean bl2 = false;
                for (Field field : it.getFields()) {
                    if (!field.isUsingReadErrorRegisters()) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List baseModbusQueryList = (List)destination$iv$iv;
        return this.mergeQueries(baseModbusQueryList, this.getModbusDevice().getMaxRegistersPerModbusRequest(), this.getModbusDevice().getMaxDiscretesPerModbusRequest());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ModbusQuery> retryFetchOfFailedMergedModbusQuery$modbus_schema_device(@NotNull MergedModbusQuery modbusQuery) {
        Intrinsics.checkNotNullParameter((Object)modbusQuery, (String)"modbusQuery");
        if (modbusQuery.getModbusQueries().size() == 1) {
            return CollectionsKt.emptyList();
        }
        if (modbusQuery.getModbusQueries().size() < 4) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = modbusQuery.getModbusQueries();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ModbusQuery modbusQuery2 = (ModbusQuery)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.fetch$modbus_schema_device((ModbusQuery)it));
            }
            return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        }
        Iterable $this$map$iv = this.splitMergedModbusRequest(modbusQuery, (Function1<? super MergedModbusQuery, Boolean>)((Function1)arg_0 -> OptimizingModbusBlockFetcher.retryFetchOfFailedMergedModbusQuery$lambda$3(modbusQuery, arg_0)));
        boolean $i$f$map = false;
        Iterable $this$mapTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ModbusQuery it = (ModbusQuery)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.fetch$modbus_schema_device(it));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ModbusQuery> splitMergedModbusRequest(@NotNull MergedModbusQuery modbusQuery, @NotNull Function1<? super MergedModbusQuery, Boolean> isFull) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)modbusQuery, (String)"modbusQuery");
        Intrinsics.checkNotNullParameter(isFull, (String)"isFull");
        Iterator<ModbusQuery> modbusQueryIterator = modbusQuery.getModbusQueries().iterator();
        List result = new ArrayList();
        ModbusQuery nextInput = modbusQueryIterator.next();
        MergedModbusQuery nextModbusQuery = new MergedModbusQuery(nextInput.getStart(), nextInput.getCount());
        nextModbusQuery.add(nextInput);
        result.add(nextModbusQuery);
        while (modbusQueryIterator.hasNext()) {
            nextInput = modbusQueryIterator.next();
            MergedModbusQuery mergedModbusQuery = nextModbusQuery;
            mergedModbusQuery.setCount(mergedModbusQuery.getCount() + nextInput.getCount());
            nextModbusQuery.add(nextInput);
            if (!((Boolean)isFull.invoke((Object)nextModbusQuery)).booleanValue()) continue;
            nextModbusQuery = new MergedModbusQuery(nextInput.getStart(), nextInput.getCount());
            result.add(nextModbusQuery);
        }
        Iterable $this$flatMap$iv = result;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MergedModbusQuery it = (MergedModbusQuery)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getModbusQueries().size() > 2 ? CollectionsKt.listOf((Object)it) : it.getModbusQueries();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ModbusQuery> mergeQueries(@NotNull List<? extends ModbusQuery> providedModbusQueries, int maxRegistersPerModbusRequest, int maxDiscretesPerModbusRequest) {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable list$iv$iv;
        Comparable<ModbusQuery> it;
        Iterable $this$flatMapTo$iv$iv3;
        Iterable $this$flatMap$iv2;
        Intrinsics.checkNotNullParameter(providedModbusQueries, (String)"providedModbusQueries");
        if (providedModbusQueries.size() == 1) {
            return providedModbusQueries;
        }
        Iterable iterable = providedModbusQueries;
        boolean $i$f$flatMap = false;
        void var7_7 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv3) {
            it = (ModbusQuery)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((ModbusQuery)it).getFields();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv3 = $this$flatMap$iv2;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv3) {
            it = (Field)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((Field)it).getRequiredAddresses();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$flatMapTo$iv$iv3 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            list$iv$iv = (Address)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAddressClass());
        }
        List usedAddressClasses = CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)));
        Iterable $i$f$map22 = usedAddressClasses;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            AddressClass it2 = (AddressClass)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv2 = this.getSchemaDevice().getModbusBlock(it2).getValues();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModbusValue it3 = (ModbusValue)element$iv$iv;
            boolean bl = false;
            if (!it3.isReadError()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ModbusValue it3 = (ModbusValue)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it3.getAddress());
        }
        List readErrorAddresses = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        Iterator<ModbusQuery> modbusQueryIterator = providedModbusQueries.iterator();
        if (!modbusQueryIterator.hasNext()) {
            return CollectionsKt.emptyList();
        }
        List result = new ArrayList();
        ModbusQuery nextInput = modbusQueryIterator.next();
        MergedModbusQuery nextModbusQuery = new MergedModbusQuery(nextInput.getStart(), nextInput.getCount());
        nextModbusQuery.add(nextInput);
        result.add(nextModbusQuery);
        while (modbusQueryIterator.hasNext()) {
            int n;
            nextInput = modbusQueryIterator.next();
            if (nextModbusQuery.getStart().getAddressClass() != nextInput.getStart().getAddressClass()) {
                nextModbusQuery = new MergedModbusQuery(nextInput.getStart(), nextInput.getCount());
                nextModbusQuery.add(nextInput);
                result.add(nextModbusQuery);
                continue;
            }
            Address firstAfterNextQuery = nextModbusQuery.getStart().increment(nextModbusQuery.getCount());
            switch (WhenMappings.$EnumSwitchMapping$0[nextModbusQuery.getType().ordinal()]) {
                case 1: {
                    n = maxDiscretesPerModbusRequest;
                    break;
                }
                case 2: {
                    n = maxRegistersPerModbusRequest;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int maxCountPerRequest = n;
            if (Intrinsics.areEqual((Object)nextInput.getStart(), (Object)firstAfterNextQuery)) {
                if (nextModbusQuery.getCount() + nextInput.getCount() <= maxCountPerRequest) {
                    MergedModbusQuery item$iv$iv = nextModbusQuery;
                    item$iv$iv.setCount(item$iv$iv.getCount() + nextInput.getCount());
                    nextModbusQuery.add(nextInput);
                    continue;
                }
                nextModbusQuery = new MergedModbusQuery(nextInput.getStart(), nextInput.getCount());
                nextModbusQuery.add(nextInput);
                result.add(nextModbusQuery);
                continue;
            }
            int nextBatchStart = nextModbusQuery.getStart().getPhysicalAddress();
            int nextInputStart = nextInput.getStart().getPhysicalAddress();
            int gapSize = nextInputStart - (nextBatchStart + nextModbusQuery.getCount());
            int mergedCount = nextInputStart + nextInput.getCount() - nextBatchStart;
            if (gapSize <= this.allowedGapReadSize && mergedCount <= maxCountPerRequest && !OptimizingModbusBlockFetcherKt.overlaps(readErrorAddresses, nextModbusQuery.getStart(), mergedCount)) {
                nextModbusQuery.add(new HoleModbusQuery(firstAfterNextQuery, gapSize));
                nextModbusQuery.setCount(mergedCount);
                nextModbusQuery.add(nextInput);
                continue;
            }
            nextModbusQuery = new MergedModbusQuery(nextInput.getStart(), nextInput.getCount());
            nextModbusQuery.add(nextInput);
            result.add(nextModbusQuery);
        }
        Iterable $this$flatMap$iv3 = result;
        boolean $i$f$flatMap3 = false;
        Iterable nextBatchStart = $this$flatMap$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo3 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ModbusQuery it4 = (ModbusQuery)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv3 = !(it4 instanceof MergedModbusQuery) || ((MergedModbusQuery)it4).getModbusQueries().size() > 2 ? CollectionsKt.listOf((Object)it4) : ((MergedModbusQuery)it4).getModbusQueries();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv3);
        }
        return (List)destination$iv$iv3;
    }

    private static final boolean retryFetchOfFailedMergedModbusQuery$lambda$3(MergedModbusQuery $modbusQuery, MergedModbusQuery it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getModbusQueries().size() > $modbusQuery.getModbusQueries().size() / 2;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AddressClass.Type.values().length];
            try {
                nArray[AddressClass.Type.DISCRETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressClass.Type.REGISTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

