/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.utils.DoubleToString;
import nl.basjes.modbus.schema.utils.StringTable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u001a$\u0010\u0000\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a$\u0010\u0000\u001a\u00020\u0006*\u00020\t2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\n\u001a\u00020\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a$\u0010\u0000\u001a\u00020\u0006*\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u000e"}, d2={"toTable", "", "Lnl/basjes/modbus/schema/SchemaDevice;", "onlyUseFullFields", "", "includeRawDataAndMappings", "", "table", "Lnl/basjes/modbus/schema/utils/StringTable;", "Lnl/basjes/modbus/schema/Block;", "trunc", "maxChars", "", "Lnl/basjes/modbus/schema/Field;", "modbus-schema-device"})
public final class SchemaDeviceToTableKt {
    @NotNull
    public static final String toTable(@NotNull SchemaDevice $this$toTable, boolean onlyUseFullFields, boolean includeRawDataAndMappings) {
        StringTable stringTable;
        Intrinsics.checkNotNullParameter((Object)$this$toTable, (String)"<this>");
        StringTable table = new StringTable();
        if (includeRawDataAndMappings) {
            String[] stringArray = new String[]{"Block Id", "Field Id", "System", "Description", "Value", "Unit", "Expression", "Fetch Group", "Raw Bytes"};
            stringTable = table.withHeaders(stringArray);
        } else {
            String[] stringArray = new String[]{"Block Id", "Field Id", "System", "Description", "Value", "Unit"};
            stringTable = table.withHeaders(stringArray);
        }
        SchemaDeviceToTableKt.toTable($this$toTable, table, onlyUseFullFields, includeRawDataAndMappings);
        return table.toString();
    }

    public static /* synthetic */ String toTable$default(SchemaDevice schemaDevice, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return SchemaDeviceToTableKt.toTable(schemaDevice, bl, bl2);
    }

    private static final void toTable(SchemaDevice $this$toTable, StringTable table, boolean onlyUseFullFields, boolean includeRawDataAndMappings) {
        boolean first = true;
        for (Block block : $this$toTable.getBlocks()) {
            if (!first) {
                table.addRowSeparator();
            }
            first = false;
            SchemaDeviceToTableKt.toTable(block, table, onlyUseFullFields, includeRawDataAndMappings);
        }
    }

    private static final void toTable(Block $this$toTable, StringTable table, boolean onlyUseFullFields, boolean includeRawDataAndMappings) {
        String[] stringArray = new String[4];
        stringArray[0] = $this$toTable.getId();
        stringArray[1] = "";
        stringArray[2] = "";
        String string = $this$toTable.getDescription();
        if (string == null) {
            string = "";
        }
        stringArray[3] = string;
        table.addRow(stringArray);
        for (Field field : $this$toTable.getFields()) {
            SchemaDeviceToTableKt.toTable(field, table, onlyUseFullFields, includeRawDataAndMappings);
        }
    }

    private static final String trunc(String $this$trunc, int maxChars) {
        if ($this$trunc == null) {
            return "<<null>>";
        }
        if (maxChars < 5 || $this$trunc.length() <= maxChars) {
            return $this$trunc;
        }
        String string = $this$trunc.substring(0, maxChars - 4);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string + " ...";
    }

    private static final void toTable(Field $this$toTable, StringTable table, boolean onlyUseFullFields, boolean includeRawDataAndMappings) {
        StringTable stringTable;
        if (onlyUseFullFields && $this$toTable.isSystem()) {
            return;
        }
        Object value = null;
        try {
            value = $this$toTable.getValue();
        }
        catch (ModbusException modbusException) {
            if (onlyUseFullFields) {
                return;
            }
            value = "<<ERROR>>";
        }
        if (value == null) {
            if (onlyUseFullFields) {
                return;
            }
            value = "<<Not Implemented>>";
        } else {
            if (value instanceof Double) {
                value = DoubleToString.INSTANCE.of((Double)value, 5L);
            } else if (value instanceof String) {
                if (onlyUseFullFields && ((CharSequence)value).length() == 0) {
                    return;
                }
                value = "\"" + value + "\"";
            }
            if (value instanceof List) {
                value = "[" + CollectionsKt.joinToString$default((Iterable)((Iterable)value), (CharSequence)",", null, null, (int)0, null, SchemaDeviceToTableKt::toTable$lambda$0, (int)30, null) + "]";
            }
        }
        String expressionString = null;
        if ($this$toTable.getParsedExpression() == null) {
            if (onlyUseFullFields) {
                return;
            }
            expressionString = "-------";
        } else {
            expressionString = SchemaDeviceToTableKt.trunc(String.valueOf($this$toTable.getParsedExpression()), 50);
        }
        String bytes = "";
        if ($this$toTable.getParsedExpression() != null) {
            Expression expression = $this$toTable.getParsedExpression();
            Intrinsics.checkNotNull((Object)expression);
            bytes = CollectionsKt.joinToString$default((Iterable)expression.getModbusValues($this$toTable.getBlock().getSchemaDevice()), (CharSequence)" ", null, null, (int)0, null, SchemaDeviceToTableKt::toTable$lambda$1, (int)30, null);
        }
        String truncatedDescription = SchemaDeviceToTableKt.trunc($this$toTable.getDescription(), 75);
        if (includeRawDataAndMappings) {
            String[] stringArray = new String[]{$this$toTable.getBlock().getId(), $this$toTable.getId(), $this$toTable.isSystem() ? "*" : "", truncatedDescription, SchemaDeviceToTableKt.trunc(value.toString(), 50), $this$toTable.getUnit(), expressionString, $this$toTable.getFetchGroup(), bytes};
            stringTable = table.addRow(stringArray);
        } else {
            String[] stringArray = new String[]{$this$toTable.getBlock().getId(), $this$toTable.getId(), $this$toTable.isSystem() ? "*" : "", truncatedDescription, SchemaDeviceToTableKt.trunc(value.toString(), 50), $this$toTable.getUnit()};
            stringTable = table.addRow(stringArray);
        }
    }

    private static final CharSequence toTable$lambda$0(Object it) {
        return String.valueOf(it);
    }

    private static final CharSequence toTable$lambda$1(ModbusValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getAsString();
    }
}

