/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.booleans;

import java.util.BitSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.booleans.BooleanExpression;
import nl.basjes.modbus.schema.expression.generic.NotImplemented;
import nl.basjes.modbus.schema.expression.registers.RegistersExpression;
import nl.basjes.modbus.schema.utils.ByteConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u0007H\u0016J\u001e\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030!0\u00062\u0006\u0010\"\u001a\u00020#H\u0016J\u0017\u0010$\u001a\u0004\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012\u00a8\u0006&"}, d2={"Lnl/basjes/modbus/schema/expression/booleans/BooleanBitset;", "Lnl/basjes/modbus/schema/expression/generic/NotImplemented;", "Lnl/basjes/modbus/schema/expression/booleans/BooleanExpression;", "addresses", "Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "notImplemented", "", "", "bitNr", "", "<init>", "(Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;Ljava/util/List;I)V", "getBitNr", "()I", "toString", "subExpressions", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "returnType", "Lnl/basjes/modbus/schema/ReturnType;", "getReturnType", "()Lnl/basjes/modbus/schema/ReturnType;", "value", "", "isImmutable", "()Z", "setImmutable", "(Z)V", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getModbusValues", "Lnl/basjes/modbus/device/api/ModbusValue;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "getBoolean", "(Lnl/basjes/modbus/schema/SchemaDevice;)Ljava/lang/Boolean;", "modbus-schema-device"})
public final class BooleanBitset
extends NotImplemented
implements BooleanExpression {
    @NotNull
    private final RegistersExpression addresses;
    private final int bitNr;

    public BooleanBitset(@NotNull RegistersExpression addresses, @NotNull List<String> notImplemented, int bitNr) {
        Intrinsics.checkNotNullParameter((Object)addresses, (String)"addresses");
        Intrinsics.checkNotNullParameter(notImplemented, (String)"notImplemented");
        super(addresses.getReturnedAddresses(), notImplemented);
        this.addresses = addresses;
        this.bitNr = bitNr;
    }

    public final int getBitNr() {
        return this.bitNr;
    }

    @Override
    @NotNull
    public String toString() {
        return "bitsetbit(" + this.addresses + super.toString() + " ; " + this.bitNr + ")";
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return CollectionsKt.listOf((Object)this.addresses);
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return ReturnType.BOOLEAN;
    }

    @Override
    public boolean isImmutable() {
        return this.addresses.isImmutable();
    }

    @Override
    public void setImmutable(boolean value) {
        this.addresses.setImmutable(value);
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{this.checkFatal(this.addresses.getReturnedAddresses() > 0, "No registers"), this.checkFatal(this.addresses.getReturnedAddresses() <= 4, "Too many registers"), this.checkFatal(this.bitNr >= 0, "Negative bitNr requested"), this.checkFatal(this.bitNr < this.addresses.getReturnedAddresses() * 2 * 8, "The requested bitNr " + this.bitNr + " is larger than the maximum of " + (this.addresses.getReturnedAddresses() * 2 * 8 - 1)), BooleanExpression.super.getProblems(), super.getProblems()};
        return this.combine("bitsetbit", listArray);
    }

    @Override
    @NotNull
    public List<ModbusValue<?, ?>> getModbusValues(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.addresses.getModbusValues(schemaDevice);
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        byte[] bytes = this.addresses.getByteArray(schemaDevice);
        if (bytes == null || bytes.length == 0 || this.isNotImplemented(bytes)) {
            return null;
        }
        ByteConversions.INSTANCE.reverse(bytes);
        BitSet bitSet = BitSet.valueOf(bytes);
        return bitSet.get(this.bitNr);
    }
}

