/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.numbers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.generic.NotImplemented;
import nl.basjes.modbus.schema.expression.numbers.NumericalExpression;
import nl.basjes.modbus.schema.expression.registers.RegistersExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u0004H\u0016J\u001e\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f0\n2\u0006\u0010 \u001a\u00020!H\u0016J\u0017\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010 \u001a\u00020!H&\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011\u00a8\u0006%"}, d2={"Lnl/basjes/modbus/schema/expression/numbers/IntegerSigned;", "Lnl/basjes/modbus/schema/expression/generic/NotImplemented;", "Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;", "name", "", "bytesPerValue", "", "registersExpression", "Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "notImplemented", "", "<init>", "(Ljava/lang/String;ILnl/basjes/modbus/schema/expression/registers/RegistersExpression;Ljava/util/List;)V", "toString", "subExpressions", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "isImmutable", "", "()Z", "setImmutable", "(Z)V", "returnType", "Lnl/basjes/modbus/schema/ReturnType;", "getReturnType", "()Lnl/basjes/modbus/schema/ReturnType;", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getModbusValues", "Lnl/basjes/modbus/device/api/ModbusValue;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "getValueAsLong", "", "(Lnl/basjes/modbus/schema/SchemaDevice;)Ljava/lang/Long;", "modbus-schema-device"})
public abstract class IntegerSigned
extends NotImplemented
implements NumericalExpression {
    @NotNull
    private final String name;
    private final int bytesPerValue;
    @NotNull
    private final RegistersExpression registersExpression;
    private boolean isImmutable;

    public IntegerSigned(@NotNull String name, int bytesPerValue, @NotNull RegistersExpression registersExpression, @NotNull List<String> notImplemented) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)registersExpression, (String)"registersExpression");
        Intrinsics.checkNotNullParameter(notImplemented, (String)"notImplemented");
        super(bytesPerValue / 2, notImplemented);
        this.name = name;
        this.bytesPerValue = bytesPerValue;
        this.registersExpression = registersExpression;
        this.isImmutable = this.registersExpression.isImmutable();
    }

    @Override
    @NotNull
    public String toString() {
        return this.name + "(" + this.registersExpression + super.toString() + ")";
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return CollectionsKt.listOf((Object)this.registersExpression);
    }

    @Override
    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public void setImmutable(boolean bl) {
        this.isImmutable = bl;
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return ReturnType.LONG;
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{NumericalExpression.super.getProblems(), super.getProblems(), this.checkFatal(this.registersExpression.getReturnedAddresses() == this.bytesPerValue / 2, "Wrong number of registers: Got " + this.registersExpression.getReturnedAddresses() + ", need " + this.bytesPerValue / 2)};
        return this.combine(this.name, listArray);
    }

    @Override
    @NotNull
    public List<ModbusValue<?, ?>> getModbusValues(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.registersExpression.getModbusValues(schemaDevice);
    }

    @Override
    @Nullable
    public abstract Long getValueAsLong(@NotNull SchemaDevice var1);

    @Override
    @Nullable
    public Double getValueAsDouble(@NotNull SchemaDevice schemaDevice) {
        return NumericalExpression.super.getValueAsDouble(schemaDevice);
    }

    @Override
    @NotNull
    public NumericalExpression.ValueGuarantee getGuarantee() {
        return NumericalExpression.super.getGuarantee();
    }
}

