/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.strings;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.booleans.BooleanExpression;
import nl.basjes.modbus.schema.expression.strings.StringExpression;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lnl/basjes/modbus/schema/expression/strings/StringFromBoolean;", "Lnl/basjes/modbus/schema/expression/strings/StringExpression;", "booleanExpression", "Lnl/basjes/modbus/schema/expression/booleans/BooleanExpression;", "zeroString", "", "oneString", "<init>", "(Lnl/basjes/modbus/schema/expression/booleans/BooleanExpression;Ljava/lang/String;Ljava/lang/String;)V", "getBooleanExpression", "()Lnl/basjes/modbus/schema/expression/booleans/BooleanExpression;", "getZeroString", "()Ljava/lang/String;", "getOneString", "toString", "subExpressions", "", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "getValue", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "modbus-schema-device"})
public final class StringFromBoolean
implements StringExpression {
    @NotNull
    private final BooleanExpression booleanExpression;
    @NotNull
    private final String zeroString;
    @NotNull
    private final String oneString;

    public StringFromBoolean(@NotNull BooleanExpression booleanExpression, @NotNull String zeroString, @NotNull String oneString) {
        Intrinsics.checkNotNullParameter((Object)booleanExpression, (String)"booleanExpression");
        Intrinsics.checkNotNullParameter((Object)zeroString, (String)"zeroString");
        Intrinsics.checkNotNullParameter((Object)oneString, (String)"oneString");
        this.booleanExpression = booleanExpression;
        this.zeroString = zeroString;
        this.oneString = oneString;
    }

    @NotNull
    public final BooleanExpression getBooleanExpression() {
        return this.booleanExpression;
    }

    @NotNull
    public final String getZeroString() {
        return this.zeroString;
    }

    @NotNull
    public final String getOneString() {
        return this.oneString;
    }

    @NotNull
    public String toString() {
        return "boolean( " + this.booleanExpression + " ; '" + this.zeroString + "' ; '" + this.oneString + "' )";
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return CollectionsKt.listOf((Object)this.booleanExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getValue(@NotNull SchemaDevice schemaDevice) {
        String string;
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        if (WhenMappings.$EnumSwitchMapping$0[this.booleanExpression.getReturnType().ordinal()] != 1) throw new IllegalStateException(("Should never have a BooleanExpression that returns a " + this.booleanExpression.getReturnType()).toString());
        Boolean bl = this.booleanExpression.getBoolean(schemaDevice);
        if (bl == null) {
            return "";
        }
        if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            string = this.zeroString;
            return string;
        } else {
            if (!Intrinsics.areEqual((Object)bl, (Object)true)) throw new NoWhenBranchMatchedException();
            string = this.oneString;
        }
        return string;
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{StringExpression.super.getProblems()};
        return this.combine("StringFromBoolean", listArray);
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return StringExpression.super.getReturnType();
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return StringExpression.super.toString(isTop);
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        return StringExpression.super.initialize(containingField);
    }

    @Override
    @NotNull
    public List<Address> getRequiredAddresses() {
        return StringExpression.super.getRequiredAddresses();
    }

    @Override
    @NotNull
    public List<Address> getRequiredMutableAddresses() {
        return StringExpression.super.getRequiredMutableAddresses();
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return StringExpression.super.getRequiredFields();
    }

    @Override
    public boolean isImmutable() {
        return StringExpression.super.isImmutable();
    }

    @Override
    public void setImmutable(boolean value) {
        StringExpression.super.setImmutable(value);
    }

    @Override
    @NotNull
    public List<ModbusValue<?, ?>> getModbusValues(@NotNull SchemaDevice schemaDevice) {
        return StringExpression.super.getModbusValues(schemaDevice);
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return StringExpression.super.check(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return StringExpression.super.checkFatal(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return StringExpression.super.combine(function, problems);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReturnType.values().length];
            try {
                nArray[ReturnType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

