/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.fetcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.DiscreteBlock;
import nl.basjes.modbus.device.api.DiscreteValue;
import nl.basjes.modbus.device.api.ModbusBlock;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusApiException;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.fetcher.HoleModbusQuery;
import nl.basjes.modbus.schema.fetcher.MergedModbusQuery;
import nl.basjes.modbus.schema.fetcher.ModbusQuery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rH\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J<\u0010\u001d\u001a*\u0012\u0012\b\u0001\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f\u0012\u0002\b\u00030\u001e*\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0013H\u0002JT\u0010 \u001a\u00020!**\u0012\u0012\b\u0001\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f\u0012\u0002\b\u00030\u001e2\u001e\u0010\"\u001a\u001a\u0012\u0002\b\u0003\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f\u0012\u0002\b\u00030\u001eH\u0002J\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001a\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b$J\u001b\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001a\u001a\u00020&H\u0010\u00a2\u0006\u0002\b'J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u0017J$\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006,"}, d2={"Lnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher;", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;Lnl/basjes/modbus/device/api/ModbusDevice;)V", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "getModbusDevice", "()Lnl/basjes/modbus/device/api/ModbusDevice;", "calculateFetchGroupToAddressesMapping", "", "", "", "Lnl/basjes/modbus/device/api/Address;", "update", "", "Lnl/basjes/modbus/schema/fetcher/ModbusQuery;", "field", "Lnl/basjes/modbus/schema/Field;", "maxAge", "", "getDiscretes", "Lnl/basjes/modbus/device/api/DiscreteBlock;", "modbusQuery", "getRegisters", "Lnl/basjes/modbus/device/api/RegisterBlock;", "executeQuery", "Lnl/basjes/modbus/device/api/ModbusBlock;", "Lnl/basjes/modbus/device/api/ModbusValue;", "mergeFetched", "", "fetchedModbusBlock", "fetch", "fetch$modbus_schema_device", "retryFetchOfFailedMergedModbusQuery", "Lnl/basjes/modbus/schema/fetcher/MergedModbusQuery;", "retryFetchOfFailedMergedModbusQuery$modbus_schema_device", "calculateModbusQueries", "fields", "allFieldsThatMustBeUpdated", "Companion", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nModbusBlockFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModbusBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,342:1\n1#2:343\n1#2:405\n1#2:418\n37#3:344\n36#3,3:345\n1563#4:348\n1634#4,3:349\n1761#4,3:352\n1761#4,3:355\n1869#4,2:358\n1869#4,2:360\n1374#4:362\n1460#4,2:363\n1563#4:365\n1634#4,3:366\n1462#4,3:369\n1491#4:372\n1516#4,3:373\n1519#4,3:383\n1252#4,2:388\n1563#4:390\n1634#4,3:391\n1255#4:394\n1617#4,9:395\n1869#4:404\n1870#4:406\n1626#4:407\n1617#4,9:408\n1869#4:417\n1870#4:419\n1626#4:420\n1374#4:421\n1460#4,2:422\n1563#4:424\n1634#4,3:425\n295#4,2:428\n1462#4,3:430\n382#5,7:376\n463#5:386\n413#5:387\n*S KotlinDebug\n*F\n+ 1 ModbusBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher\n*L\n284#1:405\n285#1:418\n97#1:344\n97#1:345,3\n100#1:348\n100#1:349,3\n127#1:352,3\n146#1:355,3\n209#1:358,2\n222#1:360,2\n271#1:362\n271#1:363,2\n271#1:365\n271#1:366,3\n271#1:369,3\n272#1:372\n272#1:373,3\n272#1:383,3\n273#1:388,2\n273#1:390\n273#1:391,3\n273#1:394\n284#1:395,9\n284#1:404\n284#1:406\n284#1:407\n285#1:408,9\n285#1:417\n285#1:419\n285#1:420\n319#1:421\n319#1:422,2\n326#1:424\n326#1:425,3\n327#1:428,2\n319#1:430,3\n272#1:376,7\n273#1:386\n273#1:387\n*E\n"})
public class ModbusBlockFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaDevice schemaDevice;
    @NotNull
    private final ModbusDevice modbusDevice;
    @NotNull
    private static final Logger LOG;

    public ModbusBlockFetcher(@NotNull SchemaDevice schemaDevice, @NotNull ModbusDevice modbusDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        this.schemaDevice = schemaDevice;
        this.modbusDevice = modbusDevice;
    }

    @NotNull
    protected final SchemaDevice getSchemaDevice() {
        return this.schemaDevice;
    }

    @NotNull
    protected final ModbusDevice getModbusDevice() {
        return this.modbusDevice;
    }

    private final Map<String, Set<Address>> calculateFetchGroupToAddressesMapping() {
        Map fetchGroupToAddresses = new TreeMap();
        for (Block entry : this.schemaDevice.getBlocks()) {
            for (Field field : entry.getFields()) {
                String fieldFetchGroup = field.getFetchGroup();
                boolean fieldImmutable = field.isImmutable();
                List<Address> requiredAddresses = field.getRequiredAddresses();
                for (Address requiredAddress : requiredAddresses) {
                    ModbusValue modbusValue = this.schemaDevice.getModbusBlock(requiredAddress.getAddressClass()).getOrCreateIfAbsent(requiredAddress);
                    modbusValue.setImmutable(fieldImmutable);
                    modbusValue.setFetchGroup(fieldFetchGroup);
                }
                fetchGroupToAddresses.computeIfAbsent(fieldFetchGroup, arg_0 -> ModbusBlockFetcher.calculateFetchGroupToAddressesMapping$lambda$1(ModbusBlockFetcher::calculateFetchGroupToAddressesMapping$lambda$0, arg_0)).addAll((Collection)requiredAddresses);
            }
        }
        for (Map.Entry entry : fetchGroupToAddresses.entrySet()) {
            String key = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            List fetchGroupAddresses = CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)value)));
            if (fetchGroupAddresses.isEmpty()) continue;
            Address firstAddress = (Address)fetchGroupAddresses.get(0);
            int numberOfAddresses = fetchGroupAddresses.size();
            Address lastAddress = (Address)fetchGroupAddresses.get(numberOfAddresses - 1);
            if (Intrinsics.areEqual((Object)firstAddress.increment(numberOfAddresses - 1), (Object)lastAddress)) continue;
            boolean bl = false;
            String string = "There are gaps in the addresses for fetch group \"" + key + "\": " + fetchGroupAddresses;
            throw new IllegalStateException(string.toString());
        }
        return fetchGroupToAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<ModbusQuery> update(@NotNull Field field, long maxAge) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        ModbusBlockFetcher modbusBlockFetcher = this;
        synchronized (modbusBlockFetcher) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = false;
            if (!field.getInitialized()) {
                boolean $i$a$-require-ModbusBlockFetcher$update$1$22 = false;
                String $i$a$-require-ModbusBlockFetcher$update$1$22 = "You cannot fetch the registers for a Field if the field has not yet been initialized. (Field ID=" + field.getId() + ")";
                throw new IllegalArgumentException($i$a$-require-ModbusBlockFetcher$update$1$22.toString());
            }
            Object $i$a$-require-ModbusBlockFetcher$update$1$22 = new SpreadBuilder(2);
            $i$a$-require-ModbusBlockFetcher$update$1$22.add((Object)field);
            Collection $this$toTypedArray$iv = field.getRequiredFields();
            boolean $i$f$toTypedArray22 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $i$a$-require-ModbusBlockFetcher$update$1$22.addSpread((Object)thisCollection$iv.toArray(new Field[0]));
            List allFields = CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.listOf((Object[])$i$a$-require-ModbusBlockFetcher$update$1$22.toArray((Object[])new Field[$i$a$-require-ModbusBlockFetcher$update$1$22.size()])))));
            $i$a$-require-ModbusBlockFetcher$update$1$22 = this.calculateModbusQueries(allFields, maxAge);
            boolean $i$f$map = false;
            void $i$f$toTypedArray22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ModbusQuery modbusQuery = (ModbusQuery)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.fetch$modbus_schema_device((ModbusQuery)it));
            }
            List list = CollectionsKt.toList((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
            return list;
        }
    }

    public static /* synthetic */ List update$default(ModbusBlockFetcher modbusBlockFetcher, Field field, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        return modbusBlockFetcher.update(field, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final List<ModbusQuery> update(long maxAge) {
        ModbusBlockFetcher modbusBlockFetcher = this;
        synchronized (modbusBlockFetcher) {
            boolean bl = false;
            List fetched = new ArrayList();
            for (ModbusQuery modbusQuery : this.calculateModbusQueries(maxAge)) {
                fetched.addAll((Collection)this.fetch$modbus_schema_device(modbusQuery));
            }
            List list = fetched;
            return list;
        }
    }

    public static /* synthetic */ List update$default(ModbusBlockFetcher modbusBlockFetcher, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return modbusBlockFetcher.update(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DiscreteBlock getDiscretes(ModbusDevice $this$getDiscretes, ModbusQuery modbusQuery) {
        long start = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        try {
            boolean bl;
            Iterable $this$any$iv;
            DiscreteBlock discreteBlock;
            block9: {
                discreteBlock = $this$getDiscretes.getDiscretes(modbusQuery.getStart(), modbusQuery.getCount());
                modbusQuery.setStatus(ModbusQuery.Status.SUCCESS);
                $this$any$iv = discreteBlock.getValues();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DiscreteValue it = (DiscreteValue)element$iv;
                        boolean bl2 = false;
                        if (!it.isReadError()) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                modbusQuery.setStatus(ModbusQuery.Status.ERROR);
            }
            $this$any$iv = discreteBlock;
            return $this$any$iv;
        }
        catch (ModbusException modbusException) {
            modbusQuery.setStatus(ModbusQuery.Status.ERROR);
            throw modbusException;
        }
        finally {
            long stop = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            modbusQuery.setDuration-BwNAW2A(Duration.box-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)stop, (long)start)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RegisterBlock getRegisters(ModbusDevice $this$getRegisters, ModbusQuery modbusQuery) {
        long start = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        try {
            boolean bl;
            Iterable $this$any$iv;
            RegisterBlock registerBlock;
            block9: {
                registerBlock = $this$getRegisters.getRegisters(modbusQuery.getStart(), modbusQuery.getCount());
                modbusQuery.setStatus(ModbusQuery.Status.SUCCESS);
                $this$any$iv = registerBlock.getValues();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RegisterValue it = (RegisterValue)element$iv;
                        boolean bl2 = false;
                        if (!it.isReadError()) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                modbusQuery.setStatus(ModbusQuery.Status.ERROR);
            }
            $this$any$iv = registerBlock;
            return $this$any$iv;
        }
        catch (ModbusException modbusException) {
            modbusQuery.setStatus(ModbusQuery.Status.ERROR);
            throw modbusException;
        }
        finally {
            long stop = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            modbusQuery.setDuration-BwNAW2A(Duration.box-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)stop, (long)start)));
        }
    }

    private final ModbusBlock<? extends ModbusBlock<?, ?, ?>, ? extends ModbusValue<?, ?>, ?> executeQuery(ModbusDevice $this$executeQuery, ModbusQuery modbusQuery) {
        ModbusBlock modbusBlock;
        switch (WhenMappings.$EnumSwitchMapping$0[modbusQuery.getType().ordinal()]) {
            case 1: {
                modbusBlock = (ModbusBlock)this.getDiscretes($this$executeQuery, modbusQuery);
                break;
            }
            case 2: {
                modbusBlock = (ModbusBlock)this.getRegisters($this$executeQuery, modbusQuery);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return modbusBlock;
    }

    private final void mergeFetched(ModbusBlock<? extends ModbusBlock<?, ?, ?>, ? extends ModbusValue<?, ?>, ?> $this$mergeFetched, ModbusBlock<?, ? extends ModbusValue<?, ?>, ?> fetchedModbusBlock) {
        ModbusBlock<ModbusBlock<?, ?, ?>, ModbusValue<?, ?>, ?> modbusBlock = $this$mergeFetched;
        if (modbusBlock instanceof DiscreteBlock && fetchedModbusBlock instanceof DiscreteBlock) {
            ((DiscreteBlock)$this$mergeFetched).merge(fetchedModbusBlock);
        } else if (modbusBlock instanceof RegisterBlock && fetchedModbusBlock instanceof RegisterBlock) {
            ((RegisterBlock)$this$mergeFetched).merge(fetchedModbusBlock);
        } else {
            throw new ModbusApiException("Type mismatch existingModbusBlock (" + $this$mergeFetched.getClass().getName() + ") and fetchedModbusBlock (" + fetchedModbusBlock.getClass().getName() + ")", null, 2, null);
        }
    }

    @NotNull
    public final List<ModbusQuery> fetch$modbus_schema_device(@NotNull ModbusQuery modbusQuery) {
        Intrinsics.checkNotNullParameter((Object)modbusQuery, (String)"modbusQuery");
        List fetchedQueries = new ArrayList();
        try {
            ModbusBlock<? extends ModbusBlock<?, ?, ?>, ? extends ModbusValue<?, ?>, ?> fetchedModbusBlock = this.executeQuery(this.modbusDevice, modbusQuery);
            fetchedQueries.add(modbusQuery);
            switch (WhenMappings.$EnumSwitchMapping$1[modbusQuery.getStatus().ordinal()]) {
                case 1: {
                    throw new ModbusApiException("This should not happen. After fetching a modbus query it is still not fetched??", null, 2, null);
                }
                case 2: {
                    this.mergeFetched(this.schemaDevice.getModbusBlock(fetchedModbusBlock.getAddressClass()), fetchedModbusBlock);
                    break;
                }
                case 3: {
                    ModbusQuery modbusQuery2 = modbusQuery;
                    if (modbusQuery2 instanceof HoleModbusQuery) {
                        this.mergeFetched(this.schemaDevice.getModbusBlock(fetchedModbusBlock.getAddressClass()), fetchedModbusBlock);
                    } else {
                        if (modbusQuery2 instanceof MergedModbusQuery) {
                            List<ModbusQuery> retries = this.retryFetchOfFailedMergedModbusQuery$modbus_schema_device((MergedModbusQuery)modbusQuery);
                            if (retries.isEmpty()) {
                                Iterable $this$forEach$iv = fetchedModbusBlock.getValues();
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    ModbusValue it = (ModbusValue)element$iv;
                                    boolean bl = false;
                                    it.setHardReadError();
                                }
                                this.mergeFetched(this.schemaDevice.getModbusBlock(fetchedModbusBlock.getAddressClass()), fetchedModbusBlock);
                            } else {
                                fetchedQueries.addAll((Collection)retries);
                            }
                            return fetchedQueries;
                        }
                        Iterable $this$forEach$iv = fetchedModbusBlock.getValues();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ModbusValue it = (ModbusValue)element$iv;
                            boolean bl = false;
                            it.setHardReadError();
                        }
                        this.mergeFetched(this.schemaDevice.getModbusBlock(fetchedModbusBlock.getAddressClass()), fetchedModbusBlock);
                    }
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (ModbusException me) {
            LOG.error("Got ModbusException on {} --> {}", (Object)modbusQuery, (Object)me);
        }
        return fetchedQueries;
    }

    @NotNull
    public List<ModbusQuery> retryFetchOfFailedMergedModbusQuery$modbus_schema_device(@NotNull MergedModbusQuery modbusQuery) {
        Intrinsics.checkNotNullParameter((Object)modbusQuery, (String)"modbusQuery");
        throw new ModbusApiException("If you create MergedModbusQuery instances then you must implement this also.", null, 2, null);
    }

    @NotNull
    public final List<ModbusQuery> calculateModbusQueries(long maxAge) {
        return this.calculateModbusQueries(this.schemaDevice.neededFields(), maxAge);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ModbusQuery> calculateModbusQueries(@NotNull List<Field> fields, long maxAge) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        Object list$iv$iv;
        Iterable address;
        Pair it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        List<Field> fieldsThatMustBeUpdated = this.allFieldsThatMustBeUpdated(fields, maxAge);
        Map<String, Set<Address>> fetchGroupToAddresses = this.calculateFetchGroupToAddressesMapping();
        Iterable iterable = MapsKt.toList(fetchGroupToAddresses);
        boolean $i$f$flatMap = false;
        void var9_8 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            it = (Pair)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)it.getSecond();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Address address2 = (Address)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)address, (Object)it.getFirst()));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Pair)element$iv$iv;
            boolean bl = false;
            key$iv$iv = (Address)it.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void entry;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object = $this$getOrPut$iv$iv$iv;
            boolean bl4 = false;
            Iterable $this$map$iv = (Iterable)entry.getValue();
            boolean $i$f$map = false;
            address = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl5 = false;
                collection.add((String)it2.getSecond());
            }
            List list = (List)destination$iv$iv3;
            object.put(k, list);
        }
        Object addressToFetchGroups = destination$iv$iv;
        Map modbusQueryMap = new LinkedHashMap();
        for (Field field : fieldsThatMustBeUpdated) {
            ModbusQuery modbusQuery;
            Object it3;
            boolean bl;
            Object element$iv$iv;
            Iterator $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Set<Address> addresses;
            if (fetchGroupToAddresses.get(field.getFetchGroup()) == null) {
                throw new ModbusApiException("This should not be possible.", null, 2, null);
            }
            $this$associateByTo$iv$iv$iv = addresses;
            boolean $i$f$mapNotNull = false;
            list$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                List it$iv$iv;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl = false;
                it3 = (Address)element$iv$iv;
                boolean bl6 = false;
                if ((List)addressToFetchGroups.get(it3) == null) continue;
                boolean bl7 = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv4));
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv4 = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ModbusQuery it$iv$iv;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl = false;
                it3 = (String)element$iv$iv;
                boolean bl8 = false;
                if ((ModbusQuery)modbusQueryMap.get(it3) == null) continue;
                boolean bl9 = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            List modbusQueries = CollectionsKt.distinct((Iterable)((List)destination$iv$iv4));
            if (!(modbusQueries.size() <= 1)) {
                boolean bl10 = false;
                throw new ModbusApiException("Having multiple fields that use partially overlapping Modbus values is not allowed.\nField: (" + field.getId() + " ; " + field.getRequiredAddresses() + " ; " + field.getFetchGroup() + ") --> " + addresses + " -> " + modbusQueries, null, 2, null);
            }
            if (modbusQueries.isEmpty()) {
                $this$mapNotNullTo$iv$iv = ((Iterable)addresses).iterator();
                if (!$this$mapNotNullTo$iv$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Address it4 = (Address)$this$mapNotNullTo$iv$iv.next();
                boolean bl11 = false;
                Comparable comparable = (Comparable)it4;
                while ($this$mapNotNullTo$iv$iv.hasNext()) {
                    Address it5 = (Address)$this$mapNotNullTo$iv$iv.next();
                    $i$a$-minOf-ModbusBlockFetcher$calculateModbusQueries$modbusQuery$1 = false;
                    Comparable comparable2 = (Comparable)it5;
                    if (comparable.compareTo(comparable2) <= 0) continue;
                    comparable = comparable2;
                }
                int n = addresses.size();
                Address address3 = (Address)comparable;
                modbusQuery = new ModbusQuery(address3, n);
                modbusQuery.addField(field);
                modbusQueryMap.put(field.getFetchGroup(), modbusQuery);
                continue;
            }
            modbusQuery = (ModbusQuery)CollectionsKt.first((List)modbusQueries);
            if (!(Intrinsics.areEqual((Object)modbusQuery.getStart(), (Object)CollectionsKt.first((Iterable)addresses)) && modbusQuery.getCount() == addresses.size())) {
                boolean bl12 = false;
                throw new ModbusApiException("Having multiple fields that use partially overlapping Modbus values is not allowed..\nField: (" + field.getId() + " ; " + field.getRequiredAddresses() + " ; " + field.getFetchGroup() + ") --> " + addresses + " -> " + modbusQueries, null, 2, null);
            }
            modbusQuery.addField(field);
        }
        return CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)modbusQueryMap.values()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Field> allFieldsThatMustBeUpdated(List<Field> fields, long maxAge) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        long now = System.currentTimeMillis();
        Iterable iterable = fields;
        boolean $i$f$flatMap = false;
        void var8_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object v0;
            Field field;
            block4: {
                void $this$firstOrNull$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                field = (Field)element$iv$iv;
                boolean bl = false;
                if (!field.getInitialized()) {
                    boolean $i$a$-require-ModbusBlockFetcher$allFieldsThatMustBeUpdated$1$22 = false;
                    String $i$a$-require-ModbusBlockFetcher$allFieldsThatMustBeUpdated$1$22 = "You cannot fetch the registers for a Field if the field has not yet been initialized. (Field ID=" + field.getId() + ")";
                    throw new IllegalArgumentException($i$a$-require-ModbusBlockFetcher$allFieldsThatMustBeUpdated$1$22.toString());
                }
                Iterable iterable2 = field.getRequiredAddresses();
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Address address = (Address)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(this.schemaDevice.getModbusBlock(it.getAddressClass()).get((Address)it));
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ModbusValue it = (ModbusValue)element$iv;
                    boolean bl3 = false;
                    if (!it.needsToBeUpdated(now, maxAge)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Iterable list$iv$iv = v0 != null ? CollectionsKt.listOf((Object)field) : CollectionsKt.emptyList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @JvmOverloads
    @NotNull
    public final List<ModbusQuery> update() {
        return ModbusBlockFetcher.update$default(this, 0L, 1, null);
    }

    private static final Set calculateFetchGroupToAddressesMapping$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set calculateFetchGroupToAddressesMapping$lambda$1(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher$Companion;", "", "<init>", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "modbus-schema-device"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AddressClass.Type.values().length];
            try {
                nArray[AddressClass.Type.DISCRETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressClass.Type.REGISTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ModbusQuery.Status.values().length];
            try {
                nArray[ModbusQuery.Status.NOT_FETCHED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModbusQuery.Status.SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModbusQuery.Status.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

