/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.test;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.schema.BlockKt;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.SchemaDeviceKt;
import nl.basjes.modbus.schema.utils.StringTable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00032\b\b\u0002\u0010\u0016\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR)\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lnl/basjes/modbus/schema/test/TestScenarioResults;", "", "testName", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "testResults", "", "Lnl/basjes/modbus/schema/SchemaDevice$TestResult;", "<init>", "(Ljava/lang/String;Lnl/basjes/modbus/schema/SchemaDevice;Ljava/util/Map;)V", "getTestName", "()Ljava/lang/String;", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "getTestResults", "()Ljava/util/Map;", "allPassed", "", "getAllPassed", "()Z", "toTable", "onlyFailed", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nTestScenario.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestScenario.kt\nnl/basjes/modbus/schema/test/TestScenarioResults\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,213:1\n168#2,3:214\n*S KotlinDebug\n*F\n+ 1 TestScenario.kt\nnl/basjes/modbus/schema/test/TestScenarioResults\n*L\n145#1:214,3\n*E\n"})
public class TestScenarioResults {
    @NotNull
    private final String testName;
    @NotNull
    private final SchemaDevice schemaDevice;
    @NotNull
    private final Map<String, Map<String, SchemaDevice.TestResult>> testResults;

    public TestScenarioResults(@NotNull String testName, @NotNull SchemaDevice schemaDevice, @NotNull Map<String, Map<String, SchemaDevice.TestResult>> testResults) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter(testResults, (String)"testResults");
        this.testName = testName;
        this.schemaDevice = schemaDevice;
        this.testResults = testResults;
    }

    @NotNull
    public final String getTestName() {
        return this.testName;
    }

    @NotNull
    public final SchemaDevice getSchemaDevice() {
        return this.schemaDevice;
    }

    @NotNull
    public final Map<String, Map<String, SchemaDevice.TestResult>> getTestResults() {
        return this.testResults;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getAllPassed() {
        boolean bl;
        if (this.testResults.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Map<String, Map<String, SchemaDevice.TestResult>> $this$all$iv = this.testResults;
        boolean $i$f$all = false;
        if ($this$all$iv.isEmpty()) {
            return true;
        }
        Iterator<Map.Entry<String, Map<String, SchemaDevice.TestResult>>> iterator = $this$all$iv.entrySet().iterator();
        do {
            Map.Entry<String, Map<String, SchemaDevice.TestResult>> element$iv;
            if (!iterator.hasNext()) return true;
            Map.Entry<String, Map<String, SchemaDevice.TestResult>> it = element$iv = iterator.next();
            boolean bl3 = false;
            Map<String, SchemaDevice.TestResult> $this$all$iv2 = it.getValue();
            boolean $i$f$all2 = false;
            if ($this$all$iv2.isEmpty()) {
                bl = true;
                continue;
            }
            Iterator<Map.Entry<String, SchemaDevice.TestResult>> iterator2 = $this$all$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, SchemaDevice.TestResult> element$iv2;
                Map.Entry<String, SchemaDevice.TestResult> r = element$iv2 = iterator2.next();
                boolean bl4 = false;
                if (r.getValue().isPassed()) continue;
                return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    public final String toTable(boolean onlyFailed) {
        String[] stringArray = new String[]{"Test", "Block", "Field", "Unit", "Expected", "Actual", "ReturnType", "Good?"};
        StringTable stringTable = new StringTable().withHeaders(stringArray);
        for (Map.Entry entry : this.testResults.entrySet()) {
            String blockId = (String)entry.getKey();
            Map results = (Map)entry.getValue();
            for (Map.Entry entry2 : results.entrySet()) {
                String fieldId = (String)entry2.getKey();
                SchemaDevice.TestResult testResult = (SchemaDevice.TestResult)entry2.getValue();
                if (onlyFailed && testResult.isPassed()) continue;
                Field field = BlockKt.get(SchemaDeviceKt.get(this.schemaDevice, blockId), fieldId);
                if (field == null) {
                    boolean bl = false;
                    String string = "The field: " + blockId + "->" + fieldId + " which was present while running the test is now suddenly no longer available";
                    throw new IllegalArgumentException(string.toString());
                }
                String[] stringArray2 = new String[]{this.testName, blockId, fieldId, field.getUnit(), TestScenarioResults.toTable$typedString(testResult.getExpectedValue(), field.getReturnType()), TestScenarioResults.toTable$typedString(testResult.getActualValue(), field.getReturnType()), field.getReturnType().name(), String.valueOf(testResult.isPassed())};
                stringTable.addRow(stringArray2);
            }
        }
        return stringTable.toString();
    }

    public static /* synthetic */ String toTable$default(TestScenarioResults testScenarioResults, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toTable");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return testScenarioResults.toTable(bl);
    }

    private static final CharSequence toTable$typedString$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final CharSequence toTable$typedString$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }

    private static final String toTable$typedString(List<String> $this$toTable_u24typedString, ReturnType returnType) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[returnType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                string = "[ " + CollectionsKt.joinToString$default((Iterable)$this$toTable_u24typedString, null, null, null, (int)0, null, TestScenarioResults::toTable$typedString$lambda$2, (int)31, null) + " ]";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "[ " + CollectionsKt.joinToString$default((Iterable)$this$toTable_u24typedString, null, null, null, (int)0, null, TestScenarioResults::toTable$typedString$lambda$3, (int)31, null) + " ]";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReturnType.values().length];
            try {
                nArray[ReturnType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.DOUBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.UNKNOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.STRINGLIST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

