/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.utils;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bJ\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000bJ\u001f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001cJ!\u0010\u001d\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001eJ%\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J\u0018\u0010'\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u000bJ\u000e\u0010,\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020-J\u000e\u0010.\u001a\u00020-2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010/\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\tJ\u000e\u00100\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u00101\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u000202J\u000e\u00103\u001a\u0002022\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u00104\u001a\u00020\u00072\u0006\u0010+\u001a\u000205J\u000e\u00106\u001a\u0002052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u00107\u001a\u00020\u00072\u0006\u0010+\u001a\u000208J\u000e\u00109\u001a\u0002082\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010:\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006;"}, d2={"Lnl/basjes/modbus/schema/utils/ByteConversions;", "", "<init>", "()V", "assertByteArraySize", "", "bytes", "", "expectedSize", "", "targetType", "", "bytesToHexString", "bytesToSeparatedHexString", "separator", "bytesToSeparatedIntegerString", "bytesToSeparatedTwoByteHexString", "splitStringBySize", "", "str", "size", "hexStringToBytes", "input", "", "(Ljava/util/List;)[[B", "allAreOfSize", "", "arrayOfByteArrays", "([[BI)Z", "arrayOfByteArraysContains", "([[B[B)Z", "isInRange", "b", "", "first", "Lkotlin/UInt;", "last", "isInRange-BltQuoY", "(BII)Z", "isValidUtf8", "bytesInChar", "bytesToString", "stringToBytes", "value", "shortToBytes", "", "bytesToShort", "integerToBytes", "bytesToInteger", "longToBytes", "", "bytesToLong", "floatToBytes", "", "bytesToFloat", "doubleToBytes", "", "bytesToDouble", "reverse", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nByteConversions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteConversions.kt\nnl/basjes/modbus/schema/utils/ByteConversions\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,393:1\n108#2:394\n80#2,22:395\n108#2:417\n80#2,22:418\n37#3:440\n36#3,3:441\n*S KotlinDebug\n*F\n+ 1 ByteConversions.kt\nnl/basjes/modbus/schema/utils/ByteConversions\n*L\n100#1:394\n100#1:395,22\n105#1:417\n105#1:418,22\n125#1:440\n125#1:441,3\n*E\n"})
public final class ByteConversions {
    @NotNull
    public static final ByteConversions INSTANCE = new ByteConversions();

    private ByteConversions() {
    }

    private final void assertByteArraySize(byte[] bytes, int expectedSize, String targetType) {
        if (!(bytes.length == expectedSize)) {
            boolean bl = false;
            String string = "A 'byte[]' to '" + targetType + "' must have exactly " + expectedSize + " bytes instead of the provided " + bytes.length + " bytes.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String bytesToHexString(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (bytes.length == 0) {
            return "";
        }
        List result = new ArrayList();
        for (byte aByte : bytes) {
            String string = "%02X";
            Object[] objectArray = new Object[]{aByte};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            result.add(string2);
        }
        return "0x" + CollectionsKt.joinToString$default((Iterable)result, (CharSequence)" 0x", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String bytesToSeparatedHexString(@NotNull byte[] bytes, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if (bytes.length == 0) {
            return "";
        }
        List result = new ArrayList();
        for (byte aByte : bytes) {
            String string = "%02X";
            Object[] objectArray = new Object[]{aByte};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            result.add(string2);
        }
        return CollectionsKt.joinToString$default((Iterable)result, (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String bytesToSeparatedIntegerString(@NotNull byte[] bytes, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if (bytes.length == 0) {
            return "";
        }
        List result = new ArrayList();
        for (byte aByte : bytes) {
            String string = "%d";
            Object[] objectArray = new Object[]{(int)aByte};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            result.add(string2);
        }
        return CollectionsKt.joinToString$default((Iterable)result, (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String bytesToSeparatedTwoByteHexString(@NotNull byte[] bytes, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if (bytes.length == 0) {
            return "";
        }
        List result = new ArrayList();
        for (int i = 0; i < bytes.length; i += 2) {
            String string = "%02X%02X";
            Object[] objectArray = new Object[]{bytes[i], bytes[i + 1]};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            result.add(string2);
        }
        return CollectionsKt.joinToString$default((Iterable)result, (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final List<String> splitStringBySize(@NotNull String str, int size) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ArrayList<String> split = new ArrayList<String>();
        int i = 0;
        int n = str.length() / size;
        if (i <= n) {
            while (true) {
                String substring;
                Intrinsics.checkNotNullExpressionValue((Object)str.substring(i * size, (int)Math.min((double)((i + 1) * size), (double)str.length())), (String)"substring(...)");
                if (((CharSequence)substring).length() > 0) {
                    split.add(substring);
                }
                if (i == n) break;
                ++i;
            }
        }
        return split;
    }

    @NotNull
    public final byte[] hexStringToBytes(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String $this$trim$iv = StringsKt.replace$default((String)StringsKt.replace$default((String)input, (String)"0x", (String)"", (boolean)false, (int)4, null), (String)" ", (String)"", (boolean)false, (int)4, null);
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String hexByteValues = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        byte[] result = new byte[hexByteValues.length() / 2];
        int nextByteIndex = 0;
        Iterator<String> iterator = this.splitStringBySize(hexByteValues, 2).iterator();
        while (iterator.hasNext()) {
            String toParse;
            String word;
            String $this$trim$iv2 = word = iterator.next();
            boolean $i$f$trim3 = false;
            CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
            boolean $i$f$trim4 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            if (((CharSequence)(toParse = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString())).length() == 0) continue;
            String string = toParse.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            toParse = string;
            int parsedInt = Integer.parseInt(toParse, CharsKt.checkRadix((int)16));
            byte value = (byte)(parsedInt & 0xFF);
            result[nextByteIndex++] = value;
        }
        return result;
    }

    @NotNull
    public final byte[][] hexStringToBytes(@NotNull List<String> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (input.isEmpty()) {
            return new byte[0][];
        }
        List result = new ArrayList();
        int n = ((Collection)input).size();
        for (int index = 0; index < n; ++index) {
            result.add(index, this.hexStringToBytes(input.get(index)));
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (byte[][])thisCollection$iv.toArray((T[])new byte[0][]);
    }

    public final boolean allAreOfSize(@NotNull byte[][] arrayOfByteArrays, int size) {
        Intrinsics.checkNotNullParameter((Object)arrayOfByteArrays, (String)"arrayOfByteArrays");
        int n = ((Object[])arrayOfByteArrays).length;
        for (int i = 0; i < n; ++i) {
            byte[] byteArrays = arrayOfByteArrays[i];
            if (byteArrays.length == size) continue;
            return false;
        }
        return true;
    }

    public final boolean arrayOfByteArraysContains(@NotNull byte[][] arrayOfByteArrays, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)arrayOfByteArrays, (String)"arrayOfByteArrays");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int n = ((Object[])arrayOfByteArrays).length;
        for (int i = 0; i < n; ++i) {
            byte[] byteArray = arrayOfByteArrays[i];
            if (!Arrays.equals(byteArray, bytes)) continue;
            return true;
        }
        return false;
    }

    public final boolean isInRange-BltQuoY(byte b, int first, int last) {
        int unsignedByte = UInt.constructor-impl((int)(UInt.constructor-impl((int)b) & 0xFF));
        return 0 <= UnsignedKt.uintCompare((int)unsignedByte, (int)first) ? UnsignedKt.uintCompare((int)unsignedByte, (int)last) <= 0 : false;
    }

    private final boolean isValidUtf8(byte[] bytes, int bytesInChar) {
        return switch (bytesInChar) {
            case 1 -> this.isInRange-BltQuoY(bytes[0], 1, 127);
            case 2 -> {
                if (this.isInRange-BltQuoY(bytes[0], 194, 223) && this.isInRange-BltQuoY(bytes[1], 128, 191)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (this.isInRange-BltQuoY(bytes[0], 224, 224) && this.isInRange-BltQuoY(bytes[1], 160, 191) && this.isInRange-BltQuoY(bytes[2], 128, 191) || this.isInRange-BltQuoY(bytes[0], 225, 236) && this.isInRange-BltQuoY(bytes[1], 128, 191) && this.isInRange-BltQuoY(bytes[2], 128, 191) || this.isInRange-BltQuoY(bytes[0], 237, 237) && this.isInRange-BltQuoY(bytes[1], 128, 159) && this.isInRange-BltQuoY(bytes[2], 128, 191) || this.isInRange-BltQuoY(bytes[0], 238, 239) && this.isInRange-BltQuoY(bytes[1], 128, 191) && this.isInRange-BltQuoY(bytes[2], 128, 191)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (this.isInRange-BltQuoY(bytes[0], 240, 240) && this.isInRange-BltQuoY(bytes[1], 144, 191) && this.isInRange-BltQuoY(bytes[2], 128, 191) && this.isInRange-BltQuoY(bytes[3], 128, 191) || this.isInRange-BltQuoY(bytes[0], 241, 243) && this.isInRange-BltQuoY(bytes[1], 128, 191) && this.isInRange-BltQuoY(bytes[2], 128, 191) && this.isInRange-BltQuoY(bytes[3], 128, 191) || this.isInRange-BltQuoY(bytes[0], 244, 244) && this.isInRange-BltQuoY(bytes[1], 128, 143) && this.isInRange-BltQuoY(bytes[2], 128, 191) && this.isInRange-BltQuoY(bytes[3], 128, 191)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Nullable
    public final String bytesToString(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (bytes.length == 0 || bytes[0] == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean invalidString = false;
        byte[] nextChar = new byte[4];
        int i = 0;
        while (i < bytes.length) {
            Charset charset;
            int n;
            if ((bytes[i] & 0xFFFFFF80) == 0) {
                n = 1;
            } else if ((bytes[i] & 0xFFFFFFE0) == -64) {
                n = 2;
            } else if ((bytes[i] & 0xFFFFFFF0) == -32) {
                n = 3;
            } else {
                if ((bytes[i] & 0xFFFFFFF8) != -16) break;
                n = 4;
            }
            int bytesInChar = n;
            for (int b = 0; b < bytesInChar; ++b) {
                if (i == bytes.length) {
                    invalidString = true;
                    break;
                }
                nextChar[b] = bytes[i++];
            }
            if (!this.isValidUtf8(nextChar, bytesInChar)) {
                invalidString = true;
                break;
            }
            if (invalidString) break;
            int n2 = 0;
            Intrinsics.checkNotNullExpressionValue((Object)StandardCharsets.UTF_8, (String)"UTF_8");
            sb.append(new String(nextChar, n2, bytesInChar, charset));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        if (invalidString && ((CharSequence)string2).length() == 0) {
            return null;
        }
        return string2;
    }

    @NotNull
    public final byte[] stringToBytes(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @NotNull
    public final byte[] shortToBytes(short input) {
        short value = input;
        byte[] result = new byte[2];
        for (int i = 1; -1 < i; --i) {
            result[i] = (byte)(value & 0xFF);
            value = (short)(value >> 8);
        }
        return result;
    }

    public final short bytesToShort(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.assertByteArraySize(bytes, 2, "short");
        short result = 0;
        for (int i = 0; i < 2; ++i) {
            result = (short)(result << 8);
            result = (short)(result | (short)((short)bytes[i] & 0xFF));
        }
        return result;
    }

    @NotNull
    public final byte[] integerToBytes(int input) {
        int value = input;
        byte[] result = new byte[4];
        for (int i = 3; -1 < i; --i) {
            result[i] = (byte)(value & 0xFF);
            value >>= 8;
        }
        return result;
    }

    public final int bytesToInteger(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.assertByteArraySize(bytes, 4, "int");
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result |= bytes[i] & 0xFF;
        }
        return result;
    }

    @NotNull
    public final byte[] longToBytes(long input) {
        long value = input;
        byte[] result = new byte[8];
        for (int i = 7; -1 < i; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    public final long bytesToLong(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.assertByteArraySize(bytes, 8, "long");
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(bytes[i] & 0xFF);
        }
        return result;
    }

    @NotNull
    public final byte[] floatToBytes(float value) {
        return this.integerToBytes(Float.floatToIntBits(value));
    }

    public final float bytesToFloat(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.assertByteArraySize(bytes, 4, "float");
        return Float.intBitsToFloat(this.bytesToInteger(bytes));
    }

    @NotNull
    public final byte[] doubleToBytes(double value) {
        return this.longToBytes(Double.doubleToLongBits(value));
    }

    public final double bytesToDouble(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.assertByteArraySize(bytes, 8, "double");
        return Double.longBitsToDouble(this.bytesToLong(bytes));
    }

    public final void reverse(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int size = bytes.length;
        byte temp = 0;
        for (int index = 0; index < size / 2; ++index) {
            temp = bytes[index];
            bytes[index] = bytes[size - index - 1];
            bytes[size - index - 1] = temp;
        }
    }
}

