/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema;

import com.charleskorn.kaml.MultiLineStringStyle;
import com.charleskorn.kaml.SingleLineStringStyle;
import com.charleskorn.kaml.Yaml;
import com.charleskorn.kaml.YamlConfiguration;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressKt;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterBlockKt;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.Schema;
import nl.basjes.modbus.schema.SchemaBlock;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.SchemaField;
import nl.basjes.modbus.schema.SchemaTest;
import nl.basjes.modbus.schema.SchemaTestBlock;
import nl.basjes.modbus.schema.SchemaTestRegisters;
import nl.basjes.modbus.schema.exceptions.ModbusSchemaParseException;
import nl.basjes.modbus.schema.test.ExpectedBlock;
import nl.basjes.modbus.schema.test.TestScenario;
import nl.basjes.modbus.schema.test.TestScenarioResults;
import nl.basjes.modbus.schema.test.TestScenarioResultsList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\n\u0010\b\u001a\u00020\t*\u00020\u000b\u001a\n\u0010\b\u001a\u00020\t*\u00020\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a\n\u0010\r\u001a\u00020\u0010*\u00020\u0011\u001a\n\u0010\r\u001a\u00020\u0012*\u00020\u0013\u001a\n\u0010\r\u001a\u00020\u0014*\u00020\u0015\u001a\n\u0010\r\u001a\u00020\u0016*\u00020\u0017\u001a\n\u0010\r\u001a\u00020\u0018*\u00020\t\u001a\n\u0010\u0019\u001a\u00020\n*\u00020\t\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"yamlConfiguration", "Lcom/charleskorn/kaml/YamlConfiguration;", "getYamlConfiguration", "()Lcom/charleskorn/kaml/YamlConfiguration;", "yaml", "Lcom/charleskorn/kaml/Yaml;", "getYaml", "()Lcom/charleskorn/kaml/Yaml;", "toSchemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "", "Ljava/io/File;", "Ljava/io/InputStream;", "toSchema", "Lnl/basjes/modbus/schema/SchemaField;", "Lnl/basjes/modbus/schema/Field;", "Lnl/basjes/modbus/schema/SchemaBlock;", "Lnl/basjes/modbus/schema/Block;", "Lnl/basjes/modbus/schema/SchemaTest;", "Lnl/basjes/modbus/schema/test/TestScenario;", "Lnl/basjes/modbus/schema/SchemaTestRegisters;", "Lnl/basjes/modbus/device/api/RegisterBlock;", "Lnl/basjes/modbus/schema/SchemaTestBlock;", "Lnl/basjes/modbus/schema/test/ExpectedBlock;", "Lnl/basjes/modbus/schema/Schema;", "toYaml", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nYamlLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlLoader.kt\nnl/basjes/modbus/schema/YamlLoaderKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,356:1\n216#2,2:357\n1#3:359\n*S KotlinDebug\n*F\n+ 1 YamlLoader.kt\nnl/basjes/modbus/schema/YamlLoaderKt\n*L\n94#1:357,2\n*E\n"})
public final class YamlLoaderKt {
    @NotNull
    private static final YamlConfiguration yamlConfiguration = new YamlConfiguration(false, false, null, null, null, 0, 100000, null, SingleLineStringStyle.SingleQuoted, MultiLineStringStyle.Literal, null, 2, null, null, null, false, 62654, null);
    @NotNull
    private static final Yaml yaml = new Yaml(null, yamlConfiguration, 1, null);

    @NotNull
    public static final YamlConfiguration getYamlConfiguration() {
        return yamlConfiguration;
    }

    @NotNull
    public static final Yaml getYaml() {
        return yaml;
    }

    @NotNull
    public static final SchemaDevice toSchemaDevice(@NotNull String $this$toSchemaDevice) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toSchemaDevice, (String)"<this>");
        Schema parsedSchema = (Schema)yaml.decodeFromString((DeserializationStrategy)Schema.Companion.serializer(), $this$toSchemaDevice);
        SchemaDevice schemaDevice = new SchemaDevice(parsedSchema.getDescription(), parsedSchema.getMaxRegistersPerModbusRequest());
        if (!(schemaDevice.getSchemaFeatureLevel() >= parsedSchema.getSchemaFeatureLevel())) {
            boolean $i$a$-require-YamlLoaderKt$toSchemaDevice$22 = false;
            String $i$a$-require-YamlLoaderKt$toSchemaDevice$22 = "The provided schema requires schema level " + parsedSchema.getSchemaFeatureLevel() + " which the currently used runtime does not support (max = " + schemaDevice.getSchemaFeatureLevel() + ")";
            throw new IllegalArgumentException($i$a$-require-YamlLoaderKt$toSchemaDevice$22.toString());
        }
        for (SchemaBlock schemaBlock : parsedSchema.getBlocks()) {
            Block block = new Block(schemaDevice, schemaBlock.getId(), schemaBlock.getDescription());
            schemaDevice.addBlock(block);
            for (SchemaField schemaField : schemaBlock.getFields()) {
                Field[] fieldArray = schemaField.getId();
                String string = schemaField.getDescription();
                object = schemaField.getExpression();
                String string2 = schemaField.getUnit();
                boolean bl = schemaField.getImmutable();
                boolean bl2 = schemaField.getSystem();
                Field field = new Field(block, (String)fieldArray, string, bl, bl2, (String)object, string2, null, 128, null);
                fieldArray = new Field[]{field};
                block.addField(fieldArray);
            }
        }
        for (SchemaTest schemaTest : parsedSchema.getTests()) {
            TestScenario testScenario = new TestScenario(schemaTest.getId(), schemaTest.getDescription());
            schemaDevice.addTestScenario(testScenario);
            for (SchemaTestRegisters registers : schemaTest.getInput()) {
                Address address = AddressKt.asAddress((String)registers.getFirstRegisterAddress());
                RegisterBlock registerBlock = RegisterBlockKt.toRegisterBlock((String)registers.getRegisters(), (Address)address);
                testScenario.addRegisterBlock(registerBlock);
            }
            for (SchemaTestBlock testBlock : schemaTest.getBlocks()) {
                ExpectedBlock expectedBlock = new ExpectedBlock(testBlock.getId());
                Map<String, List<String>> $this$forEach$iv = testBlock.getExpected();
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = (Map.Entry)object.next();
                    boolean bl = false;
                    String field = (String)entry.getKey();
                    List value = (List)entry.getValue();
                    expectedBlock.addExpectation(field, value);
                }
                testScenario.addExpectedBlock(expectedBlock);
            }
        }
        if (!schemaDevice.initialize()) {
            throw new ModbusSchemaParseException("The initialize of the Logical Device failed\n" + schemaDevice.initializationProblems());
        }
        TestScenarioResultsList results = schemaDevice.verifyProvidedTests();
        if (!results.getAllPassed()) {
            throw new ModbusSchemaParseException(CollectionsKt.joinToString$default((Iterable)results, (CharSequence)"\n", null, null, (int)0, null, YamlLoaderKt::toSchemaDevice$lambda$2, (int)30, null));
        }
        return schemaDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SchemaDevice toSchemaDevice(@NotNull File $this$toSchemaDevice) {
        Intrinsics.checkNotNullParameter((Object)$this$toSchemaDevice, (String)"<this>");
        Closeable closeable = new FileInputStream($this$toSchemaDevice);
        Throwable throwable = null;
        try {
            FileInputStream inputStream = (FileInputStream)closeable;
            boolean bl = false;
            SchemaDevice schemaDevice = YamlLoaderKt.toSchemaDevice(inputStream);
            return schemaDevice;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SchemaDevice toSchemaDevice(@NotNull InputStream $this$toSchemaDevice) {
        Intrinsics.checkNotNullParameter((Object)$this$toSchemaDevice, (String)"<this>");
        Closeable closeable = $this$toSchemaDevice;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader p0 = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)p0);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Object content = object2;
        return YamlLoaderKt.toSchemaDevice((String)content);
    }

    @NotNull
    public static final SchemaField toSchema(@NotNull Field $this$toSchema) {
        Intrinsics.checkNotNullParameter((Object)$this$toSchema, (String)"<this>");
        return new SchemaField($this$toSchema.getId(), $this$toSchema.getDescription(), $this$toSchema.isImmutable(), $this$toSchema.isSystem(), String.valueOf($this$toSchema.getParsedExpression()), $this$toSchema.getUnit());
    }

    @NotNull
    public static final SchemaBlock toSchema(@NotNull Block $this$toSchema) {
        Intrinsics.checkNotNullParameter((Object)$this$toSchema, (String)"<this>");
        List schemaFields = new ArrayList();
        for (Field field : $this$toSchema.getFields()) {
            schemaFields.add(YamlLoaderKt.toSchema(field));
        }
        String schemaDescription = null;
        String blockDescription = $this$toSchema.getDescription();
        CharSequence charSequence = blockDescription;
        if (!(charSequence == null || charSequence.length() == 0)) {
            schemaDescription = blockDescription;
        }
        return new SchemaBlock($this$toSchema.getId(), schemaDescription, schemaFields);
    }

    @NotNull
    public static final SchemaTest toSchema(@NotNull TestScenario $this$toSchema) {
        Intrinsics.checkNotNullParameter((Object)$this$toSchema, (String)"<this>");
        List testRegisters = new ArrayList();
        List testBlocks = new ArrayList();
        for (RegisterBlock registerBlock : $this$toSchema.getRegisterBlocks()) {
            testRegisters.add(YamlLoaderKt.toSchema(registerBlock));
        }
        Object object = $this$toSchema.getExpectedBlocks().iterator();
        while (object.hasNext()) {
            ExpectedBlock expectedBlock = (ExpectedBlock)object.next();
            testBlocks.add(YamlLoaderKt.toSchema(expectedBlock));
        }
        return new SchemaTest($this$toSchema.getName(), (object = (CharSequence)$this$toSchema.getDescription()) == null || object.length() == 0 ? null : $this$toSchema.getDescription(), testRegisters, testBlocks);
    }

    @NotNull
    public static final SchemaTestRegisters toSchema(@NotNull RegisterBlock $this$toSchema) {
        Intrinsics.checkNotNullParameter((Object)$this$toSchema, (String)"<this>");
        StringBuilder sb = new StringBuilder();
        List valuesList = $this$toSchema.noGapsValuesList();
        int lineCount = 0;
        for (RegisterValue registerValue : valuesList) {
            String comment = registerValue.getComment();
            CharSequence charSequence = comment;
            if (!(charSequence == null || charSequence.length() == 0)) {
                comment = StringsKt.replace$default((String)comment, (String)"{address}", (String)registerValue.getAddress().toCleanFormat(), (boolean)false, (int)4, null);
                if (lineCount > 0) {
                    sb.append("\n");
                }
                sb.append("\n# " + StringsKt.replace$default((String)comment, (String)"\n", (String)"\n# ", (boolean)false, (int)4, null) + "\n");
                lineCount = 0;
            }
            if (lineCount > 0) {
                sb.append(" ");
            }
            sb.append(registerValue.getHexValue());
            if (++lineCount < 10) continue;
            sb.append("\n");
            lineCount = 0;
        }
        Object object = $this$toSchema.getFirstAddress();
        if (object == null || (object = object.toCleanFormat()) == null) {
            object = "Empty";
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new SchemaTestRegisters((String)object, string);
    }

    @NotNull
    public static final SchemaTestBlock toSchema(@NotNull ExpectedBlock $this$toSchema) {
        Intrinsics.checkNotNullParameter((Object)$this$toSchema, (String)"<this>");
        return new SchemaTestBlock($this$toSchema.getBlockId(), $this$toSchema.getExpected());
    }

    @NotNull
    public static final Schema toSchema(@NotNull SchemaDevice $this$toSchema) {
        Intrinsics.checkNotNullParameter((Object)$this$toSchema, (String)"<this>");
        List schemaBlocks = new ArrayList();
        List schemaTests = new ArrayList();
        for (Block block : $this$toSchema.getBlocks()) {
            schemaBlocks.add(YamlLoaderKt.toSchema(block));
        }
        for (TestScenario test : $this$toSchema.getTests()) {
            schemaTests.add(YamlLoaderKt.toSchema(test));
        }
        return new Schema($this$toSchema.getDescription(), 1, $this$toSchema.getMaxRegistersPerModbusRequest(), schemaBlocks, schemaTests);
    }

    @NotNull
    public static final String toYaml(@NotNull SchemaDevice $this$toYaml) {
        Intrinsics.checkNotNullParameter((Object)$this$toYaml, (String)"<this>");
        return yaml.encodeToString((SerializationStrategy)Schema.Companion.serializer(), (Object)YamlLoaderKt.toSchema($this$toYaml));
    }

    private static final CharSequence toSchemaDevice$lambda$2(TestScenarioResults it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getAllPassed() ? (CharSequence)("\n[PASS] Schema test \"" + it.getTestName() + "\"") : (CharSequence)("\n[FAIL] Schema test \"" + it.getTestName() + "\":\nFailed fields:\n" + it.toTable(true));
    }
}

