/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.numbers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.NotImplemented;
import nl.basjes.modbus.schema.expression.numbers.NumericalExpression;
import nl.basjes.modbus.schema.expression.registers.RegistersExpression;
import nl.basjes.modbus.schema.utils.ByteConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0017\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000e\u00a8\u0006\""}, d2={"Lnl/basjes/modbus/schema/expression/numbers/IEEE754Float32;", "Lnl/basjes/modbus/schema/expression/NotImplemented;", "Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;", "byteArray", "Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "notImplemented", "", "", "<init>", "(Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;Ljava/util/List;)V", "toString", "subExpressions", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "isImmutable", "", "()Z", "setImmutable", "(Z)V", "returnType", "Lnl/basjes/modbus/schema/ReturnType;", "getReturnType", "()Lnl/basjes/modbus/schema/ReturnType;", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getRegisterValues", "Lnl/basjes/modbus/device/api/RegisterValue;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "getValueAsDouble", "", "(Lnl/basjes/modbus/schema/SchemaDevice;)Ljava/lang/Double;", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nIEEE754Float32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IEEE754Float32.kt\nnl/basjes/modbus/schema/expression/numbers/IEEE754Float32\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class IEEE754Float32
extends NotImplemented
implements NumericalExpression {
    @NotNull
    private final RegistersExpression byteArray;
    private boolean isImmutable;

    public IEEE754Float32(@NotNull RegistersExpression byteArray, @NotNull List<String> notImplemented) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter(notImplemented, (String)"notImplemented");
        super(2, notImplemented);
        this.byteArray = byteArray;
    }

    @Override
    @NotNull
    public String toString() {
        return "ieee754_32(" + this.byteArray + ")";
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return CollectionsKt.listOf((Object)this.byteArray);
    }

    @Override
    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public void setImmutable(boolean bl) {
        this.isImmutable = bl;
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return ReturnType.DOUBLE;
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{NumericalExpression.DefaultImpls.getProblems(this), super.getProblems(), this.checkFatal(this.byteArray.getReturnedRegisters() == 2, "Wrong number of registers: Got " + this.byteArray.getReturnedRegisters() + ", need 2")};
        return this.combine("ieee754_32", listArray);
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.byteArray.getRegisterValues(schemaDevice);
    }

    @Override
    @Nullable
    public Double getValueAsDouble(@NotNull SchemaDevice schemaDevice) {
        Double d;
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        byte[] byArray = this.byteArray.getByteArray(schemaDevice);
        if (byArray == null) {
            return null;
        }
        byte[] bytes = byArray;
        if (this.isNotImplemented(bytes)) {
            return null;
        }
        byte[] byArray2 = this.byteArray.getByteArray(schemaDevice);
        if (byArray2 != null) {
            byte[] it = byArray2;
            boolean bl = false;
            d = ByteConversions.INSTANCE.bytesToFloat(it);
        } else {
            d = null;
        }
        return d;
    }

    @Override
    @Nullable
    public Long getValueAsLong(@NotNull SchemaDevice schemaDevice) {
        return NumericalExpression.DefaultImpls.getValueAsLong(this, schemaDevice);
    }

    @Override
    @NotNull
    public NumericalExpression.ValueGuarantee getGuarantee() {
        return NumericalExpression.DefaultImpls.getGuarantee(this);
    }
}

