/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.numbers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.numbers.NumericalExpression;
import nl.basjes.modbus.schema.expression.numbers.NumericalOperationsKt;
import nl.basjes.modbus.schema.expression.numbers.SubExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lnl/basjes/modbus/schema/expression/numbers/Subtract;", "Lnl/basjes/modbus/schema/expression/numbers/SubExpression;", "left", "Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;", "right", "<init>", "(Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;)V", "operatorSymbol", "", "getOperatorSymbol", "()Ljava/lang/String;", "getGuarantee", "Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression$ValueGuarantee;", "getValueAsLong", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "(Lnl/basjes/modbus/schema/SchemaDevice;)Ljava/lang/Long;", "getValueAsDouble", "", "(Lnl/basjes/modbus/schema/SchemaDevice;)Ljava/lang/Double;", "returnType", "Lnl/basjes/modbus/schema/ReturnType;", "getReturnType", "()Lnl/basjes/modbus/schema/ReturnType;", "modbus-schema-device"})
public final class Subtract
extends SubExpression {
    public Subtract(@NotNull NumericalExpression left, @NotNull NumericalExpression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        super("Subtract", left, right);
    }

    @Override
    @NotNull
    public String getOperatorSymbol() {
        return "-";
    }

    @Override
    @NotNull
    public NumericalExpression.ValueGuarantee getGuarantee() {
        NumericalExpression.ValueGuarantee leftGuarantee = this.getLeft().getGuarantee();
        NumericalExpression.ValueGuarantee rightGuarantee = this.getRight().getGuarantee();
        return leftGuarantee == NumericalExpression.ValueGuarantee.POSITIVE && rightGuarantee == NumericalExpression.ValueGuarantee.NEGATIVE ? NumericalExpression.ValueGuarantee.POSITIVE : (leftGuarantee == NumericalExpression.ValueGuarantee.NEGATIVE && rightGuarantee == NumericalExpression.ValueGuarantee.POSITIVE ? NumericalExpression.ValueGuarantee.NEGATIVE : NumericalExpression.ValueGuarantee.NONE);
    }

    @Override
    @Nullable
    public Long getValueAsLong(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Long l = this.getLeft().getValueAsLong(schemaDevice);
        if (l == null) {
            return null;
        }
        long left = l;
        Long l2 = this.getRight().getValueAsLong(schemaDevice);
        if (l2 == null) {
            return null;
        }
        long right = l2;
        return left - right;
    }

    @Override
    @Nullable
    public Double getValueAsDouble(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Double d = NumericalOperationsKt.access$getValidatedDouble(schemaDevice, this.getLeft());
        if (d == null) {
            return null;
        }
        double left = d;
        Double d2 = NumericalOperationsKt.access$getValidatedDouble(schemaDevice, this.getRight());
        if (d2 == null) {
            return null;
        }
        double right = d2;
        return left - right;
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return this.getLeft().getReturnType() == ReturnType.LONG && this.getRight().getReturnType() == ReturnType.LONG ? ReturnType.LONG : ReturnType.DOUBLE;
    }
}

