/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.strings;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.NotImplemented;
import nl.basjes.modbus.schema.expression.registers.RegistersExpression;
import nl.basjes.modbus.schema.expression.strings.StringListExpression;
import nl.basjes.modbus.schema.utils.ByteConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0007H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00062\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006\""}, d2={"Lnl/basjes/modbus/schema/expression/strings/BitsetStringList;", "Lnl/basjes/modbus/schema/expression/NotImplemented;", "Lnl/basjes/modbus/schema/expression/strings/StringListExpression;", "registers", "Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "notImplemented", "", "", "mappings", "", "", "<init>", "(Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;Ljava/util/List;Ljava/util/Map;)V", "getMappings", "()Ljava/util/Map;", "toString", "subExpressions", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "value", "", "isImmutable", "()Z", "setImmutable", "(Z)V", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getRegisterValues", "Lnl/basjes/modbus/device/api/RegisterValue;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "getValue", "modbus-schema-device"})
public final class BitsetStringList
extends NotImplemented
implements StringListExpression {
    @NotNull
    private final RegistersExpression registers;
    @NotNull
    private final Map<Integer, String> mappings;

    public BitsetStringList(@NotNull RegistersExpression registers, @NotNull List<String> notImplemented, @NotNull Map<Integer, String> mappings) {
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        Intrinsics.checkNotNullParameter(notImplemented, (String)"notImplemented");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        super(registers.getReturnedRegisters(), notImplemented);
        this.registers = registers;
        this.mappings = mappings;
    }

    @NotNull
    public final Map<Integer, String> getMappings() {
        return this.mappings;
    }

    @Override
    @NotNull
    public String toString() {
        return "bitset(" + this.registers + super.toString() + " ; " + CollectionsKt.joinToString$default((Iterable)this.mappings.entrySet(), (CharSequence)" ; ", null, null, (int)0, null, BitsetStringList::toString$lambda$0, (int)30, null) + ")";
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return CollectionsKt.listOf((Object)this.registers);
    }

    @Override
    public boolean isImmutable() {
        return this.registers.isImmutable();
    }

    @Override
    public void setImmutable(boolean value) {
        this.registers.setImmutable(value);
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{this.checkFatal(this.registers.getReturnedRegisters() > 0, "No registers"), this.checkFatal(this.registers.getReturnedRegisters() <= 4, "Too many registers"), StringListExpression.DefaultImpls.getProblems(this), super.getProblems()};
        return this.combine("bitset", listArray);
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.registers.getRegisterValues(schemaDevice);
    }

    @Override
    @Nullable
    public List<String> getValue(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        byte[] bytes = this.registers.getByteArray(schemaDevice);
        if (bytes == null || bytes.length == 0 || this.isNotImplemented(bytes)) {
            return null;
        }
        ByteConversions.INSTANCE.reverse(bytes);
        BitSet bitSet = BitSet.valueOf(bytes);
        List result = new ArrayList();
        int n = bitSet.size();
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            Object value = this.mappings.get(i);
            if (value == null) {
                value = "Bit " + i;
            }
            result.add(value);
        }
        return result;
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return StringListExpression.DefaultImpls.getReturnType(this);
    }

    private static final CharSequence toString$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + "->'" + it.getValue() + "'";
    }
}

