/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.strings;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.NotImplemented;
import nl.basjes.modbus.schema.expression.registers.RegistersExpression;
import nl.basjes.modbus.schema.expression.strings.StringExpression;
import nl.basjes.modbus.schema.utils.ByteConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lnl/basjes/modbus/schema/expression/strings/Eui48String;", "Lnl/basjes/modbus/schema/expression/NotImplemented;", "Lnl/basjes/modbus/schema/expression/strings/StringExpression;", "registers", "Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "notImplemented", "", "", "<init>", "(Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;Ljava/util/List;)V", "toString", "subExpressions", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "isImmutable", "", "()Z", "setImmutable", "(Z)V", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getRegisterValues", "Lnl/basjes/modbus/device/api/RegisterValue;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "getValue", "modbus-schema-device"})
public final class Eui48String
extends NotImplemented
implements StringExpression {
    @NotNull
    private final RegistersExpression registers;
    private boolean isImmutable;

    public Eui48String(@NotNull RegistersExpression registers, @NotNull List<String> notImplemented) {
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        Intrinsics.checkNotNullParameter(notImplemented, (String)"notImplemented");
        super(registers.getReturnedRegisters(), notImplemented);
        this.registers = registers;
    }

    @Override
    @NotNull
    public String toString() {
        return "eui48(" + this.registers + super.toString() + ")";
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return CollectionsKt.listOf((Object)this.registers);
    }

    @Override
    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public void setImmutable(boolean bl) {
        this.isImmutable = bl;
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[3];
        Object[] objectArray = new Integer[]{3, 4};
        listArray[0] = this.checkFatal(CollectionsKt.listOf((Object[])objectArray).contains(this.registers.getReturnedRegisters()), "Must have 3 or 4 registers (got " + this.registers.getReturnedRegisters() + ")");
        listArray[1] = StringExpression.DefaultImpls.getProblems(this);
        listArray[2] = super.getProblems();
        return this.combine("enum", listArray);
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.registers.getRegisterValues(schemaDevice);
    }

    @Override
    @Nullable
    public String getValue(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        byte[] byArray = this.registers.getByteArray(schemaDevice);
        if (byArray == null) {
            return null;
        }
        byte[] bytes = byArray;
        if (this.isNotImplemented(bytes)) {
            return null;
        }
        if (bytes.length > 6) {
            byte[] byArray2 = Arrays.copyOfRange(bytes, bytes.length - 6, bytes.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOfRange(...)");
            bytes = byArray2;
        }
        if (this.isNotImplemented(bytes)) {
            return null;
        }
        return ByteConversions.INSTANCE.bytesToSeparatedHexString(bytes, ":");
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return StringExpression.DefaultImpls.getReturnType(this);
    }
}

