/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.fetcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.fetcher.RegisterBlockFetcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\tR$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lnl/basjes/modbus/schema/fetcher/OptimizingRegisterBlockFetcher;", "Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;Lnl/basjes/modbus/device/api/ModbusDevice;)V", "value", "", "allowedGapReadSize", "getAllowedGapReadSize", "()I", "setAllowedGapReadSize", "(I)V", "calculateFetchBatches", "", "Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch;", "maxAge", "", "overlaps", "", "Lnl/basjes/modbus/device/api/Address;", "firstAddress", "count", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nOptimizingRegisterBlockFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptimizingRegisterBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/OptimizingRegisterBlockFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1#2:152\n1#2:195\n774#3:153\n865#3,2:154\n1374#3:156\n1460#3,5:157\n1374#3:162\n1460#3,5:163\n1563#3:168\n1634#3,3:169\n1374#3:172\n1460#3,5:173\n774#3:178\n865#3,2:179\n1563#3:181\n1634#3,3:182\n1617#3,9:185\n1869#3:194\n1870#3:196\n1626#3:197\n1761#3,3:198\n*S KotlinDebug\n*F\n+ 1 OptimizingRegisterBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/OptimizingRegisterBlockFetcher\n*L\n147#1:195\n47#1:153\n47#1:154,2\n58#1:156\n58#1:157,5\n59#1:162\n59#1:163,5\n60#1:168\n60#1:169,3\n66#1:172\n66#1:173,5\n67#1:178\n67#1:179,2\n68#1:181\n68#1:182,3\n147#1:185,9\n147#1:194\n147#1:196\n147#1:197\n148#1:198,3\n*E\n"})
public final class OptimizingRegisterBlockFetcher
extends RegisterBlockFetcher {
    private int allowedGapReadSize;

    public OptimizingRegisterBlockFetcher(@NotNull SchemaDevice schemaDevice, @NotNull ModbusDevice modbusDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        super(schemaDevice, modbusDevice);
    }

    public final int getAllowedGapReadSize() {
        return this.allowedGapReadSize;
    }

    public final void setAllowedGapReadSize(int value) {
        if (!(value >= 0)) {
            boolean bl = false;
            String string = "A negative Gap Read Size is not allowed";
            throw new IllegalArgumentException(string.toString());
        }
        this.allowedGapReadSize = value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<RegisterBlockFetcher.FetchBatch> calculateFetchBatches(long maxAge) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        List fetchBatches = new ArrayList();
        List<RegisterBlockFetcher.FetchBatch> rawFetchBatchList = super.calculateFetchBatches(maxAge);
        Iterable iterable = rawFetchBatchList;
        boolean $i$f$filter22 = false;
        void var8_7 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            boolean bl;
            block14: {
                RegisterBlockFetcher.FetchBatch it = (RegisterBlockFetcher.FetchBatch)element$iv$iv;
                boolean bl2 = false;
                for (Field field : it.getFields()) {
                    if (!field.isUsingReadErrorRegisters()) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List baseFetchBatchList = (List)destination$iv$iv;
        Iterable $i$f$filter22 = baseFetchBatchList;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            RegisterBlockFetcher.FetchBatch it = (RegisterBlockFetcher.FetchBatch)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFields();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv2 = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            Field it = (Field)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getRequiredRegisters();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map22 = false;
        $this$flatMapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Address list$iv$iv = (Address)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getAddressClass());
        }
        List usedAddressClasses = CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)));
        Iterable $i$f$map22 = usedAddressClasses;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            AddressClass it = (AddressClass)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getSchemaDevice().getRegisterBlock(it).getValues();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv3;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RegisterValue it = (RegisterValue)element$iv$iv;
            boolean bl = false;
            if (!it.isReadError()) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RegisterValue it = (RegisterValue)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.getAddress());
        }
        List readErrorAddresses = CollectionsKt.toList((Iterable)((List)destination$iv$iv3));
        Iterator fetchBatchIterator = baseFetchBatchList.iterator();
        if (!fetchBatchIterator.hasNext()) {
            return CollectionsKt.emptyList();
        }
        RegisterBlockFetcher.FetchBatch nextInput = (RegisterBlockFetcher.FetchBatch)fetchBatchIterator.next();
        RegisterBlockFetcher.MergedFetchBatch nextBatch = new RegisterBlockFetcher.MergedFetchBatch(nextInput.getStart(), nextInput.getCount());
        nextBatch.add(nextInput);
        fetchBatches.add(nextBatch);
        while (fetchBatchIterator.hasNext()) {
            nextInput = (RegisterBlockFetcher.FetchBatch)fetchBatchIterator.next();
            if (nextBatch.getStart().getAddressClass() != nextInput.getStart().getAddressClass()) {
                nextBatch = new RegisterBlockFetcher.MergedFetchBatch(nextInput.getStart(), nextInput.getCount());
                nextBatch.add(nextInput);
                fetchBatches.add(nextBatch);
                continue;
            }
            Address lastOfNextBatch = nextBatch.getStart().increment(nextBatch.getCount());
            if (Intrinsics.areEqual((Object)nextInput.getStart(), (Object)lastOfNextBatch)) {
                if (nextBatch.getCount() + nextInput.getCount() <= this.getModbusDevice().getMaxRegistersPerModbusRequest()) {
                    RegisterBlockFetcher.MergedFetchBatch $i$f$mapTo22 = nextBatch;
                    $i$f$mapTo22.setCount($i$f$mapTo22.getCount() + nextInput.getCount());
                    nextBatch.add(nextInput);
                    continue;
                }
                nextBatch = new RegisterBlockFetcher.MergedFetchBatch(nextInput.getStart(), nextInput.getCount());
                nextBatch.add(nextInput);
                fetchBatches.add(nextBatch);
                continue;
            }
            int nextBatchStart = nextBatch.getStart().getPhysicalAddress();
            int nextInputStart = nextInput.getStart().getPhysicalAddress();
            int gapSize = nextInputStart - (nextBatchStart + nextBatch.getCount());
            int mergedCount = nextInputStart + nextInput.getCount() - nextBatchStart;
            if (gapSize <= this.allowedGapReadSize && mergedCount <= this.getModbusDevice().getMaxRegistersPerModbusRequest() && !this.overlaps(readErrorAddresses, nextBatch.getStart(), mergedCount)) {
                nextBatch.setCount(mergedCount);
                nextBatch.add(nextInput);
                continue;
            }
            nextBatch = new RegisterBlockFetcher.MergedFetchBatch(nextInput.getStart(), nextInput.getCount());
            nextBatch.add(nextInput);
            fetchBatches.add(nextBatch);
        }
        return fetchBatches;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean overlaps(@NotNull List<Address> $this$overlaps, @NotNull Address firstAddress, int count) {
        boolean bl;
        block6: {
            void $this$any$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter($this$overlaps, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)firstAddress, (String)"firstAddress");
            if ($this$overlaps.isEmpty()) {
                return false;
            }
            if (!(count > 0)) {
                boolean $i$a$-require-OptimizingRegisterBlockFetcher$overlaps$22 = false;
                String $i$a$-require-OptimizingRegisterBlockFetcher$overlaps$22 = "At least one address is required";
                throw new IllegalArgumentException($i$a$-require-OptimizingRegisterBlockFetcher$overlaps$22.toString());
            }
            Iterable iterable = $this$overlaps;
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                Address it = (Address)element$iv$iv;
                boolean bl3 = false;
                if (firstAddress.distance(it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl5 = false;
                    boolean bl6 = 0 <= it ? it <= count : false;
                    if (!bl6) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }
}

