/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.fetcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001c\u001d\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher;", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;Lnl/basjes/modbus/device/api/ModbusDevice;)V", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "getModbusDevice", "()Lnl/basjes/modbus/device/api/ModbusDevice;", "calculateFetchGroupToAddressesMapping", "", "", "", "Lnl/basjes/modbus/device/api/Address;", "update", "", "field", "Lnl/basjes/modbus/schema/Field;", "maxAge", "", "fetch", "fetchBatch", "Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch;", "calculateFetchBatches", "", "FetchBatch", "MergedFetchBatch", "Companion", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nRegisterBlockFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisterBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n1761#2,3:245\n1869#2,2:248\n1563#2:250\n1634#2,3:251\n295#2,2:254\n*S KotlinDebug\n*F\n+ 1 RegisterBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher\n*L\n174#1:245,3\n183#1:248,2\n213#1:250\n213#1:251,3\n214#1:254,2\n*E\n"})
public class RegisterBlockFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaDevice schemaDevice;
    @NotNull
    private final ModbusDevice modbusDevice;
    @NotNull
    private static final Logger LOG;

    public RegisterBlockFetcher(@NotNull SchemaDevice schemaDevice, @NotNull ModbusDevice modbusDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        this.schemaDevice = schemaDevice;
        this.modbusDevice = modbusDevice;
    }

    @NotNull
    protected final SchemaDevice getSchemaDevice() {
        return this.schemaDevice;
    }

    @NotNull
    protected final ModbusDevice getModbusDevice() {
        return this.modbusDevice;
    }

    private final Map<String, List<Address>> calculateFetchGroupToAddressesMapping() {
        Map fetchGroupToAddresses = new TreeMap();
        for (Block entry : this.schemaDevice.getBlocks()) {
            for (Field field : entry.getFields()) {
                String fieldFetchGroup = field.getFetchGroup();
                boolean fieldImmutable = field.isImmutable();
                List<Address> requiredRegisters = field.getRequiredRegisters();
                for (Address requiredRegister : requiredRegisters) {
                    RegisterValue registerValue = this.schemaDevice.getRegisterBlock(requiredRegister.getAddressClass()).computeIfAbsent(requiredRegister, RegisterBlockFetcher::calculateFetchGroupToAddressesMapping$lambda$0);
                    registerValue.setImmutable(fieldImmutable);
                    registerValue.setFetchGroup(fieldFetchGroup);
                }
                fetchGroupToAddresses.computeIfAbsent(fieldFetchGroup, arg_0 -> RegisterBlockFetcher.calculateFetchGroupToAddressesMapping$lambda$2(RegisterBlockFetcher::calculateFetchGroupToAddressesMapping$lambda$1, arg_0)).addAll((Collection)requiredRegisters);
            }
        }
        for (Map.Entry entry : fetchGroupToAddresses.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            List fetchGroupAddresses = CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)value)));
            if (fetchGroupAddresses.isEmpty()) continue;
            Address firstAddress = (Address)fetchGroupAddresses.get(0);
            int numberOfAddresses = fetchGroupAddresses.size();
            Address lastAddress = (Address)fetchGroupAddresses.get(numberOfAddresses - 1);
            if (Intrinsics.areEqual((Object)firstAddress.increment(numberOfAddresses - 1), (Object)lastAddress)) continue;
            boolean bl = false;
            String string = "There are gaps in the addresses for fetch group \"" + key + "\": " + fetchGroupAddresses;
            throw new IllegalStateException(string.toString());
        }
        return fetchGroupToAddresses;
    }

    public final void update(@NotNull Field field) throws ModbusException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (field.isUsingReadErrorRegisters()) {
            return;
        }
        Map<String, List<Address>> fetchGroupToAddresses = this.calculateFetchGroupToAddressesMapping();
        List<Address> requiredRegisters = fetchGroupToAddresses.get(field.getFetchGroup());
        Collection collection = requiredRegisters;
        if (collection == null || collection.isEmpty()) {
            requiredRegisters = field.getRequiredRegisters();
        }
        RegisterBlock deviceRegisters = this.modbusDevice.getRegisters(requiredRegisters.get(0), requiredRegisters.size());
        this.schemaDevice.getRegisterBlock(deviceRegisters.getAddressClass()).merge(deviceRegisters);
    }

    @JvmOverloads
    public final void update(long maxAge) {
        for (FetchBatch fetchBatch : this.calculateFetchBatches(maxAge)) {
            this.fetch(fetchBatch);
        }
    }

    public static /* synthetic */ void update$default(RegisterBlockFetcher registerBlockFetcher, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        registerBlockFetcher.update(l);
    }

    private final void fetch(FetchBatch fetchBatch) {
        try {
            RegisterValue it;
            boolean bl;
            RegisterBlock registerBlock;
            RegisterBlock registers;
            block10: {
                registers = this.modbusDevice.getRegisters(fetchBatch.getStart(), fetchBatch.getCount());
                registerBlock = this.schemaDevice.getRegisterBlock(registers.getAddressClass());
                registerBlock.merge(registers);
                Iterable $this$any$iv = registers.getValues();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        it = (RegisterValue)element$iv;
                        boolean bl2 = false;
                        if (!it.isReadError()) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                if (fetchBatch instanceof MergedFetchBatch) {
                    for (FetchBatch fetchPart : ((MergedFetchBatch)fetchBatch).getFetchBatches()) {
                        this.fetch(fetchPart);
                    }
                } else {
                    Iterable $this$forEach$iv = registers.getValues();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (RegisterValue)element$iv;
                        boolean bl3 = false;
                        it.setHardReadError();
                    }
                    registerBlock.merge(registers);
                }
            }
        }
        catch (ModbusException me) {
            LOG.error("Got ModbusException on {} --> {}", (Object)fetchBatch, (Object)me);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<FetchBatch> calculateFetchBatches(long maxAge) {
        long now = System.currentTimeMillis();
        List fieldsThatMustBeUpdated = new ArrayList();
        for (Field field : this.schemaDevice.neededFields()) {
            Object v0;
            block5: {
                void $this$firstOrNull$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                List<Address> requiredRegisters = field.getRequiredRegisters();
                if (requiredRegisters.isEmpty()) continue;
                RegisterBlock registerBlock = this.schemaDevice.getRegisterBlock(requiredRegisters.get(0).getAddressClass());
                Iterable iterable = requiredRegisters;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Address address = (Address)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(registerBlock.get((Address)it));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RegisterValue it = (RegisterValue)element$iv;
                    boolean bl = false;
                    if (!it.needsToBeUpdated(now, maxAge)) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            if (v0 == null) continue;
            fieldsThatMustBeUpdated.add(field);
        }
        Map<String, List<Address>> fetchGroupToAddresses = this.calculateFetchGroupToAddressesMapping();
        Map fetchBatchesMap = new TreeMap();
        for (Field field : fieldsThatMustBeUpdated) {
            List<Address> addresses;
            FetchBatch fetchBatch = (FetchBatch)fetchBatchesMap.get(field.getFetchGroup());
            if (fetchBatch != null) {
                fetchBatch.getFields().add(field);
                continue;
            }
            Intrinsics.checkNotNull(fetchGroupToAddresses.get(field.getFetchGroup()));
            fetchBatch = new FetchBatch(addresses.get(0), addresses.size());
            fetchBatch.getFields().add(field);
            fetchBatchesMap.put(field.getFetchGroup(), fetchBatch);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)fetchBatchesMap.values()));
    }

    @JvmOverloads
    public final void update() {
        RegisterBlockFetcher.update$default(this, 0L, 1, null);
    }

    private static final RegisterValue calculateFetchGroupToAddressesMapping$lambda$0(Address it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RegisterValue(it);
    }

    private static final List calculateFetchGroupToAddressesMapping$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List calculateFetchGroupToAddressesMapping$lambda$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$Companion;", "", "<init>", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "modbus-schema-device"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\u0011\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0017\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch;", "", "start", "Lnl/basjes/modbus/device/api/Address;", "count", "", "<init>", "(Lnl/basjes/modbus/device/api/Address;I)V", "getStart", "()Lnl/basjes/modbus/device/api/Address;", "getCount", "()I", "setCount", "(I)V", "fields", "", "Lnl/basjes/modbus/schema/Field;", "getFields", "()Ljava/util/List;", "isUsingReadErrorRegisters", "", "compareTo", "other", "equals", "", "hashCode", "toString", "", "modbus-schema-device"})
    public static class FetchBatch
    implements Comparable<FetchBatch> {
        @NotNull
        private final Address start;
        private int count;
        @NotNull
        private final List<Field> fields;

        public FetchBatch(@NotNull Address start, int count) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            this.start = start;
            this.count = count;
            this.fields = new ArrayList();
        }

        @NotNull
        public final Address getStart() {
            return this.start;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        @NotNull
        public final List<Field> getFields() {
            return this.fields;
        }

        public final boolean isUsingReadErrorRegisters() {
            for (Field field : this.fields) {
                if (!field.isUsingReadErrorRegisters()) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(@NotNull FetchBatch other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int addressCompare = this.start.compareTo(other.start);
            if (addressCompare != 0) {
                return addressCompare;
            }
            return Intrinsics.compare((int)this.count, (int)other.count);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FetchBatch)) {
                return false;
            }
            return this.count == ((FetchBatch)other).count && Intrinsics.areEqual((Object)this.start, (Object)((FetchBatch)other).start);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.start, this.count};
            return Objects.hash(objectArray);
        }

        @NotNull
        public String toString() {
            return "FetchBatch { " + this.start + " # " + this.count + " } (Fields: " + CollectionsKt.joinToString$default((Iterable)this.fields, (CharSequence)", ", null, null, (int)0, null, FetchBatch::toString$lambda$0, (int)30, null) + ")";
        }

        private static final CharSequence toString$lambda$0(Field it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getBlock().getId() + "[" + it.getId() + "]";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$MergedFetchBatch;", "Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch;", "start", "Lnl/basjes/modbus/device/api/Address;", "count", "", "<init>", "(Lnl/basjes/modbus/device/api/Address;I)V", "fetchBatches", "", "getFetchBatches", "()Ljava/util/List;", "add", "", "fetchBatch", "modbus-schema-device"})
    public static final class MergedFetchBatch
    extends FetchBatch {
        @NotNull
        private final List<FetchBatch> fetchBatches;

        public MergedFetchBatch(@NotNull Address start, int count) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            super(start, count);
            this.fetchBatches = new ArrayList();
        }

        @NotNull
        public final List<FetchBatch> getFetchBatches() {
            return this.fetchBatches;
        }

        public final void add(@NotNull FetchBatch fetchBatch) {
            Intrinsics.checkNotNullParameter((Object)fetchBatch, (String)"fetchBatch");
            this.fetchBatches.add(fetchBatch);
            this.getFields().addAll((Collection<Field>)fetchBatch.getFields());
        }
    }
}

