/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.utils;

import java.util.Arrays;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\u0010\u0006\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eJ\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnl/basjes/modbus/schema/utils/DoubleToString;", "", "<init>", "()V", "ZERO_STRIPPER_1", "Ljava/util/regex/Pattern;", "ZERO_STRIPPER_2", "format", "", "value", "maxDigits", "", "of", "", "", "modbus-schema-device"})
public final class DoubleToString {
    @NotNull
    public static final DoubleToString INSTANCE = new DoubleToString();
    @NotNull
    private static final Pattern ZERO_STRIPPER_1;
    @NotNull
    private static final Pattern ZERO_STRIPPER_2;

    private DoubleToString() {
    }

    private final String format(Object value, long maxDigits) {
        double d;
        if (value instanceof Float) {
            d = ((Number)value).floatValue();
        } else {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Double");
            d = (Double)value;
        }
        double doubleValue = d;
        double log10 = Math.log10(doubleValue);
        long fDigits = 1L;
        if (Math.abs(log10) <= Double.MAX_VALUE) {
            fDigits = (long)Math.floor(log10);
        }
        long digits = 0L;
        long decimals = 0L;
        if (fDigits < 1L) {
            digits = 1L;
            decimals = maxDigits - fDigits;
        } else {
            digits = (long)Math.min((double)maxDigits, (double)fDigits);
            decimals = (long)Math.max((double)(maxDigits - digits), 1.0);
        }
        String string = "%%%d.%df";
        Object[] objectArray = new Object[]{digits, decimals};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String format = string2;
        objectArray = new Object[]{value};
        String string3 = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String result = string3;
        String string4 = ZERO_STRIPPER_1.matcher(result).replaceAll("$1");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"replaceAll(...)");
        result = string4;
        String string5 = ZERO_STRIPPER_2.matcher(result).replaceAll("");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"replaceAll(...)");
        result = string5;
        return result;
    }

    @NotNull
    public final String of(float value) {
        if (!(Math.abs(value) <= Float.MAX_VALUE) || Float.isNaN(value)) {
            return String.valueOf(value);
        }
        long maxDigits = 6L;
        return this.format(Float.valueOf(value), maxDigits);
    }

    @NotNull
    public final String of(double value) {
        long maxDigits = 10L;
        return this.of(value, maxDigits);
    }

    @NotNull
    public final String of(double value, long maxDigits) {
        if (!(Math.abs(value) <= Double.MAX_VALUE) || Double.isNaN(value)) {
            return String.valueOf(value);
        }
        return this.format(value, maxDigits);
    }

    static {
        Pattern pattern = Pattern.compile("(\\.([1-9]|[0-9]+[1-9]+?))0+$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        ZERO_STRIPPER_1 = pattern;
        Pattern pattern2 = Pattern.compile("\\.0+$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        ZERO_STRIPPER_2 = pattern2;
    }
}

