/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.utils.ByteConversions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\u0006H\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lnl/basjes/modbus/schema/expression/NotImplemented;", "Lnl/basjes/modbus/schema/expression/Expression;", "expectedRegisters", "", "notImplementedStrings", "", "", "<init>", "(ILjava/util/List;)V", "toString", "notImplementedBytes", "", "", "[[B", "", "notImplemented", "getNotImplemented", "()Ljava/util/List;", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "isValidNotImplemented", "", "byteCount", "isNotImplemented", "bytes", "modbus-schema-device"})
public abstract class NotImplemented
implements Expression {
    private final int expectedRegisters;
    @NotNull
    private final byte[][] notImplementedBytes;
    @NotNull
    private final List<String> notImplementedStrings;
    @NotNull
    private final List<List<String>> notImplemented;

    public NotImplemented(int expectedRegisters, @NotNull List<String> notImplementedStrings) {
        Intrinsics.checkNotNullParameter(notImplementedStrings, (String)"notImplementedStrings");
        this.expectedRegisters = expectedRegisters;
        this.notImplementedBytes = ByteConversions.INSTANCE.hexStringToBytes(notImplementedStrings);
        this.notImplementedStrings = new ArrayList();
        this.notImplemented = new ArrayList();
        byte[][] byArray = this.notImplementedBytes;
        int n = ((Object[])byArray).length;
        for (int i = 0; i < n; ++i) {
            byte[] notImplementedByte = byArray[i];
            this.notImplementedStrings.add("0x" + ByteConversions.INSTANCE.bytesToSeparatedTwoByteHexString(notImplementedByte, " 0x"));
            this.notImplemented.add(ByteConversions.INSTANCE.bytesToTwoByteHexStringList(notImplementedByte));
        }
    }

    @NotNull
    public String toString() {
        if (this.notImplementedStrings.isEmpty()) {
            return "";
        }
        return " ; " + CollectionsKt.joinToString$default((Iterable)this.notImplementedStrings, (CharSequence)" ; ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final List<List<String>> getNotImplemented() {
        return this.notImplemented;
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{this.checkFatal(this.isValidNotImplemented(this.expectedRegisters * 2), "Wrong number of registers: Got " + ((Object[])this.notImplementedBytes).length + ", need " + this.expectedRegisters * 2)};
        return this.combine("NotImplemented", listArray);
    }

    public final boolean isValidNotImplemented(int byteCount) {
        return ByteConversions.INSTANCE.allAreOfSize(this.notImplementedBytes, byteCount);
    }

    public final boolean isNotImplemented(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return ByteConversions.INSTANCE.arrayOfByteArraysContains(this.notImplementedBytes, bytes);
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return Expression.DefaultImpls.toString(this, isTop);
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        return Expression.DefaultImpls.initialize(this, containingField);
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return Expression.DefaultImpls.getSubExpressions(this);
    }

    @Override
    @NotNull
    public List<Address> getRequiredRegisters() {
        return Expression.DefaultImpls.getRequiredRegisters(this);
    }

    @Override
    @NotNull
    public List<Address> getRequiredMutableRegisters() {
        return Expression.DefaultImpls.getRequiredMutableRegisters(this);
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return Expression.DefaultImpls.getRequiredFields(this);
    }

    @Override
    public boolean isImmutable() {
        return Expression.DefaultImpls.isImmutable(this);
    }

    @Override
    public void setImmutable(boolean value) {
        Expression.DefaultImpls.setImmutable(this, value);
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return Expression.DefaultImpls.getReturnType(this);
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        return Expression.DefaultImpls.getRegisterValues(this, schemaDevice);
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return Expression.DefaultImpls.check(this, condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return Expression.DefaultImpls.checkFatal(this, condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return Expression.DefaultImpls.combine(this, function, problems);
    }
}

