/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.strings;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.registers.RegistersExpression;
import nl.basjes.modbus.schema.expression.strings.StringExpression;
import nl.basjes.modbus.schema.utils.ByteConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\f\u00a8\u0006\u001a"}, d2={"Lnl/basjes/modbus/schema/expression/strings/UTF8String;", "Lnl/basjes/modbus/schema/expression/strings/StringExpression;", "registers", "Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "<init>", "(Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;)V", "toString", "", "subExpressions", "", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "isImmutable", "", "()Z", "setImmutable", "(Z)V", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getRegisterValues", "Lnl/basjes/modbus/device/api/RegisterValue;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "getValue", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nUTF8String.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTF8String.kt\nnl/basjes/modbus/schema/expression/strings/UTF8String\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class UTF8String
implements StringExpression {
    @NotNull
    private final RegistersExpression registers;
    private boolean isImmutable;

    public UTF8String(@NotNull RegistersExpression registers) {
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        this.registers = registers;
    }

    @NotNull
    public String toString() {
        return "utf8(" + this.registers + ")";
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return CollectionsKt.listOf((Object)this.registers);
    }

    @Override
    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public void setImmutable(boolean bl) {
        this.isImmutable = bl;
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{StringExpression.DefaultImpls.getProblems(this)};
        return this.combine("utf8", listArray);
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.registers.getRegisterValues(schemaDevice);
    }

    @Override
    @Nullable
    public String getValue(@NotNull SchemaDevice schemaDevice) {
        String string;
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        byte[] byArray = this.registers.getByteArray(schemaDevice);
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            string = ByteConversions.INSTANCE.bytesToString(it);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return StringExpression.DefaultImpls.getReturnType(this);
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return StringExpression.DefaultImpls.toString(this, isTop);
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        return StringExpression.DefaultImpls.initialize(this, containingField);
    }

    @Override
    @NotNull
    public List<Address> getRequiredRegisters() {
        return StringExpression.DefaultImpls.getRequiredRegisters(this);
    }

    @Override
    @NotNull
    public List<Address> getRequiredMutableRegisters() {
        return StringExpression.DefaultImpls.getRequiredMutableRegisters(this);
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return StringExpression.DefaultImpls.getRequiredFields(this);
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return StringExpression.DefaultImpls.check(this, condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return StringExpression.DefaultImpls.checkFatal(this, condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return StringExpression.DefaultImpls.combine(this, function, problems);
    }
}

