/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.exceptions.ModbusSchemaParseException;
import nl.basjes.modbus.schema.utils.ParameterValidationsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0016\u0018\u0000 -2\u00020\u0001:\u0002-.B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u0019\u001a\u00020\u00002\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u001a\"\u00020\u0012\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u0005J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020%H\u0002J$\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010'\u001a\u00020\u0012H\u0002J\b\u0010(\u001a\u00020\u0005H\u0016J\u0006\u0010)\u001a\u00020%J\u0006\u0010*\u001a\u00020%J\u0006\u0010+\u001a\u00020%J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006/"}, d2={"Lnl/basjes/modbus/schema/Block;", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "id", "", "description", "shortDescription", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "getDescription", "()Ljava/lang/String;", "getShortDescription", "getId", "mutableFields", "", "Lnl/basjes/modbus/schema/Field;", "fields", "", "getFields", "()Ljava/util/List;", "fieldMap", "", "addField", "", "([Lnl/basjes/modbus/schema/Field;)Lnl/basjes/modbus/schema/Block;", "getField", "fieldId", "maxFieldIdLength", "", "getMaxFieldIdLength", "()I", "initialize", "", "findCircularReference", "", "usageChainSoFar", "field", "toString", "update", "needAll", "unNeedAll", "neededFields", "Companion", "BlockBuilder", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Block.kt\nnl/basjes/modbus/schema/Block\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1#2:219\n1869#3,2:220\n1869#3,2:222\n1869#3,2:224\n774#3:226\n865#3,2:227\n*S KotlinDebug\n*F\n+ 1 Block.kt\nnl/basjes/modbus/schema/Block\n*L\n145#1:220,2\n150#1:222,2\n155#1:224,2\n160#1:226\n160#1:227,2\n*E\n"})
public class Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaDevice schemaDevice;
    @Nullable
    private final String description;
    @Nullable
    private final String shortDescription;
    @NotNull
    private final String id;
    @NotNull
    private final List<Field> mutableFields;
    @NotNull
    private final List<Field> fields;
    @NotNull
    private final Map<String, Field> fieldMap;

    public Block(@NotNull SchemaDevice schemaDevice, @NotNull String id, @Nullable String description, @Nullable String shortDescription) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.schemaDevice = schemaDevice;
        this.description = description;
        this.shortDescription = shortDescription;
        this.id = ((Object)StringsKt.trim((CharSequence)id)).toString();
        this.mutableFields = new ArrayList();
        this.fields = this.mutableFields;
        this.fieldMap = new TreeMap();
        ParameterValidationsKt.requireValidIdentifier(id, "Block id");
        this.schemaDevice.addBlock(this);
    }

    public /* synthetic */ Block(SchemaDevice schemaDevice, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = string2;
        }
        this(schemaDevice, string, string2, string3);
    }

    @NotNull
    public final SchemaDevice getSchemaDevice() {
        return this.schemaDevice;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    @Nullable
    public final String getShortDescription() {
        return this.shortDescription;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final List<Field> getFields() {
        return this.fields;
    }

    @NotNull
    public final Block addField(Field ... fields) {
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        for (Field field : fields) {
            if (this.fieldMap.get(field.getId()) != null) {
                throw new ModbusSchemaParseException("Field " + field + " already exists.");
            }
            this.mutableFields.add(field);
            this.fieldMap.put(field.getId(), field);
        }
        this.schemaDevice.aFieldWasChanged();
        return this;
    }

    @Nullable
    public final Field getField(@NotNull String fieldId) {
        Intrinsics.checkNotNullParameter((Object)fieldId, (String)"fieldId");
        return this.fieldMap.get(fieldId);
    }

    public final int getMaxFieldIdLength() {
        Comparable comparable;
        Iterator iterator = ((Iterable)this.fieldMap.keySet()).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            String it = (String)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.length());
            while (iterator.hasNext()) {
                String it2 = (String)iterator.next();
                $i$a$-maxOfOrNull-Block$maxFieldIdLength$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.length());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    public final boolean initialize() {
        for (Field field : this.fields) {
            field.initialize();
        }
        for (Field field : this.fields) {
            if (field.initialize()) continue;
            return false;
        }
        this.findCircularReference();
        return true;
    }

    private final void findCircularReference() {
        for (Field field : this.fields) {
            List<String> circularReference = this.findCircularReference(CollectionsKt.emptyList(), field);
            if (!(!((Collection)circularReference).isEmpty())) continue;
            throw new ModbusSchemaParseException("Found circular reference starting with field \"" + field.getId() + "\" : " + circularReference);
        }
    }

    private final List<String> findCircularReference(List<String> usageChainSoFar, Field field) {
        if (usageChainSoFar.contains(field.getId())) {
            return usageChainSoFar;
        }
        List usageChain = new ArrayList(usageChainSoFar);
        usageChain.add(field.getId());
        for (String requiredFieldName : field.getRequiredFieldNames()) {
            Field requiredField;
            if (this.fieldMap.get(requiredFieldName) == null) {
                throw new ModbusSchemaParseException("Required field \"" + requiredFieldName + "\" (needed for \"" + field.getId() + "\") is missing.");
            }
            List<String> circularReference = this.findCircularReference(usageChain, requiredField);
            if (!(!((Collection)circularReference).isEmpty())) continue;
            return circularReference;
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String toString() {
        return "Block(id='" + this.id + "', description=" + this.description + ", fieldMap=" + this.fieldMap + ")";
    }

    public final void update() {
        Iterable $this$forEach$iv = this.fields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            it.update();
        }
    }

    public final void needAll() {
        Iterable $this$forEach$iv = this.fields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            it.need();
        }
    }

    public final void unNeedAll() {
        Iterable $this$forEach$iv = this.fields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            it.unNeed();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Field> neededFields() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.fields;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Field it = (Field)element$iv$iv;
            boolean bl = false;
            if (!it.isNeeded()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final BlockBuilder builder() {
        return Companion.builder();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u0017R+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnl/basjes/modbus/schema/Block$BlockBuilder;", "", "<init>", "()V", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "<set-?>", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "setSchemaDevice", "(Lnl/basjes/modbus/schema/SchemaDevice;)V", "schemaDevice$delegate", "Lkotlin/properties/ReadWriteProperty;", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "id$delegate", "description", "shortDescription", "build", "Lnl/basjes/modbus/schema/Block;", "modbus-schema-device"})
    @SourceDebugExtension(value={"SMAP\nBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Block.kt\nnl/basjes/modbus/schema/Block$BlockBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
    public static class BlockBuilder {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty schemaDevice$delegate = Delegates.INSTANCE.notNull();
        @NotNull
        private final ReadWriteProperty id$delegate = Delegates.INSTANCE.notNull();
        @Nullable
        private String description;
        @Nullable
        private String shortDescription;

        @NotNull
        public final BlockBuilder schemaDevice(@NotNull SchemaDevice schemaDevice) {
            BlockBuilder blockBuilder;
            Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
            BlockBuilder $this$schemaDevice_u24lambda_u240 = blockBuilder = this;
            boolean bl = false;
            $this$schemaDevice_u24lambda_u240.setSchemaDevice(schemaDevice);
            return blockBuilder;
        }

        private final SchemaDevice getSchemaDevice() {
            return (SchemaDevice)this.schemaDevice$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final void setSchemaDevice(SchemaDevice schemaDevice) {
            this.schemaDevice$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)schemaDevice);
        }

        @NotNull
        public final BlockBuilder id(@NotNull String id) {
            BlockBuilder blockBuilder;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            BlockBuilder $this$id_u24lambda_u241 = blockBuilder = this;
            boolean bl = false;
            $this$id_u24lambda_u241.setId(id);
            return blockBuilder;
        }

        private final String getId() {
            return (String)this.id$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        private final void setId(String string) {
            this.id$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
        }

        @NotNull
        public final BlockBuilder description(@NotNull String description) {
            BlockBuilder blockBuilder;
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            BlockBuilder $this$description_u24lambda_u242 = blockBuilder = this;
            boolean bl = false;
            $this$description_u24lambda_u242.description = description;
            return blockBuilder;
        }

        @NotNull
        public final BlockBuilder shortDescription(@NotNull String shortDescription) {
            BlockBuilder blockBuilder;
            Intrinsics.checkNotNullParameter((Object)shortDescription, (String)"shortDescription");
            BlockBuilder $this$shortDescription_u24lambda_u243 = blockBuilder = this;
            boolean bl = false;
            $this$shortDescription_u24lambda_u243.shortDescription = shortDescription;
            return blockBuilder;
        }

        @NotNull
        public final Block build() {
            SchemaDevice schemaDevice = this.getSchemaDevice();
            String string = this.getId();
            String string2 = this.shortDescription;
            if (string2 == null) {
                string2 = this.description;
            }
            Block block = new Block(schemaDevice, string, this.description, string2);
            return block;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BlockBuilder.class, "schemaDevice", "getSchemaDevice()Lnl/basjes/modbus/schema/SchemaDevice;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BlockBuilder.class, "id", "getId()Ljava/lang/String;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lnl/basjes/modbus/schema/Block$Companion;", "", "<init>", "()V", "builder", "Lnl/basjes/modbus/schema/Block$BlockBuilder;", "modbus-schema-device"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BlockBuilder builder() {
            return new BlockBuilder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

