/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.registers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.registers.RegistersExpression;
import nl.basjes.modbus.schema.utils.ByteConversions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010\u0017R\u001d\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u0014\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u001e\u001a\u0004\b\"\u0010\u0017\u00a8\u0006#"}, d2={"Lnl/basjes/modbus/schema/expression/registers/RegistersConstantExpression;", "Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "theBytes", "", "returnedRegisters", "", "getReturnedRegisters", "()I", "isImmutable", "", "()Z", "setImmutable", "(Z)V", "problems", "", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "()Ljava/util/List;", "toString", "getByteArray", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "asByteHexStrings", "getAsByteHexStrings$annotations", "()V", "getAsByteHexStrings", "asRegisterHexStrings", "getAsRegisterHexStrings$annotations", "getAsRegisterHexStrings", "modbus-schema-device"})
public class RegistersConstantExpression
implements RegistersExpression {
    @NotNull
    private final String value;
    @NotNull
    private final byte[] theBytes;
    private boolean isImmutable;
    @NotNull
    private final List<Expression.Problem> problems;
    @NotNull
    private final List<String> asByteHexStrings;
    @NotNull
    private final List<String> asRegisterHexStrings;

    public RegistersConstantExpression(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        this.theBytes = ByteConversions.INSTANCE.hexStringToBytes(this.value);
        this.isImmutable = true;
        this.problems = CollectionsKt.emptyList();
        this.asByteHexStrings = ByteConversions.INSTANCE.bytesToHexStringList(this.theBytes);
        this.asRegisterHexStrings = ByteConversions.INSTANCE.bytesToTwoByteHexStringList(this.theBytes);
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @Override
    public int getReturnedRegisters() {
        return this.theBytes.length / 2;
    }

    @Override
    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public void setImmutable(boolean bl) {
        this.isImmutable = bl;
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        return this.problems;
    }

    @NotNull
    public String toString() {
        return "\"0x" + ByteConversions.INSTANCE.bytesToSeparatedTwoByteHexString(this.theBytes, " 0x") + "\"";
    }

    @Override
    @NotNull
    public byte[] getByteArray(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.theBytes;
    }

    @NotNull
    public final List<String> getAsByteHexStrings() {
        return this.asByteHexStrings;
    }

    public static /* synthetic */ void getAsByteHexStrings$annotations() {
    }

    @NotNull
    public final List<String> getAsRegisterHexStrings() {
        return this.asRegisterHexStrings;
    }

    public static /* synthetic */ void getAsRegisterHexStrings$annotations() {
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return RegistersExpression.DefaultImpls.toString(this, isTop);
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        return RegistersExpression.DefaultImpls.initialize(this, containingField);
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return RegistersExpression.DefaultImpls.getSubExpressions(this);
    }

    @Override
    @NotNull
    public List<Address> getRequiredRegisters() {
        return RegistersExpression.DefaultImpls.getRequiredRegisters(this);
    }

    @Override
    @NotNull
    public List<Address> getRequiredMutableRegisters() {
        return RegistersExpression.DefaultImpls.getRequiredMutableRegisters(this);
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return RegistersExpression.DefaultImpls.getRequiredFields(this);
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return RegistersExpression.DefaultImpls.getReturnType(this);
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        return RegistersExpression.DefaultImpls.getRegisterValues(this, schemaDevice);
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return RegistersExpression.DefaultImpls.check(this, condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return RegistersExpression.DefaultImpls.checkFatal(this, condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return RegistersExpression.DefaultImpls.combine(this, function, problems);
    }
}

