/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.numbers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.numbers.NumericalExpression;
import nl.basjes.modbus.schema.expression.strings.MissingField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0017\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0016\u00a2\u0006\u0002\u0010+J\u0017\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010)\u001a\u00020*H\u0016\u00a2\u0006\u0002\u0010.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0013R$\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0013\u00a8\u0006/"}, d2={"Lnl/basjes/modbus/schema/expression/numbers/NumericalField;", "Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;", "fieldName", "", "<init>", "(Ljava/lang/String;)V", "getFieldName", "()Ljava/lang/String;", "field", "Lnl/basjes/modbus/schema/Field;", "fieldExpression", "toString", "initialize", "", "containingField", "subExpressions", "", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "requiredRegisters", "Lnl/basjes/modbus/device/api/Address;", "getRequiredRegisters", "requiredFields", "getRequiredFields", "value", "isImmutable", "()Z", "setImmutable", "(Z)V", "getGuarantee", "Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression$ValueGuarantee;", "returnType", "Lnl/basjes/modbus/schema/ReturnType;", "getReturnType", "()Lnl/basjes/modbus/schema/ReturnType;", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getValueAsDouble", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "(Lnl/basjes/modbus/schema/SchemaDevice;)Ljava/lang/Double;", "getValueAsLong", "", "(Lnl/basjes/modbus/schema/SchemaDevice;)Ljava/lang/Long;", "modbus-schema-device"})
public final class NumericalField
implements NumericalExpression {
    @NotNull
    private final String fieldName;
    private Field field;
    @NotNull
    private NumericalExpression fieldExpression;

    public NumericalField(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        this.fieldName = fieldName;
        this.fieldExpression = new MissingField(this.fieldName);
    }

    @NotNull
    public final String getFieldName() {
        return this.fieldName;
    }

    @NotNull
    public String toString() {
        return this.fieldName;
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        Expression expression;
        Intrinsics.checkNotNullParameter((Object)containingField, (String)"containingField");
        Block block = containingField.getBlock();
        Field retrievedField = block.getField(this.fieldName);
        if (retrievedField == null) {
            return false;
        }
        this.field = retrievedField;
        Field field = this.field;
        if (field == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"field");
            field = null;
        }
        if ((expression = field.getParsedExpression()) instanceof NumericalExpression) {
            this.fieldExpression = (NumericalExpression)expression;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return CollectionsKt.listOf((Object)this.fieldExpression);
    }

    @Override
    @NotNull
    public List<Address> getRequiredRegisters() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return CollectionsKt.listOf((Object)this.fieldName);
    }

    @Override
    public boolean isImmutable() {
        return this.fieldExpression.isImmutable();
    }

    @Override
    public void setImmutable(boolean value) {
        this.fieldExpression.setImmutable(value);
    }

    @Override
    @NotNull
    public NumericalExpression.ValueGuarantee getGuarantee() {
        return this.fieldExpression.getGuarantee();
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return this.fieldExpression.getReturnType();
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{NumericalExpression.DefaultImpls.getProblems(this)};
        return this.combine("NumericalField", listArray);
    }

    @Override
    @Nullable
    public Double getValueAsDouble(@NotNull SchemaDevice schemaDevice) throws ModbusException {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.fieldExpression.getValueAsDouble(schemaDevice);
    }

    @Override
    @Nullable
    public Long getValueAsLong(@NotNull SchemaDevice schemaDevice) throws ModbusException {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.fieldExpression.getValueAsLong(schemaDevice);
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return NumericalExpression.DefaultImpls.toString(this, isTop);
    }

    @Override
    @NotNull
    public List<Address> getRequiredMutableRegisters() {
        return NumericalExpression.DefaultImpls.getRequiredMutableRegisters(this);
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        return NumericalExpression.DefaultImpls.getRegisterValues(this, schemaDevice);
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return NumericalExpression.DefaultImpls.check(this, condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return NumericalExpression.DefaultImpls.checkFatal(this, condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return NumericalExpression.DefaultImpls.combine(this, function, problems);
    }
}

