/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.fetcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.fetcher.OptimizingRegisterBlockFetcherKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001d\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rH\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0013J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher;", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;Lnl/basjes/modbus/device/api/ModbusDevice;)V", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "getModbusDevice", "()Lnl/basjes/modbus/device/api/ModbusDevice;", "calculateFetchGroupToAddressesMapping", "", "", "", "Lnl/basjes/modbus/device/api/Address;", "update", "", "Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch;", "field", "Lnl/basjes/modbus/schema/Field;", "getRegisters", "Lnl/basjes/modbus/device/api/RegisterBlock;", "fetchBatch", "maxAge", "", "fetch", "calculateFetchBatches", "FetchBatch", "MergedFetchBatch", "Companion", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nRegisterBlockFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisterBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,317:1\n1#2:318\n1869#3,2:319\n1761#3,3:321\n1869#3,2:324\n1761#3,3:326\n1563#3:329\n1634#3,3:330\n1563#3:333\n1634#3,3:334\n774#3:337\n865#3,2:338\n774#3:340\n865#3,2:341\n1869#3,2:343\n1869#3,2:345\n1563#3:347\n1634#3,3:348\n295#3,2:351\n*S KotlinDebug\n*F\n+ 1 RegisterBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher\n*L\n100#1:319,2\n116#1:321,3\n119#1:324,2\n227#1:326,3\n239#1:329\n239#1:330,3\n245#1:333\n245#1:334,3\n247#1:337\n247#1:338,2\n248#1:340\n248#1:341,2\n249#1:343,2\n253#1:345,2\n286#1:347\n286#1:348,3\n287#1:351,2\n*E\n"})
public class RegisterBlockFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaDevice schemaDevice;
    @NotNull
    private final ModbusDevice modbusDevice;
    @NotNull
    private static final Logger LOG;

    public RegisterBlockFetcher(@NotNull SchemaDevice schemaDevice, @NotNull ModbusDevice modbusDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        this.schemaDevice = schemaDevice;
        this.modbusDevice = modbusDevice;
    }

    @NotNull
    protected final SchemaDevice getSchemaDevice() {
        return this.schemaDevice;
    }

    @NotNull
    protected final ModbusDevice getModbusDevice() {
        return this.modbusDevice;
    }

    private final Map<String, List<Address>> calculateFetchGroupToAddressesMapping() {
        Map fetchGroupToAddresses = new TreeMap();
        for (Block entry : this.schemaDevice.getBlocks()) {
            for (Field field : entry.getFields()) {
                String fieldFetchGroup = field.getFetchGroup();
                boolean fieldImmutable = field.isImmutable();
                List<Address> requiredRegisters = field.getRequiredRegisters();
                for (Address requiredRegister : requiredRegisters) {
                    RegisterValue registerValue = this.schemaDevice.getRegisterBlock(requiredRegister.getAddressClass()).computeIfAbsent(requiredRegister, RegisterBlockFetcher::calculateFetchGroupToAddressesMapping$lambda$0);
                    registerValue.setImmutable(fieldImmutable);
                    registerValue.setFetchGroup(fieldFetchGroup);
                }
                fetchGroupToAddresses.computeIfAbsent(fieldFetchGroup, arg_0 -> RegisterBlockFetcher.calculateFetchGroupToAddressesMapping$lambda$2(RegisterBlockFetcher::calculateFetchGroupToAddressesMapping$lambda$1, arg_0)).addAll((Collection)requiredRegisters);
            }
        }
        for (Map.Entry entry : fetchGroupToAddresses.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            List fetchGroupAddresses = CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)value)));
            if (fetchGroupAddresses.isEmpty()) continue;
            Address firstAddress = (Address)fetchGroupAddresses.get(0);
            int numberOfAddresses = fetchGroupAddresses.size();
            Address lastAddress = (Address)fetchGroupAddresses.get(numberOfAddresses - 1);
            if (Intrinsics.areEqual((Object)firstAddress.increment(numberOfAddresses - 1), (Object)lastAddress)) continue;
            boolean bl = false;
            String string = "There are gaps in the addresses for fetch group \"" + key + "\": " + fetchGroupAddresses;
            throw new IllegalStateException(string.toString());
        }
        return fetchGroupToAddresses;
    }

    @NotNull
    public final List<FetchBatch> update(@NotNull Field field) {
        RegisterValue it;
        boolean bl;
        RegisterBlock deviceRegisters;
        FetchBatch fetchBatch;
        List fetched;
        block10: {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            if (!field.getInitialized()) {
                boolean $i$a$-require-RegisterBlockFetcher$update$22 = false;
                String $i$a$-require-RegisterBlockFetcher$update$22 = "You cannot fetch the registers for a Field if the field has not yet been initialized. (Field ID=" + field.getId() + ")";
                throw new IllegalArgumentException($i$a$-require-RegisterBlockFetcher$update$22.toString());
            }
            if (field.isUsingHardReadErrorRegisters()) {
                return CollectionsKt.emptyList();
            }
            fetched = new ArrayList();
            Iterable $this$forEach$iv = field.getRequiredFields();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Field it2 = (Field)element$iv;
                boolean bl2 = false;
                fetched.addAll((Collection)it2.update());
            }
            Map<String, List<Address>> fetchGroupToAddresses = this.calculateFetchGroupToAddressesMapping();
            List<Address> requiredRegisters = fetchGroupToAddresses.get(field.getFetchGroup());
            Collection collection = requiredRegisters;
            if (collection == null || collection.isEmpty()) {
                requiredRegisters = field.getRequiredRegisters();
            }
            if (requiredRegisters.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            fetchBatch = new FetchBatch(requiredRegisters.get(0), requiredRegisters.size());
            fetchBatch.getFields().add(field);
            deviceRegisters = this.getRegisters(this.modbusDevice, fetchBatch);
            Iterable $this$any$iv = deviceRegisters.getValues();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (RegisterValue)element$iv;
                    boolean bl3 = false;
                    if (!it.isReadError()) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            fetchBatch.setStatus(FetchBatch.FetchStatus.ERROR);
            Iterable $this$forEach$iv = deviceRegisters.getValues();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (RegisterValue)element$iv;
                boolean bl4 = false;
                it.setHardReadError();
            }
        }
        this.schemaDevice.getRegisterBlock(deviceRegisters.getAddressClass()).merge(deviceRegisters);
        fetched.add(fetchBatch);
        return fetched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RegisterBlock getRegisters(@NotNull ModbusDevice $this$getRegisters, @NotNull FetchBatch fetchBatch) {
        Intrinsics.checkNotNullParameter((Object)$this$getRegisters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fetchBatch, (String)"fetchBatch");
        long start = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        try {
            RegisterBlock registerBlock = $this$getRegisters.getRegisters(fetchBatch.getStart(), fetchBatch.getCount());
            fetchBatch.setStatus(FetchBatch.FetchStatus.SUCCESS);
            RegisterBlock registerBlock2 = registerBlock;
            return registerBlock2;
        }
        catch (ModbusException modbusException) {
            fetchBatch.setStatus(FetchBatch.FetchStatus.ERROR);
            throw modbusException;
        }
        finally {
            long stop = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            fetchBatch.setDuration-BwNAW2A(Duration.box-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)stop, (long)start)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final List<FetchBatch> update(long maxAge) {
        RegisterBlockFetcher registerBlockFetcher = this;
        synchronized (registerBlockFetcher) {
            boolean bl = false;
            List fetched = new ArrayList();
            for (FetchBatch fetchBatch : this.calculateFetchBatches(maxAge)) {
                fetched.addAll((Collection)this.fetch(fetchBatch));
            }
            List list = fetched;
            return list;
        }
    }

    public static /* synthetic */ List update$default(RegisterBlockFetcher registerBlockFetcher, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return registerBlockFetcher.update(l);
    }

    /*
     * WARNING - void declaration
     */
    private final List<FetchBatch> fetch(FetchBatch fetchBatch) {
        List fetched = new ArrayList();
        try {
            RegisterValue it;
            Object element$iv3;
            boolean bl;
            RegisterBlock registerBlock;
            RegisterBlock registers;
            block14: {
                registers = this.getRegisters(this.modbusDevice, fetchBatch);
                fetched.add(fetchBatch);
                registerBlock = this.schemaDevice.getRegisterBlock(registers.getAddressClass());
                registerBlock.merge(registers);
                Iterable $this$any$iv = registers.getValues();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv3 = iterator.next();
                        it = (RegisterValue)element$iv3;
                        boolean bl2 = false;
                        if (!it.isReadError()) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                fetchBatch.setStatus(FetchBatch.FetchStatus.ERROR);
                if (fetchBatch instanceof MergedFetchBatch) {
                    void $this$forEach$iv;
                    Object element$iv$iv;
                    Iterable $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Object it2;
                    Collection collection;
                    Iterable $this$mapTo$iv$iv;
                    for (FetchBatch fetchPart : ((MergedFetchBatch)fetchBatch).getFetchBatches()) {
                        fetched.addAll((Collection)this.fetch(fetchPart));
                    }
                    Iterable $this$map$iv = fetchBatch.getFields();
                    boolean $i$f$map = false;
                    element$iv3 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Field field = (Field)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(((Field)it2).getBlock());
                    }
                    List blocks = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                    $this$map$iv = blocks;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it2 = (Block)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(((Block)it2).getFields());
                    }
                    $this$map$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                    boolean $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    Iterator iterator = $this$filterTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = iterator.next();
                        it2 = (Field)element$iv$iv;
                        boolean bl5 = false;
                        if (!(!fetchBatch.getFields().contains(it2))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    iterator = $this$filterTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = iterator.next();
                        it2 = (Field)element$iv$iv;
                        boolean bl6 = false;
                        if (!OptimizingRegisterBlockFetcherKt.overlaps(((Field)it2).getRequiredRegisters(), fetchBatch.getStart(), fetchBatch.getCount())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        Field it3 = (Field)element$iv2;
                        boolean bl7 = false;
                        fetched.addAll((Collection)it3.update());
                    }
                    return fetched;
                }
                Iterable $this$forEach$iv = registers.getValues();
                boolean $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    it = (RegisterValue)element$iv3;
                    boolean bl8 = false;
                    it.setHardReadError();
                }
                registerBlock.merge(registers);
            }
        }
        catch (ModbusException me) {
            LOG.error("Got ModbusException on {} --> {}", (Object)fetchBatch, (Object)me);
        }
        return CollectionsKt.listOf((Object)fetchBatch);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<FetchBatch> calculateFetchBatches(long maxAge) {
        long now = System.currentTimeMillis();
        List fieldsThatMustBeUpdated = new ArrayList();
        for (Field field : this.schemaDevice.neededFields()) {
            Object v0;
            block6: {
                void $this$firstOrNull$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                if (!field.getInitialized()) {
                    boolean $i$a$-require-RegisterBlockFetcher$calculateFetchBatches$22 = false;
                    String $i$a$-require-RegisterBlockFetcher$calculateFetchBatches$22 = "You cannot fetch the registers for a Field if the field has not yet been initialized. (Field ID=" + field.getId() + ")";
                    throw new IllegalArgumentException($i$a$-require-RegisterBlockFetcher$calculateFetchBatches$22.toString());
                }
                List<Address> requiredRegisters = field.getRequiredRegisters();
                if (requiredRegisters.isEmpty()) continue;
                RegisterBlock registerBlock = this.schemaDevice.getRegisterBlock(requiredRegisters.get(0).getAddressClass());
                Iterable iterable = requiredRegisters;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Address address = (Address)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(registerBlock.get((Address)it));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RegisterValue it = (RegisterValue)element$iv;
                    boolean bl = false;
                    if (!it.needsToBeUpdated(now, maxAge)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            if (v0 == null) continue;
            fieldsThatMustBeUpdated.add(field);
        }
        Map<String, List<Address>> fetchGroupToAddresses = this.calculateFetchGroupToAddressesMapping();
        Map fetchBatchesMap = new TreeMap();
        for (Field field : fieldsThatMustBeUpdated) {
            List<Address> addresses;
            FetchBatch fetchBatch = (FetchBatch)fetchBatchesMap.get(field.getFetchGroup());
            if (fetchBatch != null) {
                fetchBatch.getFields().add(field);
                continue;
            }
            Intrinsics.checkNotNull(fetchGroupToAddresses.get(field.getFetchGroup()));
            fetchBatch = new FetchBatch(addresses.get(0), addresses.size());
            fetchBatch.getFields().add(field);
            fetchBatchesMap.put(field.getFetchGroup(), fetchBatch);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)fetchBatchesMap.values()));
    }

    @JvmOverloads
    @NotNull
    public final List<FetchBatch> update() {
        return RegisterBlockFetcher.update$default(this, 0L, 1, null);
    }

    private static final RegisterValue calculateFetchGroupToAddressesMapping$lambda$0(Address it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RegisterValue(it);
    }

    private static final List calculateFetchGroupToAddressesMapping$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List calculateFetchGroupToAddressesMapping$lambda$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$Companion;", "", "<init>", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "modbus-schema-device"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0000H\u0096\u0002J\u0013\u0010!\u001a\u00020\"2\b\u0010 \u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020&H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006("}, d2={"Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch;", "", "start", "Lnl/basjes/modbus/device/api/Address;", "count", "", "<init>", "(Lnl/basjes/modbus/device/api/Address;I)V", "getStart", "()Lnl/basjes/modbus/device/api/Address;", "getCount", "()I", "setCount", "(I)V", "duration", "Lkotlin/time/Duration;", "getDuration-FghU774", "()Lkotlin/time/Duration;", "setDuration-BwNAW2A", "(Lkotlin/time/Duration;)V", "status", "Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch$FetchStatus;", "getStatus", "()Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch$FetchStatus;", "setStatus", "(Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch$FetchStatus;)V", "fields", "", "Lnl/basjes/modbus/schema/Field;", "getFields", "()Ljava/util/List;", "compareTo", "other", "equals", "", "", "hashCode", "toString", "", "FetchStatus", "modbus-schema-device"})
    public static class FetchBatch
    implements Comparable<FetchBatch> {
        @NotNull
        private final Address start;
        private int count;
        @Nullable
        private Duration duration;
        @NotNull
        private FetchStatus status;
        @NotNull
        private final List<Field> fields;

        public FetchBatch(@NotNull Address start, int count) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            this.start = start;
            this.count = count;
            this.status = FetchStatus.NOT_FETCHED;
            this.fields = new ArrayList();
        }

        @NotNull
        public final Address getStart() {
            return this.start;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        @Nullable
        public final Duration getDuration-FghU774() {
            return this.duration;
        }

        public final void setDuration-BwNAW2A(@Nullable Duration duration) {
            this.duration = duration;
        }

        @NotNull
        public final FetchStatus getStatus() {
            return this.status;
        }

        public final void setStatus(@NotNull FetchStatus fetchStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)fetchStatus), (String)"<set-?>");
            this.status = fetchStatus;
        }

        @NotNull
        public final List<Field> getFields() {
            return this.fields;
        }

        @Override
        public int compareTo(@NotNull FetchBatch other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int addressCompare = this.start.compareTo(other.start);
            if (addressCompare != 0) {
                return addressCompare;
            }
            return Intrinsics.compare((int)this.count, (int)other.count);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FetchBatch)) {
                return false;
            }
            return this.count == ((FetchBatch)other).count && Intrinsics.areEqual((Object)this.start, (Object)((FetchBatch)other).start);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.start, this.count};
            return Objects.hash(objectArray);
        }

        @NotNull
        public String toString() {
            return "FetchBatch { " + this.start + " # " + this.count + " } (Fields: " + CollectionsKt.joinToString$default((Iterable)this.fields, (CharSequence)", ", null, null, (int)0, null, FetchBatch::toString$lambda$0, (int)30, null) + ")";
        }

        private static final CharSequence toString$lambda$0(Field it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getBlock().getId() + "[" + it.getId() + "]";
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch$FetchStatus;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_FETCHED", "ERROR", "SUCCESS", "modbus-schema-device"})
        public static final class FetchStatus
        extends Enum<FetchStatus> {
            public static final /* enum */ FetchStatus NOT_FETCHED = new FetchStatus();
            public static final /* enum */ FetchStatus ERROR = new FetchStatus();
            public static final /* enum */ FetchStatus SUCCESS = new FetchStatus();
            private static final /* synthetic */ FetchStatus[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static FetchStatus[] values() {
                return (FetchStatus[])$VALUES.clone();
            }

            public static FetchStatus valueOf(String value) {
                return Enum.valueOf(FetchStatus.class, value);
            }

            @NotNull
            public static EnumEntries<FetchStatus> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = fetchStatusArray = new FetchStatus[]{FetchStatus.NOT_FETCHED, FetchStatus.ERROR, FetchStatus.SUCCESS};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$MergedFetchBatch;", "Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch;", "start", "Lnl/basjes/modbus/device/api/Address;", "count", "", "<init>", "(Lnl/basjes/modbus/device/api/Address;I)V", "fetchBatches", "", "getFetchBatches", "()Ljava/util/List;", "add", "", "fetchBatch", "modbus-schema-device"})
    public static final class MergedFetchBatch
    extends FetchBatch {
        @NotNull
        private final List<FetchBatch> fetchBatches;

        public MergedFetchBatch(@NotNull Address start, int count) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            super(start, count);
            this.fetchBatches = new ArrayList();
        }

        @NotNull
        public final List<FetchBatch> getFetchBatches() {
            return this.fetchBatches;
        }

        public final void add(@NotNull FetchBatch fetchBatch) {
            Intrinsics.checkNotNullParameter((Object)fetchBatch, (String)"fetchBatch");
            this.fetchBatches.add(fetchBatch);
            this.getFields().addAll((Collection<Field>)fetchBatch.getFields());
        }
    }
}

