/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnl/basjes/modbus/schema/utils/CodeGeneration;", "", "<init>", "()V", "DROP_LEADING_TRAILING", "", "", "convertToCodeCompliantName", "", "name", "firstUppercase", "", "modbus-schema-device"})
public final class CodeGeneration {
    @NotNull
    public static final CodeGeneration INSTANCE = new CodeGeneration();
    @NotNull
    private static final List<Integer> DROP_LEADING_TRAILING;

    private CodeGeneration() {
    }

    @JvmStatic
    @NotNull
    public static final String convertToCodeCompliantName(@NotNull String name, boolean firstUppercase) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StringBuilder finalName = new StringBuilder(name.length());
        boolean sawSeparator = false;
        boolean first = true;
        for (int codepoint : name.chars().toArray()) {
            StringBuilder stringBuilder;
            if (first) {
                if (!Character.isUnicodeIdentifierStart(codepoint) || Character.getType(codepoint) == 26 || DROP_LEADING_TRAILING.contains(codepoint)) continue;
                first = false;
                StringBuilder stringBuilder2 = firstUppercase ? finalName.append(Character.toString(Character.toUpperCase(codepoint))) : finalName.append(Character.toString(Character.toLowerCase(codepoint)));
                continue;
            }
            if (!Character.isUnicodeIdentifierPart(codepoint) || Character.getType(codepoint) == 26) {
                sawSeparator = true;
                continue;
            }
            if (sawSeparator) {
                sawSeparator = false;
                stringBuilder = finalName.append(Character.toString(Character.toUpperCase(codepoint)));
                continue;
            }
            stringBuilder = finalName.append(Character.toString(codepoint));
        }
        String string = finalName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String result = string;
        if (((CharSequence)result).length() == 0) {
            return result;
        }
        while (DROP_LEADING_TRAILING.contains(result.codePointAt(result.length() - 1))) {
            Intrinsics.checkNotNullExpressionValue((Object)result.substring(0, result.length() - 1), (String)"substring(...)");
        }
        return result;
    }

    static {
        Object[] objectArray = new Integer[]{95, 45};
        DROP_LEADING_TRAILING = CollectionsKt.listOf((Object[])objectArray);
    }
}

