/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.generate;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.schema.generate.BaseSingleStringMethod;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lnl/basjes/modbus/schema/generate/EscapeStringForJava;", "Lnl/basjes/modbus/schema/generate/BaseSingleStringMethod;", "<init>", "()V", "transform", "", "input", "modbus-schema-maven-plugin"})
public final class EscapeStringForJava
extends BaseSingleStringMethod {
    @Override
    @NotNull
    public String transform(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StringBuilder sb = new StringBuilder();
        int n = input.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    StringBuilder stringBuilder = sb.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    StringBuilder stringBuilder = sb.append("\\\"");
                    continue block9;
                }
                case '\n': {
                    StringBuilder stringBuilder = sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    StringBuilder stringBuilder = sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    StringBuilder stringBuilder = sb.append("\\t");
                    continue block9;
                }
                case '\b': {
                    StringBuilder stringBuilder = sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    StringBuilder stringBuilder = sb.append("\\f");
                    continue block9;
                }
                default: {
                    StringBuilder stringBuilder;
                    if (Intrinsics.compare((int)c, (int)32) < 0 || Intrinsics.compare((int)c, (int)126) > 0) {
                        String string = "\\u%04x";
                        Object[] objectArray = new Object[]{(int)c};
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        stringBuilder = sb.append(string2);
                        continue block9;
                    }
                    stringBuilder = sb.append(c);
                }
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

