/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.generate;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.TimeZone;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.YamlLoaderKt;
import nl.basjes.modbus.schema.exceptions.ModbusSchemaParseException;
import nl.basjes.modbus.schema.generate.FreeMarkerMethodsKt;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\nJP\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nJ \u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nJ0\u0010\u0018\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nJB\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lnl/basjes/modbus/schema/generate/Generator;", "", "log", "Lorg/apache/maven/plugin/logging/Log;", "<init>", "(Lorg/apache/maven/plugin/logging/Log;)V", "getLog", "()Lorg/apache/maven/plugin/logging/Log;", "openAsStream", "Ljava/io/InputStream;", "", "execute", "", "basedir", "Ljava/io/File;", "outputDirectory", "modbusSchemaFile", "templateDirectory", "packageName", "className", "language", "type", "getTemplateConfiguration", "Lfreemarker/template/Configuration;", "fileName", "generate", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "output", "Ljava/io/Writer;", "buildFullFileName", "directory", "modbus-schema-maven-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Generator.kt\nnl/basjes/modbus/schema/generate/Generator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,206:1\n1#2:207\n106#3:208\n78#3,29:209\n*S KotlinDebug\n*F\n+ 1 Generator.kt\nnl/basjes/modbus/schema/generate/Generator\n*L\n203#1:208\n203#1:209,29\n*E\n"})
public final class Generator {
    @NotNull
    private final Log log;

    public Generator(@NotNull Log log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
    }

    @NotNull
    public final Log getLog() {
        return this.log;
    }

    @Nullable
    public final InputStream openAsStream(@NotNull String $this$openAsStream) {
        Intrinsics.checkNotNullParameter((Object)$this$openAsStream, (String)"<this>");
        this.log.debug((CharSequence)("Trying to open: " + $this$openAsStream));
        InputStream resourceStream = Thread.currentThread().getContextClassLoader().getResourceAsStream($this$openAsStream);
        if (resourceStream != null) {
            this.log.debug((CharSequence)"- open as resource: success");
            return resourceStream;
        }
        this.log.debug((CharSequence)"- open as resource: failed");
        try {
            FileInputStream fileInputStream = new FileInputStream($this$openAsStream);
            this.log.debug((CharSequence)"- open as file: success");
            return fileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log.debug((CharSequence)"- open as file: not found");
            return null;
        }
    }

    public final void execute(@NotNull File basedir, @Nullable File outputDirectory, @Nullable String modbusSchemaFile, @Nullable File templateDirectory, @Nullable String packageName, @Nullable String className, @NotNull String language, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)basedir, (String)"basedir");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!(outputDirectory != null)) {
            boolean bl = false;
            throw new MojoExecutionException("outputDirectory is mandatory");
        }
        if (!(modbusSchemaFile != null)) {
            boolean bl = false;
            throw new MojoExecutionException("No modbusSchemaFile was specified");
        }
        this.log.info((CharSequence)("Using Modbus Schema file " + modbusSchemaFile));
        InputStream schemaStream = this.openAsStream(modbusSchemaFile);
        if (schemaStream == null) {
            schemaStream = this.openAsStream(basedir.getAbsolutePath() + "/" + modbusSchemaFile);
        }
        if (schemaStream == null) {
            boolean bl = false;
            throw new MojoExecutionException("Could not open the specified modbusSchemaFile " + modbusSchemaFile);
        }
        SchemaDevice schemaDevice = YamlLoaderKt.toSchemaDevice((InputStream)schemaStream);
        if (schemaDevice == null) {
            boolean bl = false;
            throw new MojoExecutionException("Could not open the specified modbusSchemaFile does not exist " + modbusSchemaFile);
        }
        CharSequence bl = packageName;
        if (!(!(bl == null || StringsKt.isBlank((CharSequence)bl)))) {
            boolean bl2 = false;
            throw new MojoExecutionException("packageName is mandatory");
        }
        bl = className;
        if (!(!(bl == null || StringsKt.isBlank((CharSequence)bl)))) {
            boolean bl3 = false;
            throw new MojoExecutionException("className is mandatory");
        }
        String bl3 = "[a-zA-Z][a-zA-Z0-9.]+";
        bl = packageName;
        if (!new Regex(bl3).matches(bl)) {
            boolean bl4 = false;
            throw new MojoExecutionException("Invalid packageName was provided.");
        }
        String bl4 = "[a-zA-Z][a-zA-Z0-9]+";
        bl = className;
        if (!new Regex(bl4).matches(bl)) {
            boolean bl5 = false;
            throw new MojoExecutionException("Invalid className was provided.");
        }
        String bl5 = "[a-zA-Z0-9]+";
        bl = language;
        if (!new Regex(bl5).matches(bl)) {
            boolean bl6 = false;
            throw new MojoExecutionException("Invalid programming language name was provided.");
        }
        if (!(Intrinsics.areEqual((Object)type, (Object)"main") || Intrinsics.areEqual((Object)type, (Object)"test"))) {
            boolean bl7 = false;
            throw new MojoExecutionException("Invalid type was provided.");
        }
        CharSequence bl7 = outputDirectory.getAbsolutePath() + File.separator + language;
        Regex regex = new Regex(Pattern.quote(File.separator) + "+");
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String string2 = string;
        String languageSpecificOutputDirectoryPath = regex.replace(bl7, string2);
        File languageSpecificOutputDirectory = new File(languageSpecificOutputDirectoryPath);
        if (!languageSpecificOutputDirectory.exists() && !languageSpecificOutputDirectory.mkdirs()) {
            throw new MojoExecutionException("Cannot create directory " + languageSpecificOutputDirectory);
        }
        String outputFileName = this.buildFullFileName(languageSpecificOutputDirectoryPath, this.fileName(templateDirectory, language, type, packageName, className));
        try {
            File outputFile = new File(outputFileName);
            outputFile.getParentFile().mkdirs();
            if (outputFile.exists() && outputFile.isFile()) {
                outputFile.delete();
            }
            if (!outputFile.createNewFile()) {
                boolean bl8 = false;
                throw new MojoExecutionException("Unable to create file " + outputFile);
            }
            FileOutputStream fileOutput = new FileOutputStream(outputFile);
            OutputStreamWriter output = new OutputStreamWriter(fileOutput);
            this.generate(schemaDevice, templateDirectory, language, type, packageName, className, output);
            this.log.info((CharSequence)("Generated (" + language + " ; " + type + "): " + outputFileName));
        }
        catch (ModbusSchemaParseException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    @NotNull
    public final Configuration getTemplateConfiguration(@Nullable File templateDirectory, @NotNull String language, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_34);
        if (templateDirectory == null) {
            cfg.setClassForTemplateLoading(Generator.class, "/" + language + "/" + type);
        } else {
            cfg.setDirectoryForTemplateLoading(new File(templateDirectory.getAbsolutePath() + "/" + type));
        }
        FreeMarkerMethodsKt.registerAdditionalMethods(cfg);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        cfg.setSQLDateAndTimeTimeZone(TimeZone.getDefault());
        return cfg;
    }

    @NotNull
    public final String fileName(@Nullable File templateDirectory, @NotNull String language, @NotNull String type, @NotNull String packageName, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Configuration templateConfig = this.getTemplateConfiguration(templateDirectory, language, type);
        Template template = templateConfig.getTemplate("filename.ftl");
        Intrinsics.checkNotNullExpressionValue((Object)template, (String)"getTemplate(...)");
        Template template2 = template;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"packageName", (Object)packageName), TuplesKt.to((Object)"className", (Object)className)};
        template2.process((Object)MapsKt.mapOf((Pair[])pairArray), (Writer)new OutputStreamWriter(output));
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\r\n", (String)"", (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null);
    }

    public final void generate(@Nullable SchemaDevice schemaDevice, @Nullable File templateDirectory, @NotNull String language, @NotNull String type, @NotNull String packageName, @NotNull String className, @NotNull Writer output) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Configuration templateConfig = this.getTemplateConfiguration(templateDirectory, language, type);
        Template template = templateConfig.getTemplate("code.ftl");
        Intrinsics.checkNotNullExpressionValue((Object)template, (String)"getTemplate(...)");
        Template template2 = template;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"pluginVersion", (Object)"0.14.0"), TuplesKt.to((Object)"packageName", (Object)packageName), TuplesKt.to((Object)"className", (Object)className), TuplesKt.to((Object)"schemaDevice", (Object)schemaDevice)};
        template2.process((Object)MapsKt.mapOf((Pair[])pairArray), output);
    }

    @NotNull
    public final String buildFullFileName(@NotNull String directory, @NotNull String fileName) {
        boolean match$iv$iv;
        char it;
        int index$iv$iv;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String $this$trim$iv = directory;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        $this$trim$iv = fileName;
        String string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        $i$f$trim = false;
        $this$trim$iv$iv = $this$trim$iv;
        $i$f$trim2 = false;
        startIndex$iv$iv = 0;
        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        CharSequence charSequence = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        Regex regex = new Regex("/+");
        String string2 = "/";
        return string + "/" + regex.replace(charSequence, string2);
    }
}

