/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.generate;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.TimeZone;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.YamlLoaderKt;
import nl.basjes.modbus.schema.exceptions.ModbusSchemaParseException;
import nl.basjes.modbus.schema.generate.FreeMarkerMethodsKt;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lnl/basjes/modbus/schema/generate/Generator;", "", "<init>", "()V", "Companion", "modbus-schema-maven-plugin"})
public final class Generator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JP\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ \u0010\u0011\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ0\u0010\u0013\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJB\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r\u00a8\u0006\u001b"}, d2={"Lnl/basjes/modbus/schema/generate/Generator$Companion;", "", "<init>", "()V", "execute", "", "log", "Lorg/apache/maven/plugin/logging/Log;", "outputDirectory", "Ljava/io/File;", "modbusSchemaFile", "templateDirectory", "packageName", "", "className", "language", "type", "getTemplateConfiguration", "Lfreemarker/template/Configuration;", "fileName", "generate", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "output", "Ljava/io/Writer;", "buildFullFileName", "directory", "modbus-schema-maven-plugin"})
    @SourceDebugExtension(value={"SMAP\nGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Generator.kt\nnl/basjes/modbus/schema/generate/Generator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,175:1\n1#2:176\n108#3:177\n80#3,29:178\n*S KotlinDebug\n*F\n+ 1 Generator.kt\nnl/basjes/modbus/schema/generate/Generator$Companion\n*L\n172#1:177\n172#1:178,29\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void execute(@NotNull Log log, @Nullable File outputDirectory, @Nullable File modbusSchemaFile, @Nullable File templateDirectory, @Nullable String packageName, @Nullable String className, @NotNull String language, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            if (!(outputDirectory != null)) {
                boolean bl = false;
                throw new MojoExecutionException("outputDirectory is mandatory");
            }
            if (!(modbusSchemaFile != null && modbusSchemaFile.exists() && modbusSchemaFile.isFile())) {
                boolean bl = false;
                throw new MojoExecutionException("modbusSchemaFile must be an existing file");
            }
            CharSequence charSequence = packageName;
            if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) {
                boolean bl = false;
                throw new MojoExecutionException("packageName is mandatory");
            }
            charSequence = className;
            if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) {
                boolean bl = false;
                throw new MojoExecutionException("className is mandatory");
            }
            charSequence = packageName;
            if (!new Regex("[a-zA-Z][a-zA-Z0-9.]+").matches(charSequence)) {
                boolean bl = false;
                throw new MojoExecutionException("Invalid packageName was provided.");
            }
            charSequence = className;
            if (!new Regex("[a-zA-Z][a-zA-Z0-9]+").matches(charSequence)) {
                boolean bl = false;
                throw new MojoExecutionException("Invalid className was provided.");
            }
            charSequence = language;
            if (!new Regex("[a-zA-Z0-9]+").matches(charSequence)) {
                boolean bl = false;
                throw new MojoExecutionException("Invalid programming language name was provided.");
            }
            if (!(Intrinsics.areEqual((Object)type, (Object)"main") || Intrinsics.areEqual((Object)type, (Object)"test"))) {
                boolean bl = false;
                throw new MojoExecutionException("Invalid type was provided.");
            }
            CharSequence bl = outputDirectory.getAbsolutePath() + File.separator + language;
            Regex regex = new Regex(Pattern.quote(File.separator) + "+");
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
            String string2 = string;
            String languageSpecificOutputDirectoryPath = regex.replace(bl, string2);
            File languageSpecificOutputDirectory = new File(languageSpecificOutputDirectoryPath);
            if (!languageSpecificOutputDirectory.exists() && !languageSpecificOutputDirectory.mkdirs()) {
                throw new MojoExecutionException("Cannot create directory " + languageSpecificOutputDirectory);
            }
            if (!modbusSchemaFile.exists()) {
                throw new MojoExecutionException("The specified Schema file does not exist " + modbusSchemaFile);
            }
            String outputFileName = this.buildFullFileName(languageSpecificOutputDirectoryPath, this.fileName(templateDirectory, language, type, packageName, className));
            try {
                File outputFile = new File(outputFileName);
                outputFile.getParentFile().mkdirs();
                if (outputFile.exists() && outputFile.isFile()) {
                    outputFile.delete();
                }
                if (!outputFile.createNewFile()) {
                    boolean bl2 = false;
                    throw new MojoExecutionException("Unable to create file " + outputFile);
                }
                FileOutputStream fileOutput = new FileOutputStream(outputFile);
                OutputStreamWriter output = new OutputStreamWriter(fileOutput);
                this.generate(YamlLoaderKt.toSchemaDevice((File)modbusSchemaFile), templateDirectory, language, type, packageName, className, output);
                log.info((CharSequence)("Generated (" + language + " ; " + type + "): " + outputFileName));
            }
            catch (ModbusSchemaParseException e) {
                throw new MojoExecutionException(e.getMessage());
            }
            catch (IOException e) {
                throw new MojoExecutionException((Throwable)e);
            }
        }

        @NotNull
        public final Configuration getTemplateConfiguration(@Nullable File templateDirectory, @NotNull String language, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_34);
            if (templateDirectory == null) {
                cfg.setClassForTemplateLoading(Generator.class, "/" + language + "/" + type);
            } else {
                cfg.setDirectoryForTemplateLoading(new File(templateDirectory.getAbsolutePath() + "/" + type));
            }
            FreeMarkerMethodsKt.registerAdditionalMethods(cfg);
            cfg.setDefaultEncoding("UTF-8");
            cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            cfg.setLogTemplateExceptions(false);
            cfg.setWrapUncheckedExceptions(true);
            cfg.setFallbackOnNullLoopVariable(false);
            cfg.setSQLDateAndTimeTimeZone(TimeZone.getDefault());
            return cfg;
        }

        @NotNull
        public final String fileName(@Nullable File templateDirectory, @NotNull String language, @NotNull String type, @NotNull String packageName, @NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Configuration templateConfig = this.getTemplateConfiguration(templateDirectory, language, type);
            Template template = templateConfig.getTemplate("filename.ftl");
            Intrinsics.checkNotNullExpressionValue((Object)template, (String)"getTemplate(...)");
            Template template2 = template;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"packageName", (Object)packageName), TuplesKt.to((Object)"className", (Object)className)};
            template2.process((Object)MapsKt.mapOf((Pair[])pairArray), (Writer)new OutputStreamWriter(output));
            String string = output.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\r\n", (String)"", (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null);
        }

        public final void generate(@Nullable SchemaDevice schemaDevice, @Nullable File templateDirectory, @NotNull String language, @NotNull String type, @NotNull String packageName, @NotNull String className, @NotNull Writer output) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Configuration templateConfig = this.getTemplateConfiguration(templateDirectory, language, type);
            Template template = templateConfig.getTemplate("code.ftl");
            Intrinsics.checkNotNullExpressionValue((Object)template, (String)"getTemplate(...)");
            Template template2 = template;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"pluginVersion", (Object)"0.6.0"), TuplesKt.to((Object)"packageName", (Object)packageName), TuplesKt.to((Object)"className", (Object)className), TuplesKt.to((Object)"schemaDevice", (Object)schemaDevice)};
            template2.process((Object)MapsKt.mapOf((Pair[])pairArray), output);
        }

        @NotNull
        public final String buildFullFileName(@NotNull String directory, @NotNull String fileName) {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            String $this$trim$iv = directory;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            $this$trim$iv = fileName;
            String string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            $i$f$trim = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim2 = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            CharSequence charSequence = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Regex regex = new Regex("/+");
            String string2 = "/";
            return string + "/" + regex.replace(charSequence, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

