/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.lang.reflect.Constructor;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.exceptions.DisectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDisectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Disector {
    private static final Logger LOG = LoggerFactory.getLogger(Disector.class);

    public abstract void disect(Parsable<?> var1, String var2) throws DisectionFailure;

    public abstract String getInputType();

    public abstract List<String> getPossibleOutput();

    public abstract EnumSet<Casts> prepareForDisect(String var1, String var2);

    public abstract void prepareForRun() throws InvalidDisectorException;

    public Disector getNewInstance() {
        try {
            Constructor<?> co = this.getClass().getConstructor(new Class[0]);
            Disector newInstance = (Disector)co.newInstance(new Object[0]);
            this.initializeNewInstance(newInstance);
            return newInstance;
        }
        catch (Exception e) {
            LOG.error("Unable to create instance of " + this.getClass().getCanonicalName() + ": " + e.toString());
            return null;
        }
    }

    protected abstract void initializeNewInstance(Disector var1);
}

