/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Disector;
import nl.basjes.parse.core.Field;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.CannotChangeDisectorsAfterConstructionException;
import nl.basjes.parse.core.exceptions.DisectionFailure;
import nl.basjes.parse.core.exceptions.FatalErrorDuringCallOfSetterMethod;
import nl.basjes.parse.core.exceptions.InvalidDisectorException;
import nl.basjes.parse.core.exceptions.InvalidFieldMethodSignature;
import nl.basjes.parse.core.exceptions.MissingDisectorsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser<RECORD> {
    private static final Logger LOG = LoggerFactory.getLogger(Parser.class);
    private final Class<RECORD> recordClass;
    private final Set<DisectorPhase> availableDisectors = new HashSet<DisectorPhase>();
    private final Set<Disector> allDisectors = new HashSet<Disector>();
    private Map<String, Set<DisectorPhase>> compiledDisectors = null;
    private Set<String> usefulIntermediateFields = null;
    private String rootType;
    private String rootName;
    private final Map<String, Set<Method>> targets = new TreeMap<String, Set<Method>>();
    private final Map<String, EnumSet<Casts>> castsOfTargets = new TreeMap<String, EnumSet<Casts>>();
    private final Set<String> locatedTargets = new HashSet<String>();
    private boolean usable = false;

    public Set<String> getNeeded() {
        return this.targets.keySet();
    }

    public EnumSet<Casts> getCasts(String name) {
        try {
            this.assembleDisectors();
        }
        catch (InvalidDisectorException | MissingDisectorsException e) {
            e.printStackTrace();
        }
        return this.castsOfTargets.get(name);
    }

    public Map<String, EnumSet<Casts>> getAllCasts() {
        try {
            this.assembleDisectors();
        }
        catch (InvalidDisectorException | MissingDisectorsException e) {
            e.printStackTrace();
        }
        return this.castsOfTargets;
    }

    Set<String> getUsefulIntermediateFields() {
        return this.usefulIntermediateFields;
    }

    public final void addDisector(Disector disector) {
        if (this.compiledDisectors != null) {
            throw new CannotChangeDisectorsAfterConstructionException();
        }
        String inputType = disector.getInputType();
        List<String> outputs = disector.getPossibleOutput();
        if (outputs == null || outputs.size() == 0) {
            return;
        }
        for (String output : outputs) {
            int colonPos = output.indexOf(58);
            String outputType = output.substring(0, colonPos);
            String name = output.substring(colonPos + 1);
            this.availableDisectors.add(new DisectorPhase(inputType, outputType, name, disector));
        }
        this.allDisectors.add(disector);
    }

    public final void dropDisector(Class<? extends Disector> disectorClassToDrop) {
        if (this.compiledDisectors != null) {
            throw new CannotChangeDisectorsAfterConstructionException();
        }
        HashSet<DisectorPhase> removePhase = new HashSet<DisectorPhase>();
        for (DisectorPhase disectorPhase : this.availableDisectors) {
            if (!disectorPhase.instance.getClass().equals(disectorClassToDrop)) continue;
            removePhase.add(disectorPhase);
        }
        this.availableDisectors.removeAll(removePhase);
        HashSet<Disector> removeDisector = new HashSet<Disector>();
        for (Disector disector : this.allDisectors) {
            if (!disector.getClass().equals(disectorClassToDrop)) continue;
            removeDisector.add(disector);
        }
        this.allDisectors.removeAll(removeDisector);
    }

    protected void setRootType(String newRootType) {
        this.compiledDisectors = null;
        this.rootType = newRootType;
        this.rootName = "rootinputline";
    }

    private void assembleDisectors() throws MissingDisectorsException, InvalidDisectorException {
        if (this.compiledDisectors != null) {
            return;
        }
        HashSet<String> needed = new HashSet<String>(this.getNeeded());
        needed.add(this.rootType + ':' + this.rootName);
        LOG.debug("Root: >>>{}:{}<<<", (Object)this.rootType, (Object)this.rootName);
        HashSet<String> allPossibleSubtargets = new HashSet<String>();
        for (String string : needed) {
            String neededName = string.substring(string.indexOf(58) + 1);
            LOG.debug("Needed  : >>>{}<<<", (Object)neededName);
            String[] needs = neededName.split("\\.");
            StringBuilder sb = new StringBuilder(string.length());
            for (String part : needs) {
                if (sb.length() == 0) {
                    sb.append(part);
                } else {
                    sb.append('.').append(part);
                }
                allPossibleSubtargets.add(sb.toString());
                LOG.debug("Possible: >>>{}<<<", (Object)sb.toString());
            }
        }
        this.compiledDisectors = new HashMap<String, Set<DisectorPhase>>();
        this.usefulIntermediateFields = new HashSet<String>();
        this.findUsefulDisectorsFromField(allPossibleSubtargets, this.rootType, this.rootName, true);
        for (Set set : this.compiledDisectors.values()) {
            for (DisectorPhase disectorPhase : set) {
                disectorPhase.instance.prepareForRun();
            }
        }
        Set<String> missingDisectors = this.getTheMissingFields();
        if (missingDisectors != null && !missingDisectors.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(missingDisectors.size() * 64);
            for (String missing : missingDisectors) {
                stringBuilder.append(missing).append(' ');
            }
            throw new MissingDisectorsException(stringBuilder.toString());
        }
        this.usable = true;
    }

    private void findUsefulDisectorsFromField(Set<String> possibleTargets, String subRootType, String subRootName, boolean thisIsTheRoot) {
        String subRootId = subRootType + ':' + subRootName;
        LOG.debug("findUsefulDisectors:\"" + subRootType + "\" \"" + subRootName + "\"");
        this.locatedTargets.add(subRootId);
        for (DisectorPhase disector : this.availableDisectors) {
            if (!disector.inputType.equals(subRootType)) continue;
            HashSet<String> checkFields = new HashSet<String>();
            boolean isWildCardDisector = disector.name.equals("*");
            if (isWildCardDisector) {
                String subRootNameMatch = subRootName + '.';
                for (String possibleTarget : possibleTargets) {
                    if (!possibleTarget.startsWith(subRootNameMatch)) continue;
                    checkFields.add(possibleTarget);
                }
            } else if (thisIsTheRoot) {
                checkFields.add(disector.name);
            } else {
                checkFields.add(subRootName + '.' + disector.name);
            }
            for (String checkField : checkFields) {
                Class<?> clazz;
                DisectorPhase disectorPhaseInstance;
                if (!possibleTargets.contains(checkField) || this.compiledDisectors.containsKey(disector.outputType + ":" + checkField)) continue;
                Set<DisectorPhase> subRootPhases = this.compiledDisectors.get(subRootId);
                if (subRootPhases == null) {
                    subRootPhases = new HashSet<DisectorPhase>();
                    this.compiledDisectors.put(subRootId, subRootPhases);
                    this.usefulIntermediateFields.add(subRootName);
                }
                if ((disectorPhaseInstance = this.findDisectorInstance(subRootPhases, clazz = disector.instance.getClass())) == null) {
                    disectorPhaseInstance = new DisectorPhase(disector.inputType, disector.outputType, checkField, disector.instance.getNewInstance());
                    subRootPhases.add(disectorPhaseInstance);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Informing : (" + disector.inputType + ")" + subRootName + " --> " + disector.instance.getClass().getName() + " --> (" + disector.outputType + ")" + checkField);
                }
                this.castsOfTargets.put(disector.outputType + ':' + checkField, disectorPhaseInstance.instance.prepareForDisect(subRootName, checkField));
                this.findUsefulDisectorsFromField(possibleTargets, disector.outputType, checkField, false);
            }
        }
    }

    private DisectorPhase findDisectorInstance(Set<DisectorPhase> disectorPhases, Class<? extends Disector> clazz) {
        for (DisectorPhase phase : disectorPhases) {
            if (phase.instance.getClass() != clazz) continue;
            return phase;
        }
        return null;
    }

    private Set<String> getTheMissingFields() {
        HashSet<String> missing = new HashSet<String>();
        for (String target : this.getNeeded()) {
            if (this.locatedTargets.contains(target)) continue;
            if (target.endsWith("*")) {
                if (!target.endsWith(".*") || this.locatedTargets.contains(target.substring(0, target.length() - 2))) continue;
                missing.add(target);
                continue;
            }
            missing.add(target);
        }
        return missing;
    }

    public Parser(Class<RECORD> clazz) {
        this.recordClass = clazz;
        for (Method method : this.recordClass.getMethods()) {
            Field field = method.getAnnotation(Field.class);
            if (field == null) continue;
            this.addParseTarget(method, Arrays.asList(field.value()));
        }
    }

    public void addParseTarget(Method method, List<String> fieldValues) {
        if (method == null || fieldValues == null) {
            return;
        }
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length == 1 && parameters[0] == String.class || parameters.length == 2 && parameters[0] == String.class && parameters[1] == String.class || parameters.length == 1 && parameters[0] == Long.class || parameters.length == 2 && parameters[0] == String.class && parameters[1] == Long.class || parameters.length == 1 && parameters[0] == Double.class || parameters.length == 2 && parameters[0] == String.class && parameters[1] == Double.class) {
            for (String fieldValue : fieldValues) {
                Set<Method> fieldTargets;
                String cleanedFieldValue;
                if (!fieldValue.equals(cleanedFieldValue = this.cleanupFieldValue(fieldValue))) {
                    LOG.warn("The requested \"" + fieldValue + "\" was converted into \"" + cleanedFieldValue + "\" ");
                }
                if ((fieldTargets = this.targets.get(cleanedFieldValue)) == null) {
                    fieldTargets = new HashSet<Method>();
                }
                fieldTargets.add(method);
                this.targets.put(cleanedFieldValue, fieldTargets);
            }
        } else {
            throw new InvalidFieldMethodSignature(method);
        }
        this.compiledDisectors = null;
    }

    private String cleanupFieldValue(String fieldValue) {
        int colonPos = fieldValue.indexOf(58);
        String fieldType = fieldValue.substring(0, colonPos);
        String fieldName = fieldValue.substring(colonPos + 1);
        return fieldType.toUpperCase(Locale.ENGLISH) + ':' + fieldName.toLowerCase(Locale.ENGLISH);
    }

    public RECORD parse(String value) throws DisectionFailure, InvalidDisectorException, MissingDisectorsException {
        this.assembleDisectors();
        Parsable<RECORD> parsable = this.createParsable();
        if (parsable == null) {
            return null;
        }
        parsable.setRootDisection(this.rootType, this.rootName, value);
        return this.parse(parsable).getRecord();
    }

    public RECORD parse(RECORD record, String value) throws DisectionFailure, InvalidDisectorException, MissingDisectorsException {
        this.assembleDisectors();
        Parsable<RECORD> parsable = this.createParsable(record);
        parsable.setRootDisection(this.rootType, this.rootName, value);
        return this.parse(parsable).getRecord();
    }

    Parsable<RECORD> parse(Parsable<RECORD> parsable) throws DisectionFailure, InvalidDisectorException, MissingDisectorsException {
        this.assembleDisectors();
        if (!this.usable) {
            return null;
        }
        HashSet<ParsedField> toBeParsed = new HashSet<ParsedField>(parsable.getToBeParsed());
        while (toBeParsed.size() > 0) {
            for (ParsedField fieldThatNeedsToBeParsed : toBeParsed) {
                parsable.setAsParsed(fieldThatNeedsToBeParsed);
                Set<DisectorPhase> disectorSet = this.compiledDisectors.get(fieldThatNeedsToBeParsed.getId());
                if (disectorSet != null) {
                    for (DisectorPhase disector : disectorSet) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Disect " + fieldThatNeedsToBeParsed + " with " + disector.instance.getClass().getName());
                        }
                        disector.instance.disect(parsable, fieldThatNeedsToBeParsed.getName());
                    }
                    continue;
                }
                LOG.trace("NO DISECTORS FOR \"{}\"", (Object)fieldThatNeedsToBeParsed);
            }
            toBeParsed.clear();
            toBeParsed.addAll(parsable.getToBeParsed());
        }
        return parsable;
    }

    RECORD store(RECORD record, String key, String name, String value) {
        Set<Method> methods = this.targets.get(key);
        EnumSet<Casts> castsTo = this.castsOfTargets.get(key);
        boolean calledASetter = true;
        if (methods == null) {
            LOG.error("NO methods for \"" + key + "\"");
        } else {
            for (Method method : methods) {
                if (method == null) continue;
                try {
                    Class<?>[] parameters = method.getParameterTypes();
                    Class<?> valueClass = parameters[parameters.length - 1];
                    if (valueClass == String.class) {
                        if (!castsTo.contains((Object)Casts.STRING)) continue;
                        if (parameters.length == 2) {
                            method.invoke(record, name, value);
                            continue;
                        }
                        method.invoke(record, value);
                        continue;
                    }
                    if (valueClass == Long.class) {
                        Long longValue;
                        if (!castsTo.contains((Object)Casts.LONG)) continue;
                        try {
                            longValue = value == null ? null : Long.valueOf(Long.parseLong(value));
                        }
                        catch (NumberFormatException e) {
                            longValue = null;
                        }
                        if (parameters.length == 2) {
                            method.invoke(record, name, longValue);
                            continue;
                        }
                        method.invoke(record, longValue);
                        continue;
                    }
                    if (valueClass == Double.class) {
                        Double doubleValue;
                        if (!castsTo.contains((Object)Casts.DOUBLE)) continue;
                        try {
                            doubleValue = value == null ? null : Double.valueOf(Double.parseDouble(value));
                        }
                        catch (NumberFormatException e) {
                            doubleValue = null;
                        }
                        if (parameters.length == 2) {
                            method.invoke(record, name, doubleValue);
                            continue;
                        }
                        method.invoke(record, doubleValue);
                        continue;
                    }
                    calledASetter = false;
                }
                catch (Exception e) {
                    throw new FatalErrorDuringCallOfSetterMethod(e.getMessage() + " caused by \"" + e.getCause() + "\" when calling \"" + method.toGenericString() + "\" for " + " key = \"" + key + "\" " + " name = \"" + name + "\" " + " value = \"" + value + "\"" + " castsTo = \"" + castsTo + "\"");
                }
            }
        }
        if (!calledASetter) {
            throw new FatalErrorDuringCallOfSetterMethod("No setter called for  key = \"" + key + "\" " + " name = \"" + name + "\" " + " value = \"" + value + "\"");
        }
        return record;
    }

    private Parsable<RECORD> createParsable(RECORD record) {
        return new Parsable<RECORD>(this, record);
    }

    public Parsable<RECORD> createParsable() {
        RECORD record;
        try {
            Constructor<RECORD> co = this.recordClass.getConstructor(new Class[0]);
            record = co.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Unable to create instance: " + e.toString());
            return null;
        }
        return this.createParsable(record);
    }

    public List<String> getPossiblePaths() throws MissingDisectorsException, InvalidDisectorException {
        return this.getPossiblePaths(15);
    }

    public List<String> getPossiblePaths(int maxDepth) throws MissingDisectorsException, InvalidDisectorException {
        if (this.allDisectors.isEmpty()) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        HashMap<String, List<String>> pathNodes = new HashMap<String, List<String>>();
        for (Disector disector : this.allDisectors) {
            String inputType = disector.getInputType();
            List<String> outputs = disector.getPossibleOutput();
            pathNodes.put(inputType, outputs);
        }
        this.findAdditionalPossiblePaths(pathNodes, paths, "", this.rootType, maxDepth);
        return paths;
    }

    private void findAdditionalPossiblePaths(Map<String, List<String>> pathNodes, List<String> paths, String base, String baseType, int maxDepth) {
        if (maxDepth == 0) {
            return;
        }
        if (pathNodes.containsKey(baseType)) {
            List<String> childPaths = pathNodes.get(baseType);
            for (String childPath : childPaths) {
                int colonPos = childPath.indexOf(58);
                String childType = childPath.substring(0, colonPos);
                String childName = childPath.substring(colonPos + 1);
                String childBase = base.isEmpty() ? childName : base + '.' + childName;
                paths.add(childType + ':' + childBase);
                this.findAdditionalPossiblePaths(pathNodes, paths, childBase, childType, maxDepth - 1);
            }
        }
    }

    private static class DisectorPhase {
        private final String inputType;
        private final String outputType;
        private final String name;
        private final Disector instance;

        public DisectorPhase(String inputType, String outputType, String name, Disector instance) {
            this.inputType = inputType;
            this.outputType = outputType;
            this.name = name;
            this.instance = instance;
        }
    }
}

