/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Field;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.CannotChangeDissectorsAfterConstructionException;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.FatalErrorDuringCallOfSetterMethod;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.InvalidFieldMethodSignature;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser<RECORD> {
    private static final Logger LOG = LoggerFactory.getLogger(Parser.class);
    private final Class<RECORD> recordClass;
    private final Set<DissectorPhase> availableDissectors = new HashSet<DissectorPhase>();
    private final Set<Dissector> allDissectors = new HashSet<Dissector>();
    private Map<String, Set<DissectorPhase>> compiledDissectors = null;
    private Set<String> usefulIntermediateFields = null;
    private String rootType;
    private String rootName;
    private final Map<String, Set<Method>> targets = new TreeMap<String, Set<Method>>();
    private final Map<String, EnumSet<Casts>> castsOfTargets = new TreeMap<String, EnumSet<Casts>>();
    private final Set<String> locatedTargets = new HashSet<String>();
    private boolean usable = false;
    private Map<String, Set<String>> typeRemappings = new HashMap<String, Set<String>>(16);

    public Set<String> getNeeded() {
        return this.targets.keySet();
    }

    public EnumSet<Casts> getCasts(String name) {
        try {
            this.assembleDissectors();
        }
        catch (InvalidDissectorException | MissingDissectorsException e) {
            e.printStackTrace();
        }
        return this.castsOfTargets.get(name);
    }

    public Map<String, EnumSet<Casts>> getAllCasts() {
        try {
            this.assembleDissectors();
        }
        catch (InvalidDissectorException | MissingDissectorsException e) {
            e.printStackTrace();
        }
        return this.castsOfTargets;
    }

    Set<String> getUsefulIntermediateFields() {
        return this.usefulIntermediateFields;
    }

    public final void addDissectors(List<Dissector> dissectors) {
        if (this.compiledDissectors != null) {
            throw new CannotChangeDissectorsAfterConstructionException();
        }
        if (dissectors != null) {
            for (Dissector dissector : dissectors) {
                this.allDissectors.add(dissector);
            }
        }
    }

    public final void addDissector(Dissector dissector) {
        if (this.compiledDissectors != null) {
            throw new CannotChangeDissectorsAfterConstructionException();
        }
        if (dissector != null) {
            this.allDissectors.add(dissector);
        }
    }

    public final void dropDissector(Class<? extends Dissector> dissectorClassToDrop) {
        if (this.compiledDissectors != null) {
            throw new CannotChangeDissectorsAfterConstructionException();
        }
        HashSet<Dissector> removeDissector = new HashSet<Dissector>();
        for (Dissector dissector : this.allDissectors) {
            if (!dissector.getClass().equals(dissectorClassToDrop)) continue;
            removeDissector.add(dissector);
        }
        this.allDissectors.removeAll(removeDissector);
    }

    protected void setRootType(String newRootType) {
        this.compiledDissectors = null;
        this.rootType = newRootType;
        this.rootName = "rootinputline";
    }

    private void assembleDissectorPhases() throws InvalidDissectorException {
        if (this.compiledDissectors != null) {
            return;
        }
        for (Dissector dissector : this.allDissectors) {
            String inputType = dissector.getInputType();
            if (inputType == null) {
                throw new InvalidDissectorException("Dissector returns null on getInputType(): [" + dissector.getClass().getCanonicalName() + "]");
            }
            List<String> outputs = dissector.getPossibleOutput();
            if (outputs == null || outputs.size() == 0) {
                throw new InvalidDissectorException("Dissector cannot create any outputs: [" + dissector.getClass().getCanonicalName() + "]");
            }
            for (String output : outputs) {
                int colonPos = output.indexOf(58);
                String outputType = output.substring(0, colonPos);
                String name = output.substring(colonPos + 1);
                this.availableDissectors.add(new DissectorPhase(inputType, outputType, name, dissector));
            }
        }
    }

    private void assembleDissectors() throws MissingDissectorsException, InvalidDissectorException {
        if (this.compiledDissectors != null) {
            return;
        }
        this.assembleDissectorPhases();
        HashSet<String> needed = new HashSet<String>(this.getNeeded());
        needed.add(this.rootType + ':' + this.rootName);
        LOG.debug("Root: >>>{}:{}<<<", (Object)this.rootType, (Object)this.rootName);
        HashSet<String> allPossibleSubtargets = new HashSet<String>();
        for (String string : needed) {
            String neededName = string.substring(string.indexOf(58) + 1);
            LOG.debug("Needed  : >>>{}<<<", (Object)neededName);
            String[] needs = neededName.split("\\.");
            StringBuilder sb = new StringBuilder(string.length());
            for (String part : needs) {
                if (sb.length() == 0) {
                    sb.append(part);
                } else {
                    sb.append('.').append(part);
                }
                allPossibleSubtargets.add(sb.toString());
                LOG.debug("Possible: >>>{}<<<", (Object)sb.toString());
            }
        }
        this.compiledDissectors = new HashMap<String, Set<DissectorPhase>>();
        this.usefulIntermediateFields = new HashSet<String>();
        this.findUsefulDissectorsFromField(allPossibleSubtargets, this.rootType, this.rootName, true);
        for (Set set : this.compiledDissectors.values()) {
            for (DissectorPhase dissectorPhase : set) {
                dissectorPhase.instance.prepareForRun();
            }
        }
        Set<String> missingDissectors = this.getTheMissingFields();
        if (missingDissectors != null && !missingDissectors.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(missingDissectors.size() * 64);
            for (String missing : missingDissectors) {
                stringBuilder.append(missing).append(' ');
            }
            throw new MissingDissectorsException(stringBuilder.toString());
        }
        this.usable = true;
    }

    private void findUsefulDissectorsFromField(Set<String> possibleTargets, String subRootType, String subRootName, boolean thisIsTheRoot) {
        String subRootId = subRootType + ':' + subRootName;
        LOG.debug("findUsefulDissectors:\"" + subRootType + "\" \"" + subRootName + "\"");
        this.locatedTargets.add(subRootId);
        for (DissectorPhase dissector : this.availableDissectors) {
            if (!dissector.inputType.equals(subRootType)) continue;
            HashSet<String> checkFields = new HashSet<String>();
            boolean isWildCardDissector = dissector.name.equals("*");
            if (isWildCardDissector) {
                String subRootNameMatch = subRootName + '.';
                for (String possibleTarget : possibleTargets) {
                    if (!possibleTarget.startsWith(subRootNameMatch)) continue;
                    checkFields.add(possibleTarget);
                }
            } else if (thisIsTheRoot) {
                checkFields.add(dissector.name);
            } else {
                checkFields.add(subRootName + '.' + dissector.name);
            }
            for (String checkField : checkFields) {
                Class<?> clazz;
                DissectorPhase dissectorPhaseInstance;
                if (!possibleTargets.contains(checkField) || this.compiledDissectors.containsKey(dissector.outputType + ":" + checkField)) continue;
                Set<DissectorPhase> subRootPhases = this.compiledDissectors.get(subRootId);
                if (subRootPhases == null) {
                    subRootPhases = new HashSet<DissectorPhase>();
                    this.compiledDissectors.put(subRootId, subRootPhases);
                    this.usefulIntermediateFields.add(subRootName);
                }
                if ((dissectorPhaseInstance = this.findDissectorInstance(subRootPhases, clazz = dissector.instance.getClass())) == null) {
                    dissectorPhaseInstance = new DissectorPhase(dissector.inputType, dissector.outputType, checkField, dissector.instance.getNewInstance());
                    subRootPhases.add(dissectorPhaseInstance);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Informing : (" + dissector.inputType + ")" + subRootName + " --> " + dissector.instance.getClass().getName() + " --> (" + dissector.outputType + ")" + checkField);
                }
                this.castsOfTargets.put(dissector.outputType + ':' + checkField, dissectorPhaseInstance.instance.prepareForDissect(subRootName, checkField));
                this.findUsefulDissectorsFromField(possibleTargets, dissector.outputType, checkField, false);
            }
        }
        Set<String> mappings = this.typeRemappings.get(subRootName);
        if (mappings != null) {
            for (String mappedType : mappings) {
                if (this.compiledDissectors.containsKey(mappedType + ':' + subRootName)) continue;
                this.castsOfTargets.put(mappedType + ':' + subRootName, Casts.STRING_ONLY);
                this.findUsefulDissectorsFromField(possibleTargets, mappedType, subRootName, false);
            }
        }
    }

    private DissectorPhase findDissectorInstance(Set<DissectorPhase> dissectorPhases, Class<? extends Dissector> clazz) {
        for (DissectorPhase phase : dissectorPhases) {
            if (phase.instance.getClass() != clazz) continue;
            return phase;
        }
        return null;
    }

    private Set<String> getTheMissingFields() {
        HashSet<String> missing = new HashSet<String>();
        for (String target : this.getNeeded()) {
            if (this.locatedTargets.contains(target)) continue;
            if (target.endsWith("*")) {
                if (!target.endsWith(".*") || this.locatedTargets.contains(target.substring(0, target.length() - 2))) continue;
                missing.add(target);
                continue;
            }
            missing.add(target);
        }
        return missing;
    }

    public Parser(Class<RECORD> clazz) {
        this.recordClass = clazz;
        for (Method method : this.recordClass.getMethods()) {
            Field field = method.getAnnotation(Field.class);
            if (field == null) continue;
            this.addParseTarget(method, Arrays.asList(field.value()));
        }
    }

    public void addParseTarget(Method method, List<String> fieldValues) {
        if (method == null || fieldValues == null) {
            return;
        }
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length == 1 && parameters[0] == String.class || parameters.length == 2 && parameters[0] == String.class && parameters[1] == String.class || parameters.length == 1 && parameters[0] == Long.class || parameters.length == 2 && parameters[0] == String.class && parameters[1] == Long.class || parameters.length == 1 && parameters[0] == Double.class || parameters.length == 2 && parameters[0] == String.class && parameters[1] == Double.class) {
            for (String fieldValue : fieldValues) {
                Set<Method> fieldTargets;
                String cleanedFieldValue;
                if (!fieldValue.equals(cleanedFieldValue = Parser.cleanupFieldValue(fieldValue))) {
                    LOG.warn("The requested \"" + fieldValue + "\" was converted into \"" + cleanedFieldValue + "\" ");
                }
                if ((fieldTargets = this.targets.get(cleanedFieldValue)) == null) {
                    fieldTargets = new HashSet<Method>();
                }
                fieldTargets.add(method);
                this.targets.put(cleanedFieldValue, fieldTargets);
            }
        } else {
            throw new InvalidFieldMethodSignature(method);
        }
        this.compiledDissectors = null;
    }

    public void setTypeRemappings(Map<String, Set<String>> typeRemappings) {
        if (typeRemappings == null) {
            this.typeRemappings.clear();
        } else {
            this.typeRemappings = typeRemappings;
        }
    }

    public void addTypeRemappings(Map<String, Set<String>> additionalTypeRemappings) {
        for (Map.Entry<String, Set<String>> entry : additionalTypeRemappings.entrySet()) {
            String input = entry.getKey();
            for (String newType : entry.getValue()) {
                this.addTypeRemapping(input, newType, Casts.STRING_ONLY);
            }
        }
    }

    public void addTypeRemapping(String input, String newType) {
        this.addTypeRemapping(input, newType, Casts.STRING_ONLY);
    }

    public void addTypeRemapping(String input, String newType, EnumSet<Casts> newCasts) {
        if (this.compiledDissectors != null) {
            throw new CannotChangeDissectorsAfterConstructionException();
        }
        String theInput = input.trim().toLowerCase(Locale.ENGLISH);
        String theType = newType.trim().toUpperCase(Locale.ENGLISH);
        Set<String> mappingsForInput = this.typeRemappings.get(theInput);
        if (mappingsForInput == null) {
            mappingsForInput = new HashSet<String>();
            this.typeRemappings.put(theInput, mappingsForInput);
        }
        if (!mappingsForInput.contains(theType)) {
            mappingsForInput.add(theType);
            this.castsOfTargets.put(theType + ':' + theInput, newCasts);
        }
    }

    public static String cleanupFieldValue(String fieldValue) {
        int colonPos = fieldValue.indexOf(58);
        if (colonPos == -1) {
            return fieldValue.toLowerCase(Locale.ENGLISH);
        }
        String fieldType = fieldValue.substring(0, colonPos);
        String fieldName = fieldValue.substring(colonPos + 1);
        return fieldType.toUpperCase(Locale.ENGLISH) + ':' + fieldName.toLowerCase(Locale.ENGLISH);
    }

    public RECORD parse(String value) throws DissectionFailure, InvalidDissectorException, MissingDissectorsException {
        this.assembleDissectors();
        Parsable<RECORD> parsable = this.createParsable();
        if (parsable == null) {
            return null;
        }
        parsable.setRootDissection(this.rootType, this.rootName, value);
        return this.parse(parsable).getRecord();
    }

    public RECORD parse(RECORD record, String value) throws DissectionFailure, InvalidDissectorException, MissingDissectorsException {
        this.assembleDissectors();
        Parsable<RECORD> parsable = this.createParsable(record);
        parsable.setRootDissection(this.rootType, this.rootName, value);
        return this.parse(parsable).getRecord();
    }

    Parsable<RECORD> parse(Parsable<RECORD> parsable) throws DissectionFailure, InvalidDissectorException, MissingDissectorsException {
        this.assembleDissectors();
        if (!this.usable) {
            return null;
        }
        HashSet<ParsedField> toBeParsed = new HashSet<ParsedField>(parsable.getToBeParsed());
        while (toBeParsed.size() > 0) {
            for (ParsedField fieldThatNeedsToBeParsed : toBeParsed) {
                parsable.setAsParsed(fieldThatNeedsToBeParsed);
                Set<DissectorPhase> dissectorSet = this.compiledDissectors.get(fieldThatNeedsToBeParsed.getId());
                if (dissectorSet != null) {
                    for (DissectorPhase dissector : dissectorSet) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Dissect " + fieldThatNeedsToBeParsed + " with " + dissector.instance.getClass().getName());
                        }
                        dissector.instance.dissect(parsable, fieldThatNeedsToBeParsed.getName());
                    }
                    continue;
                }
                LOG.trace("NO DISSECTORS FOR \"{}\"", (Object)fieldThatNeedsToBeParsed);
            }
            toBeParsed.clear();
            toBeParsed.addAll(parsable.getToBeParsed());
        }
        return parsable;
    }

    void store(RECORD record, String key, String name, String value) {
        boolean calledASetter = false;
        Set<Method> methods = this.targets.get(key);
        if (methods == null) {
            LOG.error("NO methods for \"" + key + "\"");
            return;
        }
        EnumSet<Casts> castsTo = this.castsOfTargets.get(key);
        if (castsTo == null && (castsTo = this.castsOfTargets.get(name)) == null) {
            LOG.error("NO casts for \"" + name + "\"");
            return;
        }
        for (Method method : methods) {
            if (method == null) continue;
            try {
                Class<?>[] parameters = method.getParameterTypes();
                Class<?> valueClass = parameters[parameters.length - 1];
                if (valueClass == String.class) {
                    if (!castsTo.contains((Object)Casts.STRING)) continue;
                    if (parameters.length == 2) {
                        method.invoke(record, name, value);
                    } else {
                        method.invoke(record, value);
                    }
                    calledASetter = true;
                    continue;
                }
                if (valueClass == Long.class) {
                    Long longValue;
                    if (!castsTo.contains((Object)Casts.LONG)) continue;
                    try {
                        longValue = value == null ? null : Long.valueOf(Long.parseLong(value));
                    }
                    catch (NumberFormatException e) {
                        longValue = null;
                    }
                    if (parameters.length == 2) {
                        method.invoke(record, name, longValue);
                    } else {
                        method.invoke(record, longValue);
                    }
                    calledASetter = true;
                    continue;
                }
                if (valueClass == Double.class) {
                    Double doubleValue;
                    if (!castsTo.contains((Object)Casts.DOUBLE)) continue;
                    try {
                        doubleValue = value == null ? null : Double.valueOf(Double.parseDouble(value));
                    }
                    catch (NumberFormatException e) {
                        doubleValue = null;
                    }
                    if (parameters.length == 2) {
                        method.invoke(record, name, doubleValue);
                    } else {
                        method.invoke(record, doubleValue);
                    }
                    calledASetter = true;
                    continue;
                }
                throw new FatalErrorDuringCallOfSetterMethod("Tried to call setter with unsupported class : key = \"" + key + "\" " + " name = \"" + name + "\" " + " value = \"" + value + "\"" + " castsTo = \"" + castsTo + "\"");
            }
            catch (Exception e) {
                throw new FatalErrorDuringCallOfSetterMethod(e.getMessage() + " caused by \"" + e.getCause() + "\" when calling \"" + method.toGenericString() + "\" for " + " key = \"" + key + "\" " + " name = \"" + name + "\" " + " value = \"" + value + "\"" + " castsTo = \"" + castsTo + "\"");
            }
        }
        if (!calledASetter) {
            throw new FatalErrorDuringCallOfSetterMethod("No setter called for  key = \"" + key + "\" " + " name = \"" + name + "\" " + " value = \"" + value + "\"");
        }
    }

    private Parsable<RECORD> createParsable(RECORD record) {
        return new Parsable<RECORD>(this, record, this.typeRemappings);
    }

    public Parsable<RECORD> createParsable() {
        RECORD record;
        try {
            Constructor<RECORD> co = this.recordClass.getConstructor(new Class[0]);
            record = co.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Unable to create instance: " + e.toString());
            return null;
        }
        return this.createParsable(record);
    }

    public List<String> getPossiblePaths() throws MissingDissectorsException, InvalidDissectorException {
        return this.getPossiblePaths(15);
    }

    public List<String> getPossiblePaths(int maxDepth) {
        if (this.allDissectors.isEmpty()) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        HashMap<String, List<String>> pathNodes = new HashMap<String, List<String>>();
        for (Dissector dissector : this.allDissectors) {
            String inputType = dissector.getInputType();
            if (inputType == null) {
                LOG.error("Dissector returns null on getInputType(): [" + dissector.getClass().getCanonicalName() + "]");
                return null;
            }
            List<String> outputs = dissector.getPossibleOutput();
            pathNodes.put(inputType, outputs);
        }
        this.findAdditionalPossiblePaths(pathNodes, paths, "", this.rootType, maxDepth);
        for (Map.Entry entry : this.typeRemappings.entrySet()) {
            for (String typeRemapping : (Set)entry.getValue()) {
                String remappedPath = typeRemapping + ':' + (String)entry.getKey();
                LOG.debug("Adding remapped path: {}", (Object)remappedPath);
                paths.add(remappedPath);
                this.findAdditionalPossiblePaths(pathNodes, paths, (String)entry.getKey(), typeRemapping, maxDepth - 1);
            }
        }
        return paths;
    }

    private void findAdditionalPossiblePaths(Map<String, List<String>> pathNodes, List<String> paths, String base, String baseType, int maxDepth) {
        if (maxDepth == 0) {
            return;
        }
        if (pathNodes.containsKey(baseType)) {
            List<String> childPaths = pathNodes.get(baseType);
            for (String childPath : childPaths) {
                int colonPos = childPath.indexOf(58);
                String childType = childPath.substring(0, colonPos);
                String childName = childPath.substring(colonPos + 1);
                String childBase = base.isEmpty() ? childName : base + '.' + childName;
                paths.add(childType + ':' + childBase);
                this.findAdditionalPossiblePaths(pathNodes, paths, childBase, childType, maxDepth - 1);
            }
        }
    }

    private static class DissectorPhase {
        private final String inputType;
        private final String outputType;
        private final String name;
        private final Dissector instance;

        public DissectorPhase(String inputType, String outputType, String name, Dissector instance) {
            this.inputType = inputType;
            this.outputType = outputType;
            this.name = name;
            this.instance = instance;
        }
    }
}

