/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Field;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.InvalidFieldMethodSignature;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import org.junit.Assert;
import org.junit.Test;

public class ParserExceptionsTest {
    @Test
    public void testParseString() throws Exception {
        TestParser<TestRecord> parser = new TestParser<TestRecord>(TestRecord.class);
        String[] params = new String[]{"OTHERTYPE:output2"};
        parser.addParseTarget(TestRecord.class.getMethod("setValue2", String.class, String.class), Arrays.asList(params));
        TestRecord output = new TestRecord();
        parser.parse(output, "Something");
        Assert.assertEquals((Object)"SOMETYPE1:SOMETYPE:output1:Something", (Object)output.output1);
        Assert.assertEquals((Object)"OTHERTYPE2:OTHERTYPE:output2:Something", (Object)output.output2);
        Assert.assertEquals((Object)"SOMETYPE3:SOMETYPE:output1:Something", (Object)output.output3a);
        Assert.assertEquals((Object)"OTHERTYPE3:OTHERTYPE:output2:Something", (Object)output.output3b);
        Assert.assertEquals((Object)"X=SOMETYPE:SOMETYPE:output1:Something", (Object)output.output4a);
        Assert.assertEquals((Object)"Y=OTHERTYPE:OTHERTYPE:output2:Something", (Object)output.output4b);
        Assert.assertEquals((Object)"X=SOMETYPE:SOMETYPE:output1:Something=SOMETYPE:SOMETYPE:output1:Something", (Object)output.output5a);
        Assert.assertEquals((Object)"Y=OTHERTYPE:OTHERTYPE:output2:Something=OTHERTYPE:OTHERTYPE:output2:Something", (Object)output.output5b);
        Assert.assertEquals((Object)"Z=FOO:FOO:output1.foo:Something", (Object)output.output6);
        Assert.assertEquals((Object)"Z=BAR:BAR:output1.bar:Something", (Object)output.output7);
    }

    @Test
    public void testGetPossiblePaths() throws Exception {
        TestParser<TestRecord> parser = new TestParser<TestRecord>(TestRecord.class);
        String[] params = new String[]{"OTHERTYPE:output2"};
        parser.addParseTarget(TestRecord.class.getMethod("setValue2", String.class, String.class), Arrays.asList(params));
        List paths = parser.getPossiblePaths(3);
        Assert.assertEquals((long)4L, (long)paths.size());
        Assert.assertTrue((boolean)paths.contains("SOMETYPE:output1"));
        Assert.assertTrue((boolean)paths.contains("FOO:output1.foo"));
        Assert.assertTrue((boolean)paths.contains("BAR:output1.bar"));
        Assert.assertTrue((boolean)paths.contains("OTHERTYPE:output2"));
    }

    @Test(expected=InvalidFieldMethodSignature.class)
    public void testBadSetter1() throws Exception {
        TestParser<TestRecord> parser = new TestParser<TestRecord>(TestRecord.class);
        String[] params = new String[]{"OTHERTYPE:output2"};
        parser.addParseTarget(TestRecord.class.getMethod("badSetter1", new Class[0]), Arrays.asList(params));
        parser.getPossiblePaths(3);
    }

    @Test(expected=InvalidFieldMethodSignature.class)
    public void testBadSetter2() throws Exception {
        TestParser<TestRecord> parser = new TestParser<TestRecord>(TestRecord.class);
        String[] params = new String[]{"OTHERTYPE:output2"};
        parser.addParseTarget(TestRecord.class.getMethod("badSetter2", String.class, Float.class), Arrays.asList(params));
        parser.getPossiblePaths(3);
    }

    @Test(expected=InvalidDissectorException.class)
    public void testBrokenDissector() throws Exception {
        TestParser<TestRecord> parser = new TestParser<TestRecord>(TestRecord.class);
        BrokenTestDissector dissector = new BrokenTestDissector();
        parser.setRootType(dissector.getInputType());
        parser.addParseTarget(TestRecord.class.getMethod("setValue8", String.class, String.class), "FOO:bar");
        parser.addDissector(dissector);
        parser.parse("Something");
    }

    @Test
    public void testChangeAfterStart() throws Exception {
        TestParser<TestRecord> parser = new TestParser<TestRecord>(TestRecord.class);
        parser.parse("Something");
        parser.addDissector(new BrokenTestDissector());
    }

    @Test(expected=MissingDissectorsException.class)
    public void testDropDissector1() throws Exception {
        TestParser<TestRecord> parser = new TestParser<TestRecord>(TestRecord.class);
        parser.dropDissector(TestDissectorOne.class);
        parser.parse("Something");
    }

    @Test
    public void testDropDissector2() throws Exception {
        TestParser<TestRecord> parser = new TestParser<TestRecord>(TestRecord.class);
        parser.dropDissector(TestDissectorOne.class);
        parser.addDissector(new TestDissectorOne());
        parser.getPossiblePaths();
    }

    @Test
    public void testDropDissector3() throws Exception {
        TestParser<TestRecord> parser = new TestParser<TestRecord>(TestRecord.class);
        parser.parse("Something");
        parser.dropDissector(TestDissectorOne.class);
    }

    public static class BrokenTestDissector
    extends Dissector {
        public boolean initializeFromSettingsParameter(String settings) {
            return true;
        }

        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        }

        public String getInputType() {
            return "FOO";
        }

        public List<String> getPossibleOutput() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("FOO:bar");
            return result;
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }

        public void prepareForRun() throws InvalidDissectorException {
            throw new InvalidDissectorException();
        }

        protected void initializeNewInstance(Dissector newInstance) {
        }
    }

    public static class TestRecord {
        private String output1 = "xxx";
        private String output2 = "yyy";
        private String output3a = "xxx";
        private String output3b = "yyy";
        private String output4a = "X";
        private String output4b = "Y";
        private String output5a = "X";
        private String output5b = "Y";
        private String output6 = "Z";
        private String output7 = "Z";
        private String output8 = "Z";

        @Field(value={"SOMETYPE:output1"})
        public void setValue1(String value) {
            this.output1 = "SOMETYPE1:SOMETYPE:output1:" + value;
        }

        public void setValue2(String name, String value) {
            this.output2 = "OTHERTYPE2:" + name + ":" + value;
        }

        @Field(value={"SOMETYPE:output1", "OTHERTYPE:output2"})
        public void setValue3(String name, String value) {
            if (name.startsWith("SOMETYPE:")) {
                this.output3a = "SOMETYPE3:" + name + ":" + value;
            } else {
                this.output3b = "OTHERTYPE3:" + name + ":" + value;
            }
        }

        @Field(value={"SOMETYPE:output1", "OTHERTYPE:output2", "SOMETYPE:output1", "OTHERTYPE:output2"})
        public void setValue4(String name, String value) {
            if (name.startsWith("SOMETYPE:")) {
                this.output4a = this.output4a + "=SOMETYPE:" + name + ":" + value;
            } else {
                this.output4b = this.output4b + "=OTHERTYPE:" + name + ":" + value;
            }
        }

        @Field(value={"SOMETYPE:output1", "OTHERTYPE:output2", "SOMETYPE:*", "OTHERTYPE:*"})
        public void setValue5(String name, String value) {
            if (name.startsWith("SOMETYPE:")) {
                this.output5a = this.output5a + "=SOMETYPE:" + name + ":" + value;
            } else {
                this.output5b = this.output5b + "=OTHERTYPE:" + name + ":" + value;
            }
        }

        @Field(value={"FOO:output1.foo"})
        public void setValue6(String name, String value) {
            this.output6 = this.output6 + "=FOO:" + name + ":" + value;
        }

        @Field(value={"BAR:output1.bar"})
        public void setValue7(String name, String value) {
            this.output7 = this.output7 + "=BAR:" + name + ":" + value;
        }

        public void setValue8(String name, String value) {
            this.output8 = this.output8 + "=" + name + ":" + value;
        }

        public void badSetter1() {
        }

        public void badSetter2(String name, Float value) {
        }
    }

    public static class TestParser<RECORD>
    extends Parser<RECORD> {
        public TestParser(Class<RECORD> clazz) {
            super(clazz);
            this.addDissector(new TestDissectorOne());
            this.addDissector(new TestDissectorTwo());
            ArrayList<TestDissector> dissectors = new ArrayList<TestDissector>();
            dissectors.add(new TestDissectorThree());
            dissectors.add(new TestDissectorFour());
            this.addDissectors(dissectors);
            this.setRootType("INPUTTYPE");
        }
    }

    public static class TestDissectorFour
    extends TestDissector {
        public TestDissectorFour() {
            super("SOMETYPE", "BAR", "bar");
        }
    }

    public static class TestDissectorThree
    extends TestDissector {
        public TestDissectorThree() {
            super("SOMETYPE", "FOO", "foo");
        }
    }

    public static class TestDissectorTwo
    extends TestDissector {
        public TestDissectorTwo() {
            super("INPUTTYPE", "OTHERTYPE", "output2");
        }
    }

    public static class TestDissectorOne
    extends TestDissector {
        public TestDissectorOne() {
            super("INPUTTYPE", "SOMETYPE", "output1");
        }
    }

    public static class TestDissector
    extends Dissector {
        private String inputType;
        private String outputType;
        private String outputName;

        public TestDissector(String inputType, String outputType, String outputName) {
            this.init(inputType, outputType, outputName);
        }

        public final void init(String inputtype, String outputtype, String outputname) {
            this.inputType = inputtype;
            this.outputType = outputtype;
            this.outputName = outputname;
        }

        public boolean initializeFromSettingsParameter(String settings) {
            return true;
        }

        protected void initializeNewInstance(Dissector newInstance) {
            ((TestDissector)newInstance).init(this.inputType, this.outputType, this.outputName);
        }

        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            ParsedField field = parsable.getParsableField(this.inputType, inputname);
            parsable.addDissection(inputname, this.outputType, this.outputName, field.getValue());
        }

        public String getInputType() {
            return this.inputType;
        }

        public List<String> getPossibleOutput() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.outputType + ":" + this.outputName);
            return result;
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }

        public void prepareForRun() {
        }
    }
}

