/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Field;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import org.junit.Test;

public class ParserInfiniteLoopTest {
    @Test
    public void testInfiniteRecursionAvoidance() throws Exception {
        TestParser<TestRecord> parser = new TestParser<TestRecord>(TestRecord.class);
        parser.addTypeRemapping("string", "INPUT_TYPE");
        TestRecord output = new TestRecord();
        parser.parse(output, "Something");
    }

    public static class TestRecord {
        @Field(value={"OUTPUT_TYPE:string"})
        public void set(String name, String value) {
        }
    }

    public static class TestParser<RECORD>
    extends Parser<RECORD> {
        public TestParser(Class<RECORD> clazz) {
            super(clazz);
            this.addDissector(new TestDissector());
            this.setRootType("INPUT_TYPE");
        }
    }

    public static class TestDissector
    extends Dissector {
        public boolean initializeFromSettingsParameter(String settings) {
            return true;
        }

        protected void initializeNewInstance(Dissector newInstance) {
        }

        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            parsable.addDissection(inputname, "OUTPUT_TYPE", "string", "123");
        }

        public String getInputType() {
            return "INPUT_TYPE";
        }

        public List<String> getPossibleOutput() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("OUTPUT_TYPE:string");
            return result;
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }

        public void prepareForRun() {
        }
    }
}

