/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import nl.basjes.parse.core.test.TestRecord;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DissectorTester {
    private static final Logger LOG = LoggerFactory.getLogger(DissectorTester.class);
    boolean verbose = false;
    private List<String> inputValues = new ArrayList<String>();
    private Map<String, String> expectedStrings = new TreeMap<String, String>();
    private Map<String, Long> expectedLongs = new TreeMap<String, Long>();
    private Map<String, Double> expectedDoubles = new TreeMap<String, Double>();
    private List<String> expectedValuePresent = new ArrayList<String>();
    private List<String> expectedAbsentStrings = new ArrayList<String>();
    private List<String> expectedAbsentLongs = new ArrayList<String>();
    private List<String> expectedAbsentDoubles = new ArrayList<String>();
    private List<String> expectedPossible = new ArrayList<String>();
    private Parser<TestRecord> parser = new Parser(TestRecord.class);

    private DissectorTester() {
    }

    public static DissectorTester create() {
        return new DissectorTester();
    }

    public DissectorTester withParser(Parser<TestRecord> parser) {
        this.parser = parser;
        return this;
    }

    public DissectorTester withDissector(String fieldName, Dissector dissector) {
        return this.withDissector(new DummyDissector(dissector.getInputType(), fieldName)).withDissector(dissector);
    }

    public DissectorTester withDissector(Dissector dissector) {
        this.parser.addDissector(dissector);
        if (this.parser.getAllDissectors().size() == 1) {
            this.parser.setRootType(dissector.getInputType());
        }
        return this;
    }

    public DissectorTester withInput(String inputValue) {
        this.inputValues.add(inputValue);
        return this;
    }

    public DissectorTester expect(String fieldname, String expected) {
        this.expectedStrings.put(fieldname, expected);
        try {
            this.parser.addParseTarget(TestRecord.class.getMethod("setStringValue", String.class, String.class), fieldname);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return this;
    }

    public DissectorTester expect(String fieldname, Long expected) {
        this.expectedLongs.put(fieldname, expected);
        try {
            this.parser.addParseTarget(TestRecord.class.getMethod("setLongValue", String.class, Long.class), fieldname);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return this;
    }

    public DissectorTester expect(String fieldname, Double expected) {
        this.expectedDoubles.put(fieldname, expected);
        try {
            this.parser.addParseTarget(TestRecord.class.getMethod("setDoubleValue", String.class, Double.class), fieldname);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return this;
    }

    public DissectorTester expectValuePresent(String fieldname) {
        this.expectedValuePresent.add(fieldname);
        try {
            this.parser.addParseTarget(TestRecord.class.getMethod("setStringValue", String.class, String.class), fieldname);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return this;
    }

    public DissectorTester expectAbsentString(String fieldname) {
        this.expectedAbsentStrings.add(fieldname);
        return this;
    }

    public DissectorTester expectAbsentLong(String fieldname) {
        this.expectedAbsentLongs.add(fieldname);
        return this;
    }

    public DissectorTester expectAbsentDouble(String fieldname) {
        this.expectedAbsentDoubles.add(fieldname);
        return this;
    }

    public DissectorTester expectPossible(String fieldname) {
        this.expectedPossible.add(fieldname);
        return this;
    }

    public DissectorTester verbose() {
        this.verbose = true;
        return this;
    }

    public DissectorTester checkExpectations() {
        if (this.expectedStrings.isEmpty() && this.expectedLongs.isEmpty() && this.expectedDoubles.isEmpty() && this.expectedValuePresent.isEmpty() && this.expectedAbsentStrings.isEmpty() && this.expectedAbsentLongs.isEmpty() && this.expectedAbsentDoubles.isEmpty() && this.expectedPossible.isEmpty()) {
            Assert.fail((String)"No expected values were specified");
        }
        this.checkDissectors();
        this.checkExpectedValues();
        this.checkExpectedAbsent();
        this.checkExpectedPossible();
        return this;
    }

    private void checkExpectedValues() {
        if (this.expectedStrings.size() + this.expectedLongs.size() + this.expectedDoubles.size() + this.expectedValuePresent.size() == 0) {
            return;
        }
        if (this.inputValues.isEmpty()) {
            Assert.fail((String)"No inputvalues were specified");
        }
        for (String inputValue : this.inputValues) {
            String fieldName;
            if (this.verbose) {
                LOG.info("Checking for input: {}", (Object)inputValue);
            }
            TestRecord result = this.parse(inputValue);
            if (this.verbose) {
                LOG.info("Parse completed successfully");
            }
            int longestFieldName = 0;
            HashSet<String> allFieldNames = new HashSet<String>();
            allFieldNames.addAll(this.expectedStrings.keySet());
            allFieldNames.addAll(this.expectedLongs.keySet());
            allFieldNames.addAll(this.expectedDoubles.keySet());
            allFieldNames.addAll(this.expectedValuePresent);
            for (String string : allFieldNames) {
                longestFieldName = Math.max(longestFieldName, string.length());
            }
            for (Map.Entry entry : this.expectedStrings.entrySet()) {
                fieldName = (String)entry.getKey();
                Assert.assertTrue((String)("The expected String value for '" + fieldName + "' was missing."), (boolean)result.hasStringValue(fieldName));
                Assert.assertEquals((String)("The expected String value for '" + fieldName + "' was wrong."), entry.getValue(), (Object)result.getStringValue(fieldName));
                if (!this.verbose) continue;
                LOG.info("Passed: String value for '{}'{} was correctly : {}", new Object[]{fieldName, this.padding(fieldName, longestFieldName), result.getStringValue(fieldName)});
            }
            for (Map.Entry entry : this.expectedLongs.entrySet()) {
                fieldName = (String)entry.getKey();
                Assert.assertTrue((String)("The expected Long value for '" + fieldName + "' was missing."), (boolean)result.hasLongValue(fieldName));
                Assert.assertEquals((String)("The expected Long value for '" + fieldName + "' was wrong."), entry.getValue(), (Object)result.getLongValue(fieldName));
                if (!this.verbose) continue;
                LOG.info("Passed: Long   value for '{}'{} was correctly : {}", new Object[]{fieldName, this.padding(fieldName, longestFieldName), result.getLongValue(fieldName)});
            }
            for (Map.Entry entry : this.expectedDoubles.entrySet()) {
                fieldName = (String)entry.getKey();
                Assert.assertTrue((String)("The expected Double value for '" + fieldName + "' was missing."), (boolean)result.hasDoubleValue(fieldName));
                Assert.assertEquals((String)("The expected Double value for '" + fieldName + "' was wrong."), entry.getValue(), (Object)result.getDoubleValue(fieldName));
                if (!this.verbose) continue;
                LOG.info("Passed: Double value for '{}'{} was correctly : {}", new Object[]{fieldName, this.padding(fieldName, longestFieldName), result.getDoubleValue(fieldName)});
            }
            for (String string : this.expectedValuePresent) {
                Assert.assertTrue((String)("The string value for '" + string + "' was missing."), (boolean)result.hasStringValue(string));
                if (!this.verbose) continue;
                LOG.info("Passed: A value for '{}'{} was present.", (Object)string, (Object)this.padding(string, longestFieldName));
            }
        }
    }

    private void checkExpectedAbsent() {
        if (this.expectedAbsentStrings.size() + this.expectedAbsentLongs.size() + this.expectedAbsentDoubles.size() == 0) {
            return;
        }
        if (this.inputValues.isEmpty()) {
            Assert.fail((String)"No inputvalues were specified");
        }
        for (String inputValue : this.inputValues) {
            if (this.verbose) {
                LOG.info("Checking for input: {}", (Object)inputValue);
            }
            TestRecord result = this.parse(inputValue);
            if (this.verbose) {
                LOG.info("Parse completed successfully");
            }
            int longestFieldName = 0;
            HashSet<String> allFieldNames = new HashSet<String>();
            allFieldNames.addAll(this.expectedAbsentStrings);
            allFieldNames.addAll(this.expectedAbsentLongs);
            allFieldNames.addAll(this.expectedAbsentDoubles);
            allFieldNames.addAll(this.expectedValuePresent);
            for (String key : allFieldNames) {
                longestFieldName = Math.max(longestFieldName, key.length());
            }
            for (String fieldName : this.expectedAbsentStrings) {
                Assert.assertFalse((String)("The String value for '" + fieldName + "' should have been absent. It was :." + result.getStringValue(fieldName)), (boolean)result.hasStringValue(fieldName));
                if (!this.verbose) continue;
                LOG.info("Passed: String value for '{}'{} was correctly absent", (Object)fieldName, (Object)this.padding(fieldName, longestFieldName));
            }
            for (String fieldName : this.expectedAbsentLongs) {
                Assert.assertFalse((String)("The Long value for '" + fieldName + "' should have been absent. It was :." + result.getLongValue(fieldName)), (boolean)result.hasLongValue(fieldName));
                if (!this.verbose) continue;
                LOG.info("Passed: Long value for '{}'{} was correctly absent", (Object)fieldName, (Object)this.padding(fieldName, longestFieldName));
            }
            for (String fieldName : this.expectedAbsentDoubles) {
                Assert.assertFalse((String)("The Double value for '" + fieldName + "' should have been absent. It was :." + result.getDoubleValue(fieldName)), (boolean)result.hasDoubleValue(fieldName));
                if (!this.verbose) continue;
                LOG.info("Passed: Double value for '{}'{} was correctly absent", (Object)fieldName, (Object)this.padding(fieldName, longestFieldName));
            }
        }
    }

    private TestRecord parse(String inputValue) {
        TestRecord testRecord = new TestRecord();
        if (this.verbose) {
            testRecord.setVerbose();
        }
        try {
            return (TestRecord)this.parser.parse((Object)testRecord, inputValue);
        }
        catch (DissectionFailure | InvalidDissectorException | MissingDissectorsException e) {
            Assert.fail((String)e.toString());
            return testRecord;
        }
    }

    private void checkExpectedPossible() {
        int longestFieldName = 0;
        for (String fieldName : this.expectedValuePresent) {
            longestFieldName = Math.max(longestFieldName, fieldName.length());
        }
        List allpossible = this.parser.getPossiblePaths();
        for (String fieldName : this.expectedPossible) {
            Assert.assertTrue((String)("The fieldName '" + fieldName + "' is not possible."), (boolean)allpossible.contains(fieldName));
            if (!this.verbose) continue;
            LOG.info("Passed: Fieldname '{}'{} is possible.", (Object)fieldName, (Object)this.padding(fieldName, longestFieldName));
        }
    }

    private void checkDissectors() {
        Set dissectors = this.parser.getAllDissectors();
        for (Dissector dissector : dissectors) {
            for (String output : dissector.getPossibleOutput()) {
                String baseMsg = "Dissector " + dissector.getClass().getSimpleName() + " outputs " + output;
                String[] splitOutput = output.split(":", 2);
                Assert.assertEquals((String)(baseMsg + " which is not fully uppercase"), (Object)splitOutput[0].toUpperCase(Locale.ENGLISH), (Object)splitOutput[0]);
                Assert.assertEquals((String)(baseMsg + " which is not fully lowercase"), (Object)splitOutput[1].toLowerCase(Locale.ENGLISH), (Object)splitOutput[1]);
            }
        }
    }

    private String padding(String name, int longestFieldName) {
        int i = longestFieldName - name.length();
        if (i == 0) {
            return "";
        }
        return String.format(Locale.ENGLISH, "%" + i + "s", "");
    }

    public DissectorTester printDissectors() {
        LOG.info("=====================================================");
        LOG.info("Dissectors:");
        LOG.info("=====================================================");
        Set dissectors = this.parser.getAllDissectors();
        for (Dissector dissector : dissectors) {
            LOG.info("-----------------------------------------------------");
            LOG.info("{} --> {}", (Object)dissector.getInputType(), (Object)dissector.getClass().getSimpleName());
            for (String output : dissector.getPossibleOutput()) {
                LOG.info(">> {}", (Object)output);
            }
        }
        LOG.info("=====================================================");
        return this;
    }

    public DissectorTester printPossible() {
        LOG.info("=====================================================");
        LOG.info("Possible:");
        LOG.info("----------");
        for (String path : this.parser.getPossiblePaths()) {
            LOG.info("---> {}", (Object)path);
        }
        LOG.info("=====================================================");
        return this;
    }

    public List<String> getPossible() {
        return this.parser.getPossiblePaths();
    }

    public DissectorTester printAllPossibleValues() {
        if (this.inputValues.isEmpty()) {
            Assert.fail((String)"No inputvalues were specified");
        }
        try {
            List possibleFieldNames = this.parser.getPossiblePaths();
            for (String path : possibleFieldNames) {
                this.parser.addParseTarget(TestRecord.class.getMethod("setStringValue", String.class, String.class), path);
            }
            for (String inputValue : this.inputValues) {
                LOG.info("=====================================================");
                LOG.info("All values (except wildcards) for input:{}", (Object)inputValue);
                LOG.info("=====================================================");
                for (String path : possibleFieldNames) {
                    this.parser.addParseTarget(TestRecord.class.getMethod("setStringValue", String.class, String.class), path);
                }
                TestRecord result = (TestRecord)this.parser.parse(inputValue);
                int longestFieldName = 0;
                for (String fieldName : possibleFieldNames) {
                    longestFieldName = Math.max(longestFieldName, fieldName.length());
                }
                for (String fieldName : possibleFieldNames) {
                    String value = result.getStringValue(fieldName);
                    if (value == null) {
                        value = "<<<null>>>";
                    }
                    LOG.info("Found value for {}{} = {}", new Object[]{fieldName, this.padding(fieldName, longestFieldName), value});
                }
            }
            LOG.info("=====================================================");
        }
        catch (NoSuchMethodException | DissectionFailure | InvalidDissectorException | MissingDissectorsException e) {
            e.printStackTrace();
            Assert.fail((String)"Shouldn't have any exceptions");
        }
        return this;
    }

    public DissectorTester printSeparator() {
        LOG.info("");
        LOG.info("--------------------------------------------------------------------------------");
        LOG.info("");
        return this;
    }

    public static class DummyDissector
    extends Dissector {
        private String outputType;
        private String fieldName;

        public DummyDissector() {
        }

        public DummyDissector(String newOutputType, String newFieldName) {
            this.fieldName = newFieldName;
            this.outputType = newOutputType;
        }

        public boolean initializeFromSettingsParameter(String settings) {
            return true;
        }

        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            ParsedField field = parsable.getParsableField("DUMMYROOT", inputname);
            parsable.addDissection(inputname, this.outputType, this.fieldName, field.getValue());
        }

        public String getInputType() {
            return "DUMMYROOT";
        }

        public List<String> getPossibleOutput() {
            return Collections.singletonList(this.outputType + ":" + this.fieldName);
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }

        public void prepareForRun() throws InvalidDissectorException {
        }

        protected void initializeNewInstance(Dissector newInstance) throws InvalidDissectorException {
            DummyDissector dummyDissector = (DummyDissector)newInstance;
            dummyDissector.fieldName = this.fieldName;
            dummyDissector.outputType = this.outputType;
        }
    }
}

