/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core.test;

import java.util.HashMap;
import java.util.Map;
import nl.basjes.parse.core.test.DissectorTester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRecord {
    private static final Logger LOG = LoggerFactory.getLogger(DissectorTester.class);
    private final Map<String, String> stringMap = new HashMap<String, String>(32);
    private final Map<String, Long> longMap = new HashMap<String, Long>(32);
    private final Map<String, Double> doubleMap = new HashMap<String, Double>(32);
    boolean verbose = false;

    public void setVerbose() {
        this.verbose = true;
    }

    public void setStringValue(String name, String value) {
        if (this.verbose) {
            LOG.info("Received String: {} = {}", (Object)name, (Object)value);
        }
        this.stringMap.put(name, value);
    }

    public void setLongValue(String name, Long value) {
        if (this.verbose) {
            LOG.info("Received Long  : {} = {}", (Object)name, (Object)value);
        }
        this.longMap.put(name, value);
    }

    public void setDoubleValue(String name, Double value) {
        if (this.verbose) {
            LOG.info("Received Double: {} = {}", (Object)name, (Object)value);
        }
        this.doubleMap.put(name, value);
    }

    public String getStringValue(String name) {
        return this.stringMap.get(name);
    }

    public Long getLongValue(String name) {
        return this.longMap.get(name);
    }

    public Double getDoubleValue(String name) {
        return this.doubleMap.get(name);
    }

    public boolean hasStringValue(String name) {
        return this.stringMap.containsKey(name);
    }

    public boolean hasLongValue(String name) {
        return this.longMap.containsKey(name);
    }

    public boolean hasDoubleValue(String name) {
        return this.doubleMap.containsKey(name);
    }

    public void clear() {
        this.stringMap.clear();
        this.longMap.clear();
        this.doubleMap.clear();
    }
}

