/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Field;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import org.junit.Assert;
import org.junit.Test;

public class ParserDissectionOutputTypesTest {
    @Test
    public void testSetterTypes() throws Exception {
        TestParser<TestRecord> parser = new TestParser<TestRecord>(TestRecord.class);
        TestRecord output = new TestRecord();
        parser.parse(output, "Something");
        Assert.assertEquals((long)36L, (long)output.count);
    }

    public static class TestRecord {
        private int count = 0;

        @Field(value={"OUTPUT_TYPE:string_set_null", "OUTPUT_TYPE:long_set_longclass_null", "OUTPUT_TYPE:long_set_string_null", "OUTPUT_TYPE:double_set_doubleclass_null", "OUTPUT_TYPE:double_set_longclass_null", "OUTPUT_TYPE:double_set_string_null"})
        public void setStringNull(String value) {
            ++this.count;
            Assert.assertEquals(null, (Object)value);
        }

        @Field(value={"OUTPUT_TYPE:long_set_longclass_null", "OUTPUT_TYPE:long_set_string_null", "OUTPUT_TYPE:double_set_doubleclass_null", "OUTPUT_TYPE:double_set_longclass_null", "OUTPUT_TYPE:double_set_string_null"})
        public void setLongNull(Long value) {
            ++this.count;
            Assert.assertEquals(null, (Object)value);
        }

        @Field(value={"OUTPUT_TYPE:double_set_doubleclass_null", "OUTPUT_TYPE:double_set_longclass_null", "OUTPUT_TYPE:double_set_string_null"})
        public void setDoubleNull(Double value) {
            ++this.count;
            Assert.assertEquals(null, (Object)value);
        }

        @Field(value={"OUTPUT_TYPE:string_set_string", "OUTPUT_TYPE:long_set_longclass", "OUTPUT_TYPE:long_set_longprimitive", "OUTPUT_TYPE:long_set_string", "OUTPUT_TYPE:double_set_longclass", "OUTPUT_TYPE:double_set_longprimitive", "OUTPUT_TYPE:double_set_string"})
        public void setString(String value) {
            ++this.count;
            Assert.assertEquals((Object)"42", (Object)value);
        }

        @Field(value={"OUTPUT_TYPE:double_set_doubleclass", "OUTPUT_TYPE:double_set_doubleprimitive"})
        public void setStringFromDouble(String value) {
            ++this.count;
            Assert.assertEquals((Object)"42.0", (Object)value);
        }

        @Field(value={"OUTPUT_TYPE:long_set_longclass", "OUTPUT_TYPE:long_set_longprimitive", "OUTPUT_TYPE:long_set_string", "OUTPUT_TYPE:double_set_doubleclass", "OUTPUT_TYPE:double_set_doubleprimitive", "OUTPUT_TYPE:double_set_longclass", "OUTPUT_TYPE:double_set_longprimitive", "OUTPUT_TYPE:double_set_string"})
        public void setLong(Long value) {
            ++this.count;
            Assert.assertEquals((Object)42L, (Object)value);
        }

        @Field(value={"OUTPUT_TYPE:double_set_doubleclass", "OUTPUT_TYPE:double_set_doubleprimitive", "OUTPUT_TYPE:double_set_longclass", "OUTPUT_TYPE:double_set_longprimitive", "OUTPUT_TYPE:double_set_string"})
        public void setDouble(Double value) {
            ++this.count;
            Assert.assertEquals((double)42.0, (double)value, (double)0.01);
        }
    }

    public static class TestParser<RECORD>
    extends Parser<RECORD> {
        public TestParser(Class<RECORD> clazz) {
            super(clazz);
            this.addDissector(new TestDissector());
            this.setRootType("INPUT_TYPE");
        }
    }

    public static class TestDissector
    extends Dissector {
        private static final Map<String, EnumSet<Casts>> PREPARE_FOR_DISSECT_MAP = new HashMap<String, EnumSet<Casts>>();

        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            parsable.addDissection(inputname, "OUTPUT_TYPE", "string_set_null", (String)null);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "string_set_string", "42");
            parsable.addDissection(inputname, "OUTPUT_TYPE", "long_set_string_null", (String)null);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "long_set_string", "42");
            parsable.addDissection(inputname, "OUTPUT_TYPE", "long_set_longclass_null", (Long)null);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "long_set_longclass", Long.valueOf(42L));
            parsable.addDissection(inputname, "OUTPUT_TYPE", "long_set_longprimitive", 42L);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "double_set_string_null", (String)null);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "double_set_string", "42");
            parsable.addDissection(inputname, "OUTPUT_TYPE", "double_set_longclass_null", (Long)null);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "double_set_longclass", Long.valueOf(42L));
            parsable.addDissection(inputname, "OUTPUT_TYPE", "double_set_longprimitive", 42L);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "double_set_doubleclass_null", (Double)null);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "double_set_doubleclass", Double.valueOf(42.0));
            parsable.addDissection(inputname, "OUTPUT_TYPE", "double_set_doubleprimitive", 42.0);
        }

        public String getInputType() {
            return "INPUT_TYPE";
        }

        public List<String> getPossibleOutput() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("OUTPUT_TYPE:string_set_null");
            result.add("OUTPUT_TYPE:string_set_string");
            result.add("OUTPUT_TYPE:long_set_longclass_null");
            result.add("OUTPUT_TYPE:long_set_longclass");
            result.add("OUTPUT_TYPE:long_set_longprimitive");
            result.add("OUTPUT_TYPE:long_set_string_null");
            result.add("OUTPUT_TYPE:long_set_string");
            result.add("OUTPUT_TYPE:double_set_doubleclass_null");
            result.add("OUTPUT_TYPE:double_set_doubleclass");
            result.add("OUTPUT_TYPE:double_set_doubleprimitive");
            result.add("OUTPUT_TYPE:double_set_longclass_null");
            result.add("OUTPUT_TYPE:double_set_longclass");
            result.add("OUTPUT_TYPE:double_set_longprimitive");
            result.add("OUTPUT_TYPE:double_set_string_null");
            result.add("OUTPUT_TYPE:double_set_string");
            return result;
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return PREPARE_FOR_DISSECT_MAP.get(outputname);
        }

        static {
            PREPARE_FOR_DISSECT_MAP.put("string_set_null", Casts.STRING_ONLY);
            PREPARE_FOR_DISSECT_MAP.put("string_set_string", Casts.STRING_ONLY);
            PREPARE_FOR_DISSECT_MAP.put("long_set_longclass_null", Casts.STRING_OR_LONG);
            PREPARE_FOR_DISSECT_MAP.put("long_set_longclass", Casts.STRING_OR_LONG);
            PREPARE_FOR_DISSECT_MAP.put("long_set_longprimitive", Casts.STRING_OR_LONG);
            PREPARE_FOR_DISSECT_MAP.put("long_set_string_null", Casts.STRING_OR_LONG);
            PREPARE_FOR_DISSECT_MAP.put("long_set_string", Casts.STRING_OR_LONG);
            PREPARE_FOR_DISSECT_MAP.put("double_set_doubleclass_null", Casts.STRING_OR_LONG_OR_DOUBLE);
            PREPARE_FOR_DISSECT_MAP.put("double_set_doubleclass", Casts.STRING_OR_LONG_OR_DOUBLE);
            PREPARE_FOR_DISSECT_MAP.put("double_set_doubleprimitive", Casts.STRING_OR_LONG_OR_DOUBLE);
            PREPARE_FOR_DISSECT_MAP.put("double_set_longclass_null", Casts.STRING_OR_LONG_OR_DOUBLE);
            PREPARE_FOR_DISSECT_MAP.put("double_set_longclass", Casts.STRING_OR_LONG_OR_DOUBLE);
            PREPARE_FOR_DISSECT_MAP.put("double_set_longprimitive", Casts.STRING_OR_LONG_OR_DOUBLE);
            PREPARE_FOR_DISSECT_MAP.put("double_set_string_null", Casts.STRING_OR_LONG_OR_DOUBLE);
            PREPARE_FOR_DISSECT_MAP.put("double_set_string", Casts.STRING_OR_LONG_OR_DOUBLE);
        }
    }
}

