/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.EnumSet;
import java.util.HashMap;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.SimpleDissector;
import nl.basjes.parse.core.Value;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.test.DissectorTester;
import org.junit.jupiter.api.Test;

class ParserDuplicateOutputTest {
    ParserDuplicateOutputTest() {
    }

    @Test
    void testParseString() {
        DissectorTester.create().verbose().withDissector((Dissector)new FooDissector()).withDissector((Dissector)new BarDissector()).withInput("SomeThing").printPossible().expect("STRING:output", "foo").expect("STRING:output", "bar").checkExpectations();
    }

    public static class BarDissector
    extends MyDissector {
        public void dissect(Parsable<?> parsable, String inputname, Value value) throws DissectionFailure {
            parsable.addDissection(inputname, "STRING", "output", "bar");
        }
    }

    public static class FooDissector
    extends MyDissector {
        public void dissect(Parsable<?> parsable, String inputname, Value value) throws DissectionFailure {
            parsable.addDissection(inputname, "STRING", "output", "foo");
        }
    }

    public static abstract class MyDissector
    extends SimpleDissector {
        private static final HashMap<String, EnumSet<Casts>> DISSECTOR_CONFIG = new HashMap();

        public MyDissector() {
            super("INPUT", DISSECTOR_CONFIG);
        }

        static {
            DISSECTOR_CONFIG.put("STRING:output", Casts.STRING_ONLY);
        }
    }
}

