/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.SimpleDissector;
import nl.basjes.parse.core.Value;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParserTypeRemappingEdgeCase {
    @Test
    void testParseString() throws Exception {
        TestParser<Record> parser = new TestParser<Record>(Record.class);
        parser.addParseTarget(Record.class.getMethod("set1", String.class, String.class), "LONG_AS_STRING:long_as_string").addTypeRemapping("long_as_string", "SOMETHING", Casts.LONG_ONLY).addParseTarget(Record.class.getMethod("set", String.class, Long.class), "SOMETHING:long_as_string").addParseTarget(Record.class.getMethod("set2", String.class, String.class), "SOMETHING:long_as_string");
        Record output = new Record();
        parser.parse(output, "An input that does not matter");
        Assertions.assertEquals((Object)"42", (Object)output.stringValue1);
        Assertions.assertEquals((Object)"empty", (Object)output.stringValue2);
        Assertions.assertEquals((long)42L, (long)output.longValue);
    }

    public static class Record {
        String stringName1 = "empty";
        String stringValue1 = "empty";
        String stringName2 = "empty";
        String stringValue2 = "empty";
        String longName = "empty";
        long longValue = 0L;

        public void set1(String name, String value) {
            this.stringName1 = name;
            this.stringValue1 = value;
        }

        public void set2(String name, String value) {
            this.stringName2 = name;
            this.stringValue2 = value;
        }

        public void set(String name, Long value) {
            this.longName = name;
            this.longValue = value;
        }
    }

    public static class TestParser<RECORD>
    extends Parser<RECORD> {
        public TestParser(Class<RECORD> clazz) {
            super(clazz);
            this.addDissector((Dissector)new TestDissectorLongAsString());
            this.setRootType("INPUTTYPE");
        }
    }

    public static class TestDissectorLongAsString
    extends SimpleDissector {
        private static final Map<String, EnumSet<Casts>> OUTPUT = new TreeMap<String, EnumSet<Casts>>();

        public TestDissectorLongAsString() {
            super("INPUTTYPE", OUTPUT);
        }

        public void dissect(Parsable<?> parsable, String inputname, Value value) throws DissectionFailure {
            parsable.addDissection(inputname, "LONG_AS_STRING", "long_as_string", "42");
        }

        static {
            OUTPUT.put("LONG_AS_STRING:long_as_string", Casts.STRING_ONLY);
        }
    }
}

