/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core.test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import nl.basjes.parse.core.test.DissectorTester;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRecord {
    private static final Logger LOG = LoggerFactory.getLogger(DissectorTester.class);
    private final Map<String, Set<String>> stringMap = new HashMap<String, Set<String>>(32);
    private final Map<String, Set<Long>> longMap = new HashMap<String, Set<Long>>(32);
    private final Map<String, Set<Double>> doubleMap = new HashMap<String, Set<Double>>(32);
    boolean verbose = false;

    public void setVerbose() {
        this.verbose = true;
    }

    public Set<String> getAllNames() {
        TreeSet<String> allNames = new TreeSet<String>();
        allNames.addAll(this.stringMap.keySet());
        allNames.addAll(this.longMap.keySet());
        allNames.addAll(this.doubleMap.keySet());
        return allNames;
    }

    public void setStringValue(String name, String value) {
        if (this.verbose) {
            LOG.info("Received String: {} = {}", (Object)name, (Object)value);
        }
        this.stringMap.computeIfAbsent(name, s -> new HashSet()).add(value);
    }

    public void setLongValue(String name, Long value) {
        if (this.verbose) {
            LOG.info("Received Long  : {} = {}", (Object)name, (Object)value);
        }
        this.longMap.computeIfAbsent(name, s -> new HashSet()).add(value);
    }

    public void setDoubleValue(String name, Double value) {
        if (this.verbose) {
            LOG.info("Received Double: {} = {}", (Object)name, (Object)value);
        }
        this.doubleMap.computeIfAbsent(name, s -> new HashSet()).add(value);
    }

    public String getStringValue(String name) {
        Set<String> value = this.stringMap.get(name);
        if (value == null) {
            return null;
        }
        return value.iterator().next();
    }

    public Long getLongValue(String name) {
        Set<Long> value = this.longMap.get(name);
        if (value == null) {
            return null;
        }
        return value.iterator().next();
    }

    public Double getDoubleValue(String name) {
        Set<Double> value = this.doubleMap.get(name);
        if (value == null) {
            return null;
        }
        return value.iterator().next();
    }

    public Set<String> getStringValues(String name) {
        return this.stringMap.get(name);
    }

    public Set<Long> getLongValues(String name) {
        return this.longMap.get(name);
    }

    public Set<Double> getDoubleValues(String name) {
        return this.doubleMap.get(name);
    }

    public boolean hasStringValue(String name) {
        return this.stringMap.containsKey(name);
    }

    public boolean hasLongValue(String name) {
        return this.longMap.containsKey(name);
    }

    public boolean hasDoubleValue(String name) {
        return this.doubleMap.containsKey(name);
    }

    public TestRecord expectString(String field, String ... values) {
        if (values == null) {
            this.isPresent(this.stringMap, field, values);
        } else {
            for (String value : values) {
                this.isPresent(this.stringMap, field, value);
            }
        }
        return this;
    }

    public TestRecord expectLong(String field, Long ... values) {
        if (values == null) {
            this.isPresent(this.longMap, field, values);
        } else {
            for (Long value : values) {
                this.isPresent(this.longMap, field, value);
            }
        }
        return this;
    }

    public TestRecord expectDouble(String field, Double ... values) {
        if (values == null) {
            this.isPresent(this.doubleMap, field, values);
        } else {
            for (Double value : values) {
                this.isPresent(this.doubleMap, field, value);
            }
        }
        return this;
    }

    private void isPresent(Map<String, ?> results, String field, Object value) {
        if (value == null) {
            Assertions.assertTrue((boolean)results.containsKey(field), (String)("The field \"" + field + "\" is missing (a null value was expected)."));
            Object actualValue = results.get(field);
            Assertions.assertNotNull(actualValue, (String)("The field \"" + field + "\" should be present but it is not"));
            Assertions.assertTrue((boolean)(actualValue instanceof Set), (String)"Invalid type used, result must be a Set<?>");
            Set actualValues = (Set)actualValue;
            for (Object actualValuee : actualValues) {
                Assertions.assertNull(actualValuee, (String)("The field \"" + field + "\" should only have null values but we found: (" + actualValue.getClass().getSimpleName() + ")\"" + actualValue + "\" "));
            }
        } else {
            Assertions.assertTrue((boolean)results.containsKey(field), (String)("The field \"" + field + "\" is missing (an entry of type " + value.getClass().getSimpleName() + " was expected)."));
            Object result = results.get(field);
            Assertions.assertTrue((boolean)(result instanceof Set), (String)"Invalid type used, result must be a Set<?>");
            Set resultSet = (Set)result;
            Assertions.assertTrue((boolean)resultSet.contains(value), (String)("The field \"" + field + "\" should have the value (" + value + ")\"" + value + "\"is missing"));
        }
    }

    public TestRecord noString(String field) {
        this.isAbsent(this.stringMap, field);
        return this;
    }

    public TestRecord noLong(String field) {
        this.isAbsent(this.longMap, field);
        return this;
    }

    public TestRecord noDouble(String field) {
        this.isAbsent(this.doubleMap, field);
        return this;
    }

    private void isAbsent(Map<String, ?> results, String field) {
        Object value = results.get(field);
        if (value != null) {
            Assertions.fail((String)("The value \"" + value + "\" was found for field \"" + field + "\""));
        } else {
            Assertions.assertFalse((results.containsKey(field) || results.get(field) != null ? 1 : 0) != 0, (String)("A null value was found for field \"" + field + "\""));
        }
    }

    public void clear() {
        this.stringMap.clear();
        this.longMap.clear();
        this.doubleMap.clear();
    }
}

