/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Field;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ParserCastsTest {
    ParserCastsTest() {
    }

    @Test
    void testValidCasting() throws Exception {
        MyParser<MyRecord> parser = new MyParser<MyRecord>(MyRecord.class);
        MyRecord output = new MyRecord();
        parser.parse(output, "Something");
        Assertions.assertEquals((int)22, (int)output.count);
        Map allCasts = parser.getAllCasts();
        Assertions.assertEquals((Object)Casts.STRING_ONLY, allCasts.get("OUTPUT_TYPE:string_good"));
        Assertions.assertEquals((Object)Casts.LONG_ONLY, allCasts.get("OUTPUT_TYPE:long_good"));
        Assertions.assertEquals((Object)Casts.DOUBLE_ONLY, allCasts.get("OUTPUT_TYPE:double_good"));
        Assertions.assertEquals((Object)Casts.STRING_OR_LONG, allCasts.get("OUTPUT_TYPE:string_long_good"));
        Assertions.assertEquals((Object)Casts.STRING_OR_DOUBLE, allCasts.get("OUTPUT_TYPE:string_double_good"));
        Assertions.assertEquals((Object)Casts.STRING_OR_LONG_OR_DOUBLE, allCasts.get("OUTPUT_TYPE:multi_good"));
        Assertions.assertEquals((Object)Casts.STRING_ONLY, (Object)parser.getCasts("OUTPUT_TYPE:string_good"));
        Assertions.assertEquals((Object)Casts.LONG_ONLY, (Object)parser.getCasts("OUTPUT_TYPE:long_good"));
        Assertions.assertEquals((Object)Casts.DOUBLE_ONLY, (Object)parser.getCasts("OUTPUT_TYPE:double_good"));
        Assertions.assertEquals((Object)Casts.STRING_OR_LONG, (Object)parser.getCasts("OUTPUT_TYPE:string_long_good"));
        Assertions.assertEquals((Object)Casts.STRING_OR_DOUBLE, (Object)parser.getCasts("OUTPUT_TYPE:string_double_good"));
        Assertions.assertEquals((Object)Casts.STRING_OR_LONG_OR_DOUBLE, (Object)parser.getCasts("OUTPUT_TYPE:multi_good"));
    }

    public static class MyRecord {
        private int count = 0;

        @Field(value={"OUTPUT_TYPE:string_null", "OUTPUT_TYPE:string_long_null", "OUTPUT_TYPE:string_double_null", "OUTPUT_TYPE:multi_null"})
        public void setStringNull(String value) {
            Assertions.assertEquals(null, (Object)value);
            ++this.count;
        }

        @Field(value={"OUTPUT_TYPE:string_good", "OUTPUT_TYPE:string_long_good", "OUTPUT_TYPE:string_double_good", "OUTPUT_TYPE:multi_good"})
        public void setStringGood(String value) {
            Assertions.assertEquals((Object)"123", (Object)value);
            ++this.count;
        }

        @Field(value={"OUTPUT_TYPE:long_null", "OUTPUT_TYPE:long_bad", "OUTPUT_TYPE:string_long_null", "OUTPUT_TYPE:multi_null"})
        public void setLongNull(Long value) {
            Assertions.assertEquals(null, (Long)value);
            ++this.count;
        }

        @Field(value={"OUTPUT_TYPE:long_good", "OUTPUT_TYPE:string_long_good", "OUTPUT_TYPE:multi_good"})
        public void setLongGood(Long value) {
            Assertions.assertEquals((Long)123L, (Long)value);
            ++this.count;
        }

        @Field(value={"OUTPUT_TYPE:double_null", "OUTPUT_TYPE:double_bad", "OUTPUT_TYPE:string_double_null", "OUTPUT_TYPE:multi_null"})
        public void setDoubleNull(Double value) {
            Assertions.assertEquals(null, (Double)value);
            ++this.count;
        }

        @Field(value={"OUTPUT_TYPE:double_good", "OUTPUT_TYPE:string_double_good", "OUTPUT_TYPE:multi_good"})
        public void setDoubleGood(Double value) {
            Assertions.assertEquals((double)123.0, (double)value, (double)1.0E-4);
            ++this.count;
        }

        @Field(value={"OUTPUT_TYPE:long_null", "OUTPUT_TYPE:long_bad", "OUTPUT_TYPE:long_good", "OUTPUT_TYPE:string_long_null", "OUTPUT_TYPE:string_long_good"})
        public void setLongWrongSignature(String name, Double value) {
            Assertions.fail((String)("This setter uses Double but that is not allowed for \"" + name + "\" "));
        }

        @Field(value={"OUTPUT_TYPE:double_null", "OUTPUT_TYPE:double_bad", "OUTPUT_TYPE:double_good", "OUTPUT_TYPE:string_double_null", "OUTPUT_TYPE:string_double_good"})
        public void setDoubleWrongSignature(String name, Long value) {
            Assertions.fail((String)("This setter uses Long but that is not allowed for \"" + name + "\" "));
        }
    }

    public static class MyParser<RECORD>
    extends Parser<RECORD> {
        public MyParser(Class<RECORD> clazz) {
            super(clazz);
            this.addDissector(new MyDissector());
            this.setRootType("INPUT_TYPE");
        }
    }

    public static class MyDissector
    extends Dissector {
        private static final Map<String, EnumSet<Casts>> PREPARE_FOR_DISSECT_MAP = new HashMap<String, EnumSet<Casts>>();

        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            parsable.addDissection(inputname, "OUTPUT_TYPE", "string_null", (String)null);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "string_good", "123");
            parsable.addDissection(inputname, "OUTPUT_TYPE", "long_null", (String)null);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "long_bad", "Something");
            parsable.addDissection(inputname, "OUTPUT_TYPE", "long_good", "123");
            parsable.addDissection(inputname, "OUTPUT_TYPE", "double_null", (String)null);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "double_bad", "Something");
            parsable.addDissection(inputname, "OUTPUT_TYPE", "double_good", "123");
            parsable.addDissection(inputname, "OUTPUT_TYPE", "string_long_null", (String)null);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "string_double_null", (String)null);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "multi_null", (String)null);
            parsable.addDissection(inputname, "OUTPUT_TYPE", "string_long_good", "123");
            parsable.addDissection(inputname, "OUTPUT_TYPE", "string_double_good", "123");
            parsable.addDissection(inputname, "OUTPUT_TYPE", "multi_good", "123");
        }

        public String getInputType() {
            return "INPUT_TYPE";
        }

        public List<String> getPossibleOutput() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("OUTPUT_TYPE:string_null");
            result.add("OUTPUT_TYPE:string_good");
            result.add("OUTPUT_TYPE:long_null");
            result.add("OUTPUT_TYPE:long_bad");
            result.add("OUTPUT_TYPE:long_good");
            result.add("OUTPUT_TYPE:double_null");
            result.add("OUTPUT_TYPE:double_bad");
            result.add("OUTPUT_TYPE:double_good");
            result.add("OUTPUT_TYPE:string_long_null");
            result.add("OUTPUT_TYPE:string_double_null");
            result.add("OUTPUT_TYPE:multi_null");
            result.add("OUTPUT_TYPE:string_long_good");
            result.add("OUTPUT_TYPE:string_double_good");
            result.add("OUTPUT_TYPE:multi_good");
            return result;
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return PREPARE_FOR_DISSECT_MAP.getOrDefault(outputname, Casts.NO_CASTS);
        }

        static {
            PREPARE_FOR_DISSECT_MAP.put("string_null", Casts.STRING_ONLY);
            PREPARE_FOR_DISSECT_MAP.put("string_good", Casts.STRING_ONLY);
            PREPARE_FOR_DISSECT_MAP.put("long_null", Casts.LONG_ONLY);
            PREPARE_FOR_DISSECT_MAP.put("long_bad", Casts.LONG_ONLY);
            PREPARE_FOR_DISSECT_MAP.put("long_good", Casts.LONG_ONLY);
            PREPARE_FOR_DISSECT_MAP.put("double_null", Casts.DOUBLE_ONLY);
            PREPARE_FOR_DISSECT_MAP.put("double_bad", Casts.DOUBLE_ONLY);
            PREPARE_FOR_DISSECT_MAP.put("double_good", Casts.DOUBLE_ONLY);
            PREPARE_FOR_DISSECT_MAP.put("string_long_null", Casts.STRING_OR_LONG);
            PREPARE_FOR_DISSECT_MAP.put("string_double_null", Casts.STRING_OR_DOUBLE);
            PREPARE_FOR_DISSECT_MAP.put("multi_null", Casts.STRING_OR_LONG_OR_DOUBLE);
            PREPARE_FOR_DISSECT_MAP.put("string_long_good", Casts.STRING_OR_LONG);
            PREPARE_FOR_DISSECT_MAP.put("string_double_good", Casts.STRING_OR_DOUBLE);
            PREPARE_FOR_DISSECT_MAP.put("multi_good", Casts.STRING_OR_LONG_OR_DOUBLE);
        }
    }
}

