/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.ParserNormalTestRecord;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import nl.basjes.parse.core.test.NormalValuesDissector;
import nl.basjes.parse.core.test.TestRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ParserNormalTest {
    ParserNormalTest() {
    }

    @Test
    void testParseString() throws Exception {
        TestParser<ParserNormalTestRecord> parser = new TestParser<ParserNormalTestRecord>(ParserNormalTestRecord.class);
        String[] params = new String[]{"OTHERTYPE:output2"};
        parser.addParseTarget(ParserNormalTestRecord.class.getMethod("setValue2", String.class, String.class), Arrays.asList(params)).dropDissector(MyDissectorWildCard.class).addDissector((Dissector)new MyDissectorWildCard());
        ParserNormalTestRecord output = new ParserNormalTestRecord();
        parser.parse(output, "Something");
        Assertions.assertEquals((Object)"SOMETYPE1:SOMETYPE:output1:Something", (Object)output.getOutput1());
        Assertions.assertEquals((Object)"OTHERTYPE2:OTHERTYPE:output2:Something", (Object)output.getOutput2());
        Assertions.assertEquals((Object)"SOMETYPE3:SOMETYPE:output1:Something", (Object)output.getOutput3a());
        Assertions.assertEquals((Object)"OTHERTYPE3:OTHERTYPE:output2:Something", (Object)output.getOutput3b());
        Assertions.assertEquals((Object)"X=SOMETYPE:SOMETYPE:output1:Something", (Object)output.getOutput4a());
        Assertions.assertEquals((Object)"Y=OTHERTYPE:OTHERTYPE:output2:Something", (Object)output.getOutput4b());
        Assertions.assertEquals((Object)"X=SOMETYPE:SOMETYPE:output1:Something=SOMETYPE:SOMETYPE:output1:Something", (Object)output.getOutput5a());
        Assertions.assertEquals((Object)"Y=OTHERTYPE:OTHERTYPE:output2:Something=OTHERTYPE:OTHERTYPE:output2:Something", (Object)output.getOutput5b());
        Assertions.assertEquals((Object)"Z=FOO:FOO:output1.foo:Something", (Object)output.getOutput6());
        Assertions.assertEquals((Object)"Z=BAR:BAR:output1.bar:Something", (Object)output.getOutput7());
        Assertions.assertEquals((Object)"Z=WILD:WILD:output1.wild:Something", (Object)output.getOutput8());
    }

    @Test
    void testParseStringInstantiate() throws Exception {
        TestParser<ParserNormalTestRecord> parser = new TestParser<ParserNormalTestRecord>(ParserNormalTestRecord.class);
        String[] params = new String[]{"OTHERTYPE:output2"};
        parser.addParseTarget(ParserNormalTestRecord.class.getMethod("setValue2", String.class, String.class), Arrays.asList(params));
        ParserNormalTestRecord output = (ParserNormalTestRecord)parser.parse("Something");
        Assertions.assertEquals((Object)"SOMETYPE1:SOMETYPE:output1:Something", (Object)output.getOutput1());
        Assertions.assertEquals((Object)"OTHERTYPE2:OTHERTYPE:output2:Something", (Object)output.getOutput2());
        Assertions.assertEquals((Object)"SOMETYPE3:SOMETYPE:output1:Something", (Object)output.getOutput3a());
        Assertions.assertEquals((Object)"OTHERTYPE3:OTHERTYPE:output2:Something", (Object)output.getOutput3b());
        Assertions.assertEquals((Object)"X=SOMETYPE:SOMETYPE:output1:Something", (Object)output.getOutput4a());
        Assertions.assertEquals((Object)"Y=OTHERTYPE:OTHERTYPE:output2:Something", (Object)output.getOutput4b());
        Assertions.assertEquals((Object)"X=SOMETYPE:SOMETYPE:output1:Something=SOMETYPE:SOMETYPE:output1:Something", (Object)output.getOutput5a());
        Assertions.assertEquals((Object)"Y=OTHERTYPE:OTHERTYPE:output2:Something=OTHERTYPE:OTHERTYPE:output2:Something", (Object)output.getOutput5b());
        Assertions.assertEquals((Object)"Z=FOO:FOO:output1.foo:Something", (Object)output.getOutput6());
        Assertions.assertEquals((Object)"Z=BAR:BAR:output1.bar:Something", (Object)output.getOutput7());
        Assertions.assertEquals((Object)"Z=WILD:WILD:output1.wild:Something", (Object)output.getOutput8());
    }

    @Test
    void testMissingDissector() {
        TestParser<ParserNormalTestRecord> parser = new TestParser<ParserNormalTestRecord>(ParserNormalTestRecord.class);
        parser.dropDissector(MyDissectorTwo.class);
        ParserNormalTestRecord output = new ParserNormalTestRecord();
        Assertions.assertThrows(MissingDissectorsException.class, () -> parser.parse(output, "Something"));
    }

    @Test
    void testGetPossiblePaths() throws Exception {
        TestParser<ParserNormalTestRecord> parser = new TestParser<ParserNormalTestRecord>(ParserNormalTestRecord.class);
        String[] params = new String[]{"OTHERTYPE:output2"};
        parser.addParseTarget(ParserNormalTestRecord.class.getMethod("setValue2", String.class, String.class), Arrays.asList(params));
        List paths = parser.getPossiblePaths(3);
        for (String path : paths) {
            System.out.println("XXX " + path);
        }
    }

    @Test
    void testAddTypeRemapping() throws NoSuchMethodException, InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        ((TestRecord)new Parser(TestRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).addTypeRemapping("string", "STRINGXX").addParseTarget("setStringValue", "STRINGXX:string").addTypeRemapping("string", "STRINGYY").addParseTarget("setStringValue", "STRINGYY:string").parse("Doesn't matter")).expectString("STRINGXX:string", "FortyTwo").expectString("STRINGYY:string", "FortyTwo");
    }

    @Test
    void testAddTypeRemappings() throws NoSuchMethodException, InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        ((TestRecord)new Parser(TestRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).addTypeRemapping("string", "STRINGXX").addParseTarget("setStringValue", "STRINGXX:string").addTypeRemappings(Collections.singletonMap("string", Collections.singleton("STRINGYY"))).addParseTarget("setStringValue", "STRINGYY:string").parse("Doesn't matter")).expectString("STRINGXX:string", "FortyTwo").expectString("STRINGYY:string", "FortyTwo");
    }

    @Test
    void testSetTypeRemapping() throws NoSuchMethodException, InvalidDissectorException, DissectionFailure {
        try {
            new Parser(TestRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).addTypeRemapping("string", "STRINGXX").addParseTarget("setStringValue", "STRINGXX:string").setTypeRemappings(Collections.singletonMap("string", Collections.singleton("STRINGYY"))).addParseTarget("setStringValue", "STRINGYY:string").parse("Doesn't matter");
            Assertions.fail((String)"We should get an exception because the mapping to STRINGXX:string wass removed.");
        }
        catch (MissingDissectorsException mde) {
            Assertions.assertTrue((boolean)mde.getMessage().contains("STRINGXX:string"));
        }
    }

    public static class TestParser<RECORD>
    extends Parser<RECORD> {
        public TestParser(Class<RECORD> clazz) {
            super(clazz);
            this.addDissector(new MyDissectorOne());
            this.addDissector(new MyDissectorTwo());
            this.addDissector(new MyDissectorThree());
            this.addDissector(new MyDissectorFour());
            this.addDissector(new MyDissectorWildCard());
            this.setRootType("INPUTTYPE");
        }
    }

    public static class MyDissectorWildCard
    extends MyDissector {
        public MyDissectorWildCard() {
            super("SOMETYPE", "WILD", "*");
        }
    }

    public static class MyDissectorFour
    extends MyDissector {
        public MyDissectorFour() {
            super("SOMETYPE", "BAR", "bar");
        }
    }

    public static class MyDissectorThree
    extends MyDissector {
        public MyDissectorThree() {
            super("SOMETYPE", "FOO", "foo");
        }
    }

    public static class MyDissectorTwo
    extends MyDissector {
        public MyDissectorTwo() {
            super("INPUTTYPE", "OTHERTYPE", "output2");
        }
    }

    public static class MyDissectorOne
    extends MyDissector {
        public MyDissectorOne() {
            super("INPUTTYPE", "SOMETYPE", "output1");
        }
    }

    public static class MyDissector
    extends Dissector {
        private String inputType;
        private String outputType;
        private String outputName;
        private final Set<String> outputNames = new HashSet<String>();

        public MyDissector(String inputType, String outputType, String outputName) {
            this.inputType = inputType;
            this.outputType = outputType;
            this.outputName = outputName;
            this.outputNames.add(outputName);
        }

        public void init(String inputtype, String outputtype, String outputname) {
            this.inputType = inputtype;
            this.outputType = outputtype;
            this.outputName = outputname;
            this.outputNames.add(outputname);
        }

        protected void initializeNewInstance(Dissector newInstance) {
            ((MyDissector)newInstance).init(this.inputType, this.outputType, this.outputName);
        }

        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            ParsedField field = parsable.getParsableField(this.inputType, inputname);
            for (String outputname : this.outputNames) {
                parsable.addDissection(inputname, this.outputType, outputname, field.getValue());
            }
        }

        public String getInputType() {
            return this.inputType;
        }

        public List<String> getPossibleOutput() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.outputType + ":" + this.outputName);
            return result;
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            String name = outputname;
            String prefix = inputname + '.';
            if (outputname.startsWith(prefix)) {
                name = outputname.substring(prefix.length());
            }
            this.outputNames.add(name);
            return Casts.STRING_ONLY;
        }
    }
}

