/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.SimpleDissector;
import nl.basjes.parse.core.Value;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import nl.basjes.parse.core.test.NormalValuesDissector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ParserResetTest {
    ParserResetTest() {
    }

    @Test
    void testParserReset() throws NoSuchMethodException, InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        Parser parser = new Parser(DuplicateTestRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).addDissector((Dissector)new WildCardDissector()).addParseTarget("setStringValue", "STRING:string").addParseTarget("setStringValue", "EXTRA:string.one").addParseTarget("setStringValue", "EXTRA:string.two");
        parser.getPossiblePaths();
        parser.addDissector(null);
        DuplicateTestRecord testRecord = new DuplicateTestRecord();
        parser.parse((Object)testRecord, "Doesn't matter");
        Assertions.assertEquals((Object)"FortyTwo", (Object)testRecord.getStringValues("STRING:string").get(0));
        Assertions.assertEquals((Object)"one", (Object)testRecord.getStringValues("EXTRA:string.one").get(0));
        Assertions.assertEquals((Object)"two", (Object)testRecord.getStringValues("EXTRA:string.two").get(0));
        Assertions.assertEquals((int)1, (int)testRecord.getStringValues("STRING:string").size());
        Assertions.assertEquals((int)1, (int)testRecord.getStringValues("EXTRA:string.one").size());
        Assertions.assertEquals((int)1, (int)testRecord.getStringValues("EXTRA:string.two").size());
    }

    public static class DuplicateTestRecord {
        private final Map<String, List<String>> stringMap = new HashMap<String, List<String>>(32);

        public void setStringValue(String name, String value) {
            this.stringMap.computeIfAbsent(name, s -> new ArrayList()).add(value);
        }

        public List<String> getStringValues(String name) {
            return this.stringMap.get(name);
        }
    }

    public static class WildCardDissector
    extends SimpleDissector {
        protected final List<String> outputNames = new ArrayList<String>();
        private static final Map<String, EnumSet<Casts>> OUTPUT_TYPES = new HashMap<String, EnumSet<Casts>>();

        public WildCardDissector() {
            super("STRING", OUTPUT_TYPES);
        }

        public void dissect(Parsable<?> parsable, String inputname, Value value) throws DissectionFailure {
            for (String outputName : this.outputNames) {
                parsable.addDissection(inputname, "EXTRA", outputName, outputName);
            }
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            String name = outputname;
            String prefix = inputname + '.';
            if (outputname.startsWith(prefix)) {
                name = outputname.substring(prefix.length());
            }
            this.outputNames.add(name);
            return Casts.STRING_ONLY;
        }

        static {
            OUTPUT_TYPES.put("EXTRA:*", Casts.STRING_ONLY);
        }
    }
}

