/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Field;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParserTypeColissionTest {
    @Test
    void testParseString() throws Exception {
        TestParser<TestRecord> parser = new TestParser<TestRecord>(TestRecord.class);
        TestRecord output = new TestRecord();
        parser.parse(output, "Something");
        Assertions.assertEquals((Object)"SOMETYPE:output:Something+1", (Object)output.output1);
        Assertions.assertEquals((Object)"OTHERTYPE:output:Something+2", (Object)output.output2);
        Assertions.assertEquals((Object)"SOMESUBSUBTYPE:output.output.output:Something+1+S1+SS1", (Object)output.output3);
        Assertions.assertEquals((Object)"OTHERSUBSUBTYPE:output.output.output:Something+2+S2+SS2", (Object)output.output4);
    }

    public static class TestRecord {
        private String output1 = "xxx";
        private String output2 = "xxx";
        private String output3 = "xxx";
        private String output4 = "xxx";

        @Field(value={"SOMETYPE:output"})
        public void setValue1(String name, String value) {
            this.output1 = name + ":" + value;
        }

        @Field(value={"OTHERTYPE:output"})
        public void setValue2(String name, String value) {
            this.output2 = name + ":" + value;
        }

        @Field(value={"SOMESUBSUBTYPE:output.output.output"})
        public void setValue3(String name, String value) {
            this.output3 = name + ":" + value;
        }

        @Field(value={"OTHERSUBSUBTYPE:output.output.output"})
        public void setValue4(String name, String value) {
            this.output4 = name + ":" + value;
        }
    }

    public static class TestParser<RECORD>
    extends Parser<RECORD> {
        public TestParser(Class<RECORD> clazz) {
            super(clazz);
            this.addDissector(new TestDissectorOne());
            this.addDissector(new TestDissectorTwo());
            this.addDissector(new TestDissectorSubOne());
            this.addDissector(new TestDissectorSubTwo());
            this.addDissector(new TestDissectorSubSubOne());
            this.addDissector(new TestDissectorSubSubTwo());
            this.setRootType("INPUTTYPE");
        }
    }

    public static class TestDissectorSubSubTwo
    extends TestDissector {
        public TestDissectorSubSubTwo() {
            super("OTHERSUBTYPE", "OTHERSUBSUBTYPE", "output", "+SS2");
        }
    }

    public static class TestDissectorSubSubOne
    extends TestDissector {
        public TestDissectorSubSubOne() {
            super("SOMESUBTYPE", "SOMESUBSUBTYPE", "output", "+SS1");
        }
    }

    public static class TestDissectorSubTwo
    extends TestDissector {
        public TestDissectorSubTwo() {
            super("OTHERTYPE", "OTHERSUBTYPE", "output", "+S2");
        }
    }

    public static class TestDissectorSubOne
    extends TestDissector {
        public TestDissectorSubOne() {
            super("SOMETYPE", "SOMESUBTYPE", "output", "+S1");
        }
    }

    public static class TestDissectorTwo
    extends TestDissector {
        public TestDissectorTwo() {
            super("INPUTTYPE", "OTHERTYPE", "output", "+2");
        }
    }

    public static class TestDissectorOne
    extends TestDissector {
        public TestDissectorOne() {
            super("INPUTTYPE", "SOMETYPE", "output", "+1");
        }
    }

    public static class TestDissector
    extends Dissector {
        private String inputType;
        private String outputType;
        private String outputName;
        private String salt;

        public TestDissector(String inputType, String outputType, String outputName, String salt) {
            this.inputType = inputType;
            this.outputType = outputType;
            this.outputName = outputName;
            this.salt = salt;
        }

        public void init(String inputtype, String outputtype, String outputname, String saltt) {
            this.inputType = inputtype;
            this.outputType = outputtype;
            this.outputName = outputname;
            this.salt = saltt;
        }

        protected void initializeNewInstance(Dissector newInstance) {
            ((TestDissector)newInstance).init(this.inputType, this.outputType, this.outputName, this.salt);
        }

        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            ParsedField field = parsable.getParsableField(this.inputType, inputname);
            parsable.addDissection(inputname, this.outputType, this.outputName, field.getValue().getString() + this.salt);
        }

        public String getInputType() {
            return this.inputType;
        }

        public List<String> getPossibleOutput() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.outputType + ":" + this.outputName);
            return result;
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }
    }
}

