/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import nl.basjes.parse.core.reference.BarDissector;
import nl.basjes.parse.core.reference.FooDissector;
import nl.basjes.parse.core.test.DissectorTester;
import nl.basjes.parse.core.test.NormalValuesDissector;
import nl.basjes.parse.core.test.TestRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBadAPIUsage {
    @Test
    void testChangingInputTypeShouldNotBePossibleByDefault() {
        Assertions.assertThrows(InvalidDissectorException.class, () -> new DissectorTester.DummyDissector().setInputType("Change should not be allowed"));
    }

    @Test
    void testDissectorString() {
        Assertions.assertEquals((Object)"{ BarDissector : BARINPUT --> [LONG:barlong, FLOAT:barfloat, STRING:barstring, INT:barint, DOUBLE:bardouble, ANY:barany] }", (Object)new BarDissector().toString());
    }

    @Test
    void testNullInputHandling() {
        Assertions.assertThrows(InvalidDissectorException.class, () -> new Parser(Object.class).addDissector((Dissector)new NullInputDissector()).parse("Foo"));
    }

    @Test
    void testNullOutputHandling() {
        Assertions.assertThrows(InvalidDissectorException.class, () -> new Parser(Object.class).addDissector((Dissector)new NullOutputDissector()).parse("Foo"));
    }

    @Test
    void testEmptyOutputHandling() {
        Assertions.assertThrows(InvalidDissectorException.class, () -> new Parser(Object.class).addDissector((Dissector)new EmptyOutputDissector()).parse("Foo"));
    }

    @Test
    void testFailZeroDissectors() {
        Assertions.assertThrows(MissingDissectorsException.class, () -> new Parser(TestRecord.class).setRootType("INPUT").failOnMissingDissectors().addParseTarget("setStringValue", "SOMETHING:that.is.not.present").addParseTarget("setStringValue", "STRING:string").parse("Doesn't matter"));
    }

    @Test
    void testFailOnMissingDissectors() {
        Assertions.assertThrows(MissingDissectorsException.class, () -> new Parser(TestRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).addDissector((Dissector)new FooDissector()).addDissector((Dissector)new BarDissector()).failOnMissingDissectors().addParseTarget("setStringValue", "SOMETHING:that.is.not.present").addParseTarget("setStringValue", "STRING:string").parse("Doesn't matter"));
    }

    @Test
    void testIgnoreMissingDissectors() throws NoSuchMethodException, InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        new Parser(TestRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).addDissector((Dissector)new FooDissector()).addDissector((Dissector)new BarDissector()).ignoreMissingDissectors().addParseTarget("setStringValue", Parser.SetterPolicy.ALWAYS, "SOMETHING:that.is.not.present").addParseTarget("setStringValue", Parser.SetterPolicy.ALWAYS, "STRING:string").parse("Doesn't matter");
    }

    @Test
    void testNoSuchSetter() {
        Assertions.assertThrows(NoSuchMethodException.class, () -> new Parser(TestRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).addDissector((Dissector)new FooDissector()).addDissector((Dissector)new BarDissector()).ignoreMissingDissectors().addParseTarget("NoSetterWithThisName", "SOMETHING:that.is.not.present").parse("Doesn't matter"));
    }

    @Test
    void testBadParameters() throws NoSuchMethodException, InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        new Parser(TestRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).addDissector((Dissector)new FooDissector()).addDissector((Dissector)new BarDissector()).ignoreMissingDissectors().addParseTarget("setStringValue", Parser.SetterPolicy.ALWAYS, "SOMETHING:that.is.not.present").addParseTarget("setStringValue", Parser.SetterPolicy.ALWAYS, "STRING:string").addParseTarget("setStringValue", null).addParseTarget((Method)null, "foo").parse("Doesn't matter");
    }

    @Test
    void testFieldCleanup() throws NoSuchMethodException, InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        ((TestRecord)new Parser(TestRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).addParseTarget("setStringValue", "stRinG:stRinG").parse("Doesn't matter")).expectString("STRING:string", "FortyTwo");
    }

    public static class EmptyOutputDissector
    extends Dissector {
        public void dissect(Parsable<?> parsable, String inputname) {
        }

        public String getInputType() {
            return "SOMETHING";
        }

        public List<String> getPossibleOutput() {
            return Collections.emptyList();
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }
    }

    public static class NullOutputDissector
    extends Dissector {
        public void dissect(Parsable<?> parsable, String inputname) {
        }

        public String getInputType() {
            return "SOMETHING";
        }

        public List<String> getPossibleOutput() {
            return Collections.emptyList();
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }
    }

    public static class NullInputDissector
    extends Dissector {
        public void dissect(Parsable<?> parsable, String inputname) {
        }

        public String getInputType() {
            return null;
        }

        public List<String> getPossibleOutput() {
            return Collections.singletonList("FOO:foo");
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }
    }
}

