/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core.annotation;

import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Field;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import nl.basjes.parse.core.test.EmptyValuesDissector;
import nl.basjes.parse.core.test.NormalValuesDissector;
import nl.basjes.parse.core.test.NullValuesDissector;
import nl.basjes.parse.core.test.TestRecord;
import org.junit.jupiter.api.Test;

class TestFieldSetters {
    TestFieldSetters() {
    }

    @Test
    void testNormalValues() throws InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        ((TestFieldSettersRecord)new Parser(TestFieldSettersRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).parse("Doesn't matter")).expectString("D-ANY:any", "42").expectString("D-STRING:string", "FortyTwo").expectString("D-INT:int", "42").expectString("D-LONG:long", "42").expectString("D-FLOAT:float", "42.0").expectString("D-DOUBLE:double", "42.0").expectLong("D-ANY:any", 42L).noLong("D-STRING:string").expectLong("D-INT:int", 42L).expectLong("D-LONG:long", 42L).noLong("D-FLOAT:float").noLong("D-DOUBLE:double").expectDouble("D-ANY:any", 42.0).noDouble("D-STRING:string").noDouble("D-INT:int").noDouble("D-LONG:long").expectDouble("D-FLOAT:float", 42.0).expectDouble("D-DOUBLE:double", 42.0).expectString("A-ANY:any", "42").expectString("A-STRING:string", "FortyTwo").expectString("A-INT:int", "42").expectString("A-LONG:long", "42").expectString("A-FLOAT:float", "42.0").expectString("A-DOUBLE:double", "42.0").expectLong("A-ANY:any", 42L).noLong("A-STRING:string").expectLong("A-INT:int", 42L).expectLong("A-LONG:long", 42L).noLong("A-FLOAT:float").noLong("A-DOUBLE:double").expectDouble("A-ANY:any", 42.0).noDouble("A-STRING:string").noDouble("A-INT:int").noDouble("A-LONG:long").expectDouble("A-FLOAT:float", 42.0).expectDouble("A-DOUBLE:double", 42.0).expectString("N-ANY:any", "42").expectString("N-STRING:string", "FortyTwo").expectString("N-INT:int", "42").expectString("N-LONG:long", "42").expectString("N-FLOAT:float", "42.0").expectString("N-DOUBLE:double", "42.0").expectLong("N-ANY:any", 42L).noLong("N-STRING:string").expectLong("N-INT:int", 42L).expectLong("N-LONG:long", 42L).noLong("N-FLOAT:float").noLong("N-DOUBLE:double").expectDouble("N-ANY:any", 42.0).noDouble("N-STRING:string").noDouble("N-INT:int").noDouble("N-LONG:long").expectDouble("N-FLOAT:float", 42.0).expectDouble("N-DOUBLE:double", 42.0).expectString("E-ANY:any", "42").expectString("E-STRING:string", "FortyTwo").expectString("E-INT:int", "42").expectString("E-LONG:long", "42").expectString("E-FLOAT:float", "42.0").expectString("E-DOUBLE:double", "42.0").expectLong("E-ANY:any", 42L).noLong("E-STRING:string").expectLong("E-INT:int", 42L).expectLong("E-LONG:long", 42L).noLong("E-FLOAT:float").noLong("E-DOUBLE:double").expectDouble("E-ANY:any", 42.0).noDouble("E-STRING:string").noDouble("E-INT:int").noDouble("E-LONG:long").expectDouble("E-FLOAT:float", 42.0).expectDouble("E-DOUBLE:double", 42.0);
    }

    @Test
    void testEmptyValues() throws InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        Parser parser = new Parser(TestFieldSettersRecord.class);
        parser.setRootType("INPUT");
        parser.addDissector((Dissector)new EmptyValuesDissector());
        TestFieldSettersRecord testRecord = (TestFieldSettersRecord)parser.parse("Doesn't matter");
        testRecord.expectString("D-ANY:any", "").expectString("D-STRING:string", "").expectString("D-INT:int", "").expectString("D-LONG:long", "").expectString("D-FLOAT:float", "").expectString("D-DOUBLE:double", "").expectLong("D-ANY:any", new Long[]{null}).noLong("D-STRING:string").expectLong("D-INT:int", new Long[]{null}).expectLong("D-LONG:long", new Long[]{null}).noLong("D-FLOAT:float").noLong("D-DOUBLE:double").expectDouble("D-ANY:any", new Double[]{null}).noDouble("D-STRING:string").noDouble("D-INT:int").noDouble("D-LONG:long").expectDouble("D-FLOAT:float", new Double[]{null}).expectDouble("D-DOUBLE:double", new Double[]{null}).expectString("A-ANY:any", "").expectString("A-STRING:string", "").expectString("A-INT:int", "").expectString("A-LONG:long", "").expectString("A-FLOAT:float", "").expectString("A-DOUBLE:double", "").expectLong("A-ANY:any", new Long[]{null}).noLong("A-STRING:string").expectLong("A-INT:int", new Long[]{null}).expectLong("A-LONG:long", new Long[]{null}).noLong("A-FLOAT:float").noLong("A-DOUBLE:double").expectDouble("A-ANY:any", new Double[]{null}).noDouble("A-STRING:string").noDouble("A-INT:int").noDouble("A-LONG:long").expectDouble("A-FLOAT:float", new Double[]{null}).expectDouble("A-DOUBLE:double", new Double[]{null}).expectString("N-ANY:any", "").expectString("N-STRING:string", "").expectString("N-INT:int", "").expectString("N-LONG:long", "").expectString("N-FLOAT:float", "").expectString("N-DOUBLE:double", "").noLong("N-ANY:any").noLong("N-STRING:string").noLong("N-INT:int").noLong("N-LONG:long").noLong("N-FLOAT:float").noLong("N-DOUBLE:double").noDouble("N-ANY:any").noDouble("N-STRING:string").noDouble("N-INT:int").noDouble("N-LONG:long").noDouble("N-FLOAT:float").noDouble("N-DOUBLE:double").noString("E-ANY:any").noString("E-STRING:string").noString("E-INT:int").noString("E-LONG:long").noString("E-FLOAT:float").noString("E-DOUBLE:double").noLong("E-ANY:any").noLong("E-STRING:string").noLong("E-INT:int").noLong("E-LONG:long").noLong("E-FLOAT:float").noLong("E-DOUBLE:double").noDouble("E-ANY:any").noDouble("E-STRING:string").noDouble("E-INT:int").noDouble("E-LONG:long").noDouble("E-FLOAT:float").noDouble("E-DOUBLE:double");
    }

    @Test
    void testNullValues() throws InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        Parser parser = new Parser(TestFieldSettersRecord.class);
        parser.setRootType("INPUT");
        parser.addDissector((Dissector)new NullValuesDissector());
        TestFieldSettersRecord testRecord = (TestFieldSettersRecord)parser.parse("Doesn't matter");
        testRecord.expectString("D-ANY:any", new String[]{null}).expectString("D-STRING:string", new String[]{null}).expectString("D-INT:int", new String[]{null}).expectString("D-LONG:long", new String[]{null}).expectString("D-FLOAT:float", new String[]{null}).expectString("D-DOUBLE:double", new String[]{null}).expectLong("D-ANY:any", new Long[]{null}).noLong("D-STRING:string").expectLong("D-INT:int", new Long[]{null}).expectLong("D-LONG:long", new Long[]{null}).noLong("D-FLOAT:float").noLong("D-DOUBLE:double").expectDouble("D-ANY:any", new Double[]{null}).noDouble("D-STRING:string").noDouble("D-INT:int").noDouble("D-LONG:long").expectDouble("D-FLOAT:float", new Double[]{null}).expectDouble("D-DOUBLE:double", new Double[]{null}).expectString("A-ANY:any", new String[]{null}).expectString("A-STRING:string", new String[]{null}).expectString("A-INT:int", new String[]{null}).expectString("A-LONG:long", new String[]{null}).expectString("A-FLOAT:float", new String[]{null}).expectString("A-DOUBLE:double", new String[]{null}).expectLong("A-ANY:any", new Long[]{null}).noLong("A-STRING:string").expectLong("A-INT:int", new Long[]{null}).expectLong("A-LONG:long", new Long[]{null}).noLong("A-FLOAT:float").noLong("A-DOUBLE:double").expectDouble("A-ANY:any", new Double[]{null}).noDouble("A-STRING:string").noDouble("A-INT:int").noDouble("A-LONG:long").expectDouble("A-FLOAT:float", new Double[]{null}).expectDouble("A-DOUBLE:double", new Double[]{null}).noString("N-ANY:any").noString("N-STRING:string").noString("N-INT:int").noString("N-LONG:long").noString("N-FLOAT:float").noString("N-DOUBLE:double").noLong("N-ANY:any").noLong("N-STRING:string").noLong("N-INT:int").noLong("N-LONG:long").noLong("N-FLOAT:float").noLong("N-DOUBLE:double").noDouble("N-ANY:any").noDouble("N-STRING:string").noDouble("N-INT:int").noDouble("N-LONG:long").noDouble("N-FLOAT:float").noDouble("N-DOUBLE:double").noString("E-ANY:any").noString("E-STRING:string").noString("E-INT:int").noString("E-LONG:long").noString("E-FLOAT:float").noString("E-DOUBLE:double").noLong("E-ANY:any").noLong("E-STRING:string").noLong("E-INT:int").noLong("E-LONG:long").noLong("E-FLOAT:float").noLong("E-DOUBLE:double").noDouble("E-ANY:any").noDouble("E-STRING:string").noDouble("E-INT:int").noDouble("E-LONG:long").noDouble("E-FLOAT:float").noDouble("E-DOUBLE:double");
    }

    public static class TestFieldSettersRecord
    extends TestRecord {
        private void setS(String prefix, String name, String value) {
            this.setStringValue(prefix + "-" + name, value);
        }

        private void setL(String prefix, String name, Long value) {
            this.setLongValue(prefix + "-" + name, value);
        }

        private void setD(String prefix, String name, Double value) {
            this.setDoubleValue(prefix + "-" + name, value);
        }

        @Field(value={"ANY:any"})
        public void setAD(String n, String v) {
            this.setS("D", n, v);
        }

        @Field(value={"STRING:string"})
        public void setSD(String n, String v) {
            this.setS("D", n, v);
        }

        @Field(value={"INT:int"})
        public void setID(String n, String v) {
            this.setS("D", n, v);
        }

        @Field(value={"LONG:long"})
        public void setLD(String n, String v) {
            this.setS("D", n, v);
        }

        @Field(value={"FLOAT:float"})
        public void setFD(String n, String v) {
            this.setS("D", n, v);
        }

        @Field(value={"DOUBLE:double"})
        public void setDD(String n, String v) {
            this.setS("D", n, v);
        }

        @Field(value={"ANY:any"})
        public void setAD(String n, Long v) {
            this.setL("D", n, v);
        }

        @Field(value={"STRING:string"})
        public void setSD(String n, Long v) {
            this.setL("D", n, v);
        }

        @Field(value={"INT:int"})
        public void setID(String n, Long v) {
            this.setL("D", n, v);
        }

        @Field(value={"LONG:long"})
        public void setLD(String n, Long v) {
            this.setL("D", n, v);
        }

        @Field(value={"FLOAT:float"})
        public void setFD(String n, Long v) {
            this.setL("D", n, v);
        }

        @Field(value={"DOUBLE:double"})
        public void setDD(String n, Long v) {
            this.setL("D", n, v);
        }

        @Field(value={"ANY:any"})
        public void setAD(String n, Double v) {
            this.setD("D", n, v);
        }

        @Field(value={"STRING:string"})
        public void setSD(String n, Double v) {
            this.setD("D", n, v);
        }

        @Field(value={"INT:int"})
        public void setID(String n, Double v) {
            this.setD("D", n, v);
        }

        @Field(value={"LONG:long"})
        public void setLD(String n, Double v) {
            this.setD("D", n, v);
        }

        @Field(value={"FLOAT:float"})
        public void setFD(String n, Double v) {
            this.setD("D", n, v);
        }

        @Field(value={"DOUBLE:double"})
        public void setDD(String n, Double v) {
            this.setD("D", n, v);
        }

        @Field(value={"ANY:any"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setAA(String n, String v) {
            this.setS("A", n, v);
        }

        @Field(value={"STRING:string"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setSA(String n, String v) {
            this.setS("A", n, v);
        }

        @Field(value={"INT:int"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setIA(String n, String v) {
            this.setS("A", n, v);
        }

        @Field(value={"LONG:long"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setLA(String n, String v) {
            this.setS("A", n, v);
        }

        @Field(value={"FLOAT:float"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setFA(String n, String v) {
            this.setS("A", n, v);
        }

        @Field(value={"DOUBLE:double"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setDA(String n, String v) {
            this.setS("A", n, v);
        }

        @Field(value={"ANY:any"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setAA(String n, Long v) {
            this.setL("A", n, v);
        }

        @Field(value={"STRING:string"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setSA(String n, Long v) {
            this.setL("A", n, v);
        }

        @Field(value={"INT:int"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setIA(String n, Long v) {
            this.setL("A", n, v);
        }

        @Field(value={"LONG:long"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setLA(String n, Long v) {
            this.setL("A", n, v);
        }

        @Field(value={"FLOAT:float"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setFA(String n, Long v) {
            this.setL("A", n, v);
        }

        @Field(value={"DOUBLE:double"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setDA(String n, Long v) {
            this.setL("A", n, v);
        }

        @Field(value={"ANY:any"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setAA(String n, Double v) {
            this.setD("A", n, v);
        }

        @Field(value={"STRING:string"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setSA(String n, Double v) {
            this.setD("A", n, v);
        }

        @Field(value={"INT:int"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setIA(String n, Double v) {
            this.setD("A", n, v);
        }

        @Field(value={"LONG:long"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setLA(String n, Double v) {
            this.setD("A", n, v);
        }

        @Field(value={"FLOAT:float"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setFA(String n, Double v) {
            this.setD("A", n, v);
        }

        @Field(value={"DOUBLE:double"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setDA(String n, Double v) {
            this.setD("A", n, v);
        }

        @Field(value={"ANY:any"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setAN(String n, String v) {
            this.setS("N", n, v);
        }

        @Field(value={"STRING:string"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setSN(String n, String v) {
            this.setS("N", n, v);
        }

        @Field(value={"INT:int"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setIN(String n, String v) {
            this.setS("N", n, v);
        }

        @Field(value={"LONG:long"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setLN(String n, String v) {
            this.setS("N", n, v);
        }

        @Field(value={"FLOAT:float"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setFN(String n, String v) {
            this.setS("N", n, v);
        }

        @Field(value={"DOUBLE:double"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setDN(String n, String v) {
            this.setS("N", n, v);
        }

        @Field(value={"ANY:any"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setAN(String n, Long v) {
            this.setL("N", n, v);
        }

        @Field(value={"STRING:string"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setSN(String n, Long v) {
            this.setL("N", n, v);
        }

        @Field(value={"INT:int"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setIN(String n, Long v) {
            this.setL("N", n, v);
        }

        @Field(value={"LONG:long"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setLN(String n, Long v) {
            this.setL("N", n, v);
        }

        @Field(value={"FLOAT:float"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setFN(String n, Long v) {
            this.setL("N", n, v);
        }

        @Field(value={"DOUBLE:double"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setDN(String n, Long v) {
            this.setL("N", n, v);
        }

        @Field(value={"ANY:any"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setAN(String n, Double v) {
            this.setD("N", n, v);
        }

        @Field(value={"STRING:string"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setSN(String n, Double v) {
            this.setD("N", n, v);
        }

        @Field(value={"INT:int"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setIN(String n, Double v) {
            this.setD("N", n, v);
        }

        @Field(value={"LONG:long"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setLN(String n, Double v) {
            this.setD("N", n, v);
        }

        @Field(value={"FLOAT:float"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setFN(String n, Double v) {
            this.setD("N", n, v);
        }

        @Field(value={"DOUBLE:double"}, setterPolicy=Parser.SetterPolicy.NOT_NULL)
        public void setDN(String n, Double v) {
            this.setD("N", n, v);
        }

        @Field(value={"ANY:any"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setAE(String n, String v) {
            this.setS("E", n, v);
        }

        @Field(value={"STRING:string"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setSE(String n, String v) {
            this.setS("E", n, v);
        }

        @Field(value={"INT:int"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setIE(String n, String v) {
            this.setS("E", n, v);
        }

        @Field(value={"LONG:long"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setLE(String n, String v) {
            this.setS("E", n, v);
        }

        @Field(value={"FLOAT:float"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setFE(String n, String v) {
            this.setS("E", n, v);
        }

        @Field(value={"DOUBLE:double"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setDE(String n, String v) {
            this.setS("E", n, v);
        }

        @Field(value={"ANY:any"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setAE(String n, Long v) {
            this.setL("E", n, v);
        }

        @Field(value={"STRING:string"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setSE(String n, Long v) {
            this.setL("E", n, v);
        }

        @Field(value={"INT:int"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setIE(String n, Long v) {
            this.setL("E", n, v);
        }

        @Field(value={"LONG:long"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setLE(String n, Long v) {
            this.setL("E", n, v);
        }

        @Field(value={"FLOAT:float"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setFE(String n, Long v) {
            this.setL("E", n, v);
        }

        @Field(value={"DOUBLE:double"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setDE(String n, Long v) {
            this.setL("E", n, v);
        }

        @Field(value={"ANY:any"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setAE(String n, Double v) {
            this.setD("E", n, v);
        }

        @Field(value={"STRING:string"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setSE(String n, Double v) {
            this.setD("E", n, v);
        }

        @Field(value={"INT:int"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setIE(String n, Double v) {
            this.setD("E", n, v);
        }

        @Field(value={"LONG:long"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setLE(String n, Double v) {
            this.setD("E", n, v);
        }

        @Field(value={"FLOAT:float"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setFE(String n, Double v) {
            this.setD("E", n, v);
        }

        @Field(value={"DOUBLE:double"}, setterPolicy=Parser.SetterPolicy.NOT_EMPTY)
        public void setDE(String n, Double v) {
            this.setD("E", n, v);
        }
    }
}

