/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core.annotation;

import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Field;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import nl.basjes.parse.core.test.NormalValuesDissector;
import nl.basjes.parse.core.test.TestRecord;
import org.junit.jupiter.api.Test;

public class TestFieldSettersAlwaysSeparate {
    @Test
    void testString() throws InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        ((TestRecordString)new Parser(TestRecordString.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).parse("Doesn't matter")).expectString("ANY:any", "42").expectString("STRING:string", "FortyTwo").expectString("INT:int", "42").expectString("LONG:long", "42").expectString("FLOAT:float", "42.0").expectString("DOUBLE:double", "42.0");
    }

    @Test
    void testLong() throws InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        ((TestRecordLong)new Parser(TestRecordLong.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).parse("Doesn't matter")).expectLong("ANY:any", 42L).expectLong("INT:int", 42L).expectLong("LONG:long", 42L);
    }

    @Test
    void testDouble() throws InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        ((TestRecordDouble)new Parser(TestRecordDouble.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).parse("Doesn't matter")).expectDouble("ANY:any", 42.0).expectDouble("FLOAT:float", 42.0).expectDouble("DOUBLE:double", 42.0);
    }

    public static class TestRecordDouble
    extends TestRecord {
        private void set(String name, Double value) {
            this.setDoubleValue(name, value);
        }

        @Field(value={"ANY:any"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setA(String n, Double v) {
            this.set(n, v);
        }

        @Field(value={"FLOAT:float"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setF(String n, Double v) {
            this.set(n, v);
        }

        @Field(value={"DOUBLE:double"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setD(String n, Double v) {
            this.set(n, v);
        }
    }

    public static class TestRecordLong
    extends TestRecord {
        private void set(String name, Long value) {
            this.setLongValue(name, value);
        }

        @Field(value={"ANY:any"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setA(String n, Long v) {
            this.set(n, v);
        }

        @Field(value={"INT:int"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setI(String n, Long v) {
            this.set(n, v);
        }

        @Field(value={"LONG:long"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setL(String n, Long v) {
            this.set(n, v);
        }
    }

    public static class TestRecordString
    extends TestRecord {
        private void set(String name, String value) {
            this.setStringValue(name, value);
        }

        @Field(value={"ANY:any"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setA(String n, String v) {
            this.set(n, v);
        }

        @Field(value={"STRING:string"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setS(String n, String v) {
            this.set(n, v);
        }

        @Field(value={"INT:int"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setI(String n, String v) {
            this.set(n, v);
        }

        @Field(value={"LONG:long"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setL(String n, String v) {
            this.set(n, v);
        }

        @Field(value={"FLOAT:float"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setF(String n, String v) {
            this.set(n, v);
        }

        @Field(value={"DOUBLE:double"}, setterPolicy=Parser.SetterPolicy.ALWAYS)
        public void setD(String n, String v) {
            this.set(n, v);
        }
    }
}

