/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core.convert;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.SimpleDissector;
import nl.basjes.parse.core.Value;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.test.DissectorTester;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValueConvertTest {
    @Test
    public void verifyTypeConversionStoM() {
        DissectorTester.create().withDissector("something", (Dissector)new SecondsToMilliseconds()).withDissector((Dissector)new MillisecondsToSeconds()).withInput("12345").expect("SECONDS:something", "12345").expect("MILLISECONDS:something", "12345000").checkExpectations();
    }

    @Test
    public void verifyTypeConversionMtoS() {
        DissectorTester.create().withDissector("something", (Dissector)new MillisecondsToSeconds()).withDissector((Dissector)new SecondsToMilliseconds()).withInput("12345000").expect("SECONDS:something", "12345").expect("MILLISECONDS:something", "12345000").checkExpectations();
    }

    @Test
    public void verifyTypeConversionPossibleFields() {
        List<String> possible = DissectorTester.create().withDissector("something", (Dissector)new MillisecondsToSeconds()).withDissector((Dissector)new SecondsToMilliseconds()).withInput("12345000").getPossible();
        Assertions.assertTrue((boolean)possible.contains("MILLISECONDS:something"));
        Assertions.assertTrue((boolean)possible.contains("SECONDS:something"));
    }

    public static class MillisecondsToSeconds
    extends TypeConvertBaseDissector {
        public MillisecondsToSeconds() {
            super("MILLISECONDS", "SECONDS");
        }

        public void dissect(Parsable<?> parsable, String inputname, Value value) throws DissectionFailure {
            parsable.addDissection(inputname, "SECONDS", "", value.getLong() / 1000L);
        }
    }

    public static class SecondsToMilliseconds
    extends TypeConvertBaseDissector {
        public SecondsToMilliseconds() {
            super("SECONDS", "MILLISECONDS");
        }

        public void dissect(Parsable<?> parsable, String inputname, Value value) throws DissectionFailure {
            parsable.addDissection(inputname, "MILLISECONDS", "", value.getLong() * 1000L);
        }
    }

    public static abstract class TypeConvertBaseDissector
    extends SimpleDissector {
        protected String inputType;
        protected String outputType;

        private static HashMap<String, EnumSet<Casts>> fillOutputConfig(String outputType, EnumSet<Casts> casts) {
            HashMap<String, EnumSet<Casts>> typeConvertConfig = new HashMap<String, EnumSet<Casts>>();
            typeConvertConfig.put(outputType + ":", casts);
            return typeConvertConfig;
        }

        public TypeConvertBaseDissector(String nInputType, String nOutputType) {
            super(nInputType, TypeConvertBaseDissector.fillOutputConfig(nOutputType, Casts.STRING_OR_LONG));
            this.inputType = nInputType;
            this.outputType = nOutputType;
        }

        protected void initializeNewInstance(Dissector newInstance) throws InvalidDissectorException {
            super.initializeNewInstance(newInstance);
            ((TypeConvertBaseDissector)newInstance).inputType = this.inputType;
            ((TypeConvertBaseDissector)newInstance).outputType = this.outputType;
        }
    }
}

