/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core.reference;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.reference.BarDissector;
import nl.basjes.parse.core.reference.FooDissector;
import nl.basjes.parse.core.test.DissectorTester;
import org.junit.jupiter.api.Test;

public class ReferenceTestDouble {
    @Test
    public void verifyRemap() {
        DissectorTester.create().withDissector(new RemapInputDissector()).withInput("Doesn't matter").expect("INPUT:", "42").checkExpectations();
    }

    @Test
    public void verifyFooInput() {
        DissectorTester.create().withDissector((Dissector)new FooInputDissector()).withInput("Doesn't matter").expect("ANY:fooany", "42").expect("ANY:fooany", 42L).expect("ANY:fooany", 42.0).expect("STRING:foostring", "42").expectAbsentLong("STRING:foostring").expectAbsentDouble("STRING:foostring").expect("INT:fooint", "42").expect("INT:fooint", 42L).expectAbsentDouble("INT:fooint").expect("LONG:foolong", "42").expect("LONG:foolong", 42L).expectAbsentDouble("LONG:foolong").expect("FLOAT:foofloat", "42.0").expectAbsentLong("FLOAT:foofloat").expect("FLOAT:foofloat", 42.0).expect("DOUBLE:foodouble", "42.0").expectAbsentLong("DOUBLE:foodouble").expect("DOUBLE:foodouble", 42.0).checkExpectations();
    }

    @Test
    public void verifyBarInput() {
        DissectorTester.create().withDissector((Dissector)new BarInputDissector()).withInput("Doesn't matter").expect("ANY:barany", "42").expect("ANY:barany", 42L).expect("ANY:barany", 42.0).expect("STRING:barstring", "42").expectAbsentLong("STRING:barstring").expectAbsentDouble("STRING:barstring").expect("INT:barint", "42").expect("INT:barint", 42L).expectAbsentDouble("INT:barint").expect("LONG:barlong", "42").expect("LONG:barlong", 42L).expectAbsentDouble("LONG:barlong").expect("FLOAT:barfloat", "42.0").expectAbsentLong("FLOAT:barfloat").expect("FLOAT:barfloat", 42.0).expect("DOUBLE:bardouble", "42.0").expectAbsentLong("DOUBLE:bardouble").expect("DOUBLE:bardouble", 42.0).checkExpectations();
    }

    @Test
    public void runDoubleDissectors() {
        DissectorTester.create().withDissector(new InputCreatingDissector()).withDissector(new RemapInputDissector()).withDissector((Dissector)new FooInputDissector()).withDissector((Dissector)new BarInputDissector()).withInput("Doesn't matter").expect("ANY:something.fooany", "42").expect("ANY:something.fooany", 42L).expect("ANY:something.fooany", 42.0).expect("STRING:something.foostring", "42").expectAbsentLong("STRING:something.foostring").expectAbsentDouble("STRING:something.foostring").expect("INT:something.fooint", "42").expect("INT:something.fooint", 42L).expectAbsentDouble("INT:something.fooint").expect("LONG:something.foolong", "42").expect("LONG:something.foolong", 42L).expectAbsentDouble("LONG:something.foolong").expect("FLOAT:something.foofloat", "42.0").expectAbsentLong("FLOAT:something.foofloat").expect("FLOAT:something.foofloat", 42.0).expect("DOUBLE:something.foodouble", "42.0").expectAbsentLong("DOUBLE:something.foodouble").expect("DOUBLE:something.foodouble", 42.0).expect("ANY:something.barany", "42").expect("ANY:something.barany", 42L).expect("ANY:something.barany", 42.0).expect("STRING:something.barstring", "42").expectAbsentLong("STRING:something.barstring").expectAbsentDouble("STRING:something.barstring").expect("INT:something.barint", "42").expect("INT:something.barint", 42L).expectAbsentDouble("INT:something.barint").expect("LONG:something.barlong", "42").expect("LONG:something.barlong", 42L).expectAbsentDouble("LONG:something.barlong").expect("FLOAT:something.barfloat", "42.0").expectAbsentLong("FLOAT:something.barfloat").expect("FLOAT:something.barfloat", 42.0).expect("DOUBLE:something.bardouble", "42.0").expectAbsentLong("DOUBLE:something.bardouble").expect("DOUBLE:something.bardouble", 42.0).checkExpectations();
    }

    public static class BarInputDissector
    extends BarDissector {
        public String getInputType() {
            return "INPUT";
        }
    }

    public static class FooInputDissector
    extends FooDissector {
        public String getInputType() {
            return "INPUT";
        }
    }

    public static class RemapInputDissector
    extends Dissector {
        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            parsable.addDissection(inputname, "INPUT", "", "42");
        }

        public String getInputType() {
            return "BASEINPUT";
        }

        public List<String> getPossibleOutput() {
            return Collections.singletonList("INPUT:");
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }
    }

    public static class InputCreatingDissector
    extends Dissector {
        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            parsable.addDissection(inputname, "BASEINPUT", "something", "42");
        }

        public String getInputType() {
            return "SOME_LINE";
        }

        public List<String> getPossibleOutput() {
            return Collections.singletonList("BASEINPUT:something");
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }
    }
}

