/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.ParserNormalRecordTest;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import nl.basjes.parse.core.test.NormalValuesDissector;
import nl.basjes.parse.core.test.TestRecord;
import org.junit.Assert;
import org.junit.Test;

public class ParserNormalTest {
    @Test
    public void testParseString() throws Exception {
        TestParser<ParserNormalRecordTest> parser = new TestParser<ParserNormalRecordTest>(ParserNormalRecordTest.class);
        String[] params = new String[]{"OTHERTYPE:output2"};
        parser.addParseTarget(ParserNormalRecordTest.class.getMethod("setValue2", String.class, String.class), Arrays.asList(params)).dropDissector(TestDissectorWildCard.class).addDissector((Dissector)new TestDissectorWildCard());
        ParserNormalRecordTest output = new ParserNormalRecordTest();
        parser.parse(output, "Something");
        Assert.assertEquals((Object)"SOMETYPE1:SOMETYPE:output1:Something", (Object)output.getOutput1());
        Assert.assertEquals((Object)"OTHERTYPE2:OTHERTYPE:output2:Something", (Object)output.getOutput2());
        Assert.assertEquals((Object)"SOMETYPE3:SOMETYPE:output1:Something", (Object)output.getOutput3a());
        Assert.assertEquals((Object)"OTHERTYPE3:OTHERTYPE:output2:Something", (Object)output.getOutput3b());
        Assert.assertEquals((Object)"X=SOMETYPE:SOMETYPE:output1:Something", (Object)output.getOutput4a());
        Assert.assertEquals((Object)"Y=OTHERTYPE:OTHERTYPE:output2:Something", (Object)output.getOutput4b());
        Assert.assertEquals((Object)"X=SOMETYPE:SOMETYPE:output1:Something=SOMETYPE:SOMETYPE:output1:Something", (Object)output.getOutput5a());
        Assert.assertEquals((Object)"Y=OTHERTYPE:OTHERTYPE:output2:Something=OTHERTYPE:OTHERTYPE:output2:Something", (Object)output.getOutput5b());
        Assert.assertEquals((Object)"Z=FOO:FOO:output1.foo:Something", (Object)output.getOutput6());
        Assert.assertEquals((Object)"Z=BAR:BAR:output1.bar:Something", (Object)output.getOutput7());
        Assert.assertEquals((Object)"Z=WILD:WILD:output1.wild:Something", (Object)output.getOutput8());
    }

    @Test
    public void testParseStringInstantiate() throws Exception {
        TestParser<ParserNormalRecordTest> parser = new TestParser<ParserNormalRecordTest>(ParserNormalRecordTest.class);
        String[] params = new String[]{"OTHERTYPE:output2"};
        parser.addParseTarget(ParserNormalRecordTest.class.getMethod("setValue2", String.class, String.class), Arrays.asList(params));
        ParserNormalRecordTest output = (ParserNormalRecordTest)parser.parse("Something");
        Assert.assertEquals((Object)"SOMETYPE1:SOMETYPE:output1:Something", (Object)output.getOutput1());
        Assert.assertEquals((Object)"OTHERTYPE2:OTHERTYPE:output2:Something", (Object)output.getOutput2());
        Assert.assertEquals((Object)"SOMETYPE3:SOMETYPE:output1:Something", (Object)output.getOutput3a());
        Assert.assertEquals((Object)"OTHERTYPE3:OTHERTYPE:output2:Something", (Object)output.getOutput3b());
        Assert.assertEquals((Object)"X=SOMETYPE:SOMETYPE:output1:Something", (Object)output.getOutput4a());
        Assert.assertEquals((Object)"Y=OTHERTYPE:OTHERTYPE:output2:Something", (Object)output.getOutput4b());
        Assert.assertEquals((Object)"X=SOMETYPE:SOMETYPE:output1:Something=SOMETYPE:SOMETYPE:output1:Something", (Object)output.getOutput5a());
        Assert.assertEquals((Object)"Y=OTHERTYPE:OTHERTYPE:output2:Something=OTHERTYPE:OTHERTYPE:output2:Something", (Object)output.getOutput5b());
        Assert.assertEquals((Object)"Z=FOO:FOO:output1.foo:Something", (Object)output.getOutput6());
        Assert.assertEquals((Object)"Z=BAR:BAR:output1.bar:Something", (Object)output.getOutput7());
        Assert.assertEquals((Object)"Z=WILD:WILD:output1.wild:Something", (Object)output.getOutput8());
    }

    @Test(expected=MissingDissectorsException.class)
    public void testMissingDissector() throws Exception {
        TestParser<ParserNormalRecordTest> parser = new TestParser<ParserNormalRecordTest>(ParserNormalRecordTest.class);
        parser.dropDissector(TestDissectorTwo.class);
        ParserNormalRecordTest output = new ParserNormalRecordTest();
        parser.parse(output, "Something");
    }

    @Test
    public void testGetPossiblePaths() throws Exception {
        TestParser<ParserNormalRecordTest> parser = new TestParser<ParserNormalRecordTest>(ParserNormalRecordTest.class);
        String[] params = new String[]{"OTHERTYPE:output2"};
        parser.addParseTarget(ParserNormalRecordTest.class.getMethod("setValue2", String.class, String.class), Arrays.asList(params));
        List paths = parser.getPossiblePaths(3);
        for (String path : paths) {
            System.out.println("XXX " + path);
        }
    }

    @Test
    public void testAddTypeRemapping() throws NoSuchMethodException, InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        ((TestRecord)new Parser(TestRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).addTypeRemapping("string", "STRINGXX").addParseTarget("setStringValue", "STRINGXX:string").addTypeRemapping("string", "STRINGYY").addParseTarget("setStringValue", "STRINGYY:string").parse("Doesn't matter")).expectString("STRINGXX:string", "FortyTwo").expectString("STRINGYY:string", "FortyTwo");
    }

    @Test
    public void testAddTypeRemappings() throws NoSuchMethodException, InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        ((TestRecord)new Parser(TestRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).addTypeRemapping("string", "STRINGXX").addParseTarget("setStringValue", "STRINGXX:string").addTypeRemappings(Collections.singletonMap("string", Collections.singleton("STRINGYY"))).addParseTarget("setStringValue", "STRINGYY:string").parse("Doesn't matter")).expectString("STRINGXX:string", "FortyTwo").expectString("STRINGYY:string", "FortyTwo");
    }

    @Test
    public void testSetTypeRemapping() throws NoSuchMethodException, InvalidDissectorException, MissingDissectorsException, DissectionFailure {
        try {
            new Parser(TestRecord.class).setRootType("INPUT").addDissector((Dissector)new NormalValuesDissector()).addTypeRemapping("string", "STRINGXX").addParseTarget("setStringValue", "STRINGXX:string").setTypeRemappings(Collections.singletonMap("string", Collections.singleton("STRINGYY"))).addParseTarget("setStringValue", "STRINGYY:string").parse("Doesn't matter");
            Assert.fail((String)"We should get an exception because the mapping to STRINGXX:string wass removed.");
        }
        catch (MissingDissectorsException mde) {
            Assert.assertTrue((boolean)mde.getMessage().contains("STRINGXX:string"));
        }
    }

    public static class TestParser<RECORD>
    extends Parser<RECORD> {
        public TestParser(Class<RECORD> clazz) {
            super(clazz);
            this.addDissector(new TestDissectorOne());
            this.addDissector(new TestDissectorTwo());
            this.addDissector(new TestDissectorThree());
            this.addDissector(new TestDissectorFour());
            this.addDissector(new TestDissectorWildCard());
            this.setRootType("INPUTTYPE");
        }
    }

    public static class TestDissectorWildCard
    extends TestDissector {
        public TestDissectorWildCard() {
            super("SOMETYPE", "WILD", "*");
        }
    }

    public static class TestDissectorFour
    extends TestDissector {
        public TestDissectorFour() {
            super("SOMETYPE", "BAR", "bar");
        }
    }

    public static class TestDissectorThree
    extends TestDissector {
        public TestDissectorThree() {
            super("SOMETYPE", "FOO", "foo");
        }
    }

    public static class TestDissectorTwo
    extends TestDissector {
        public TestDissectorTwo() {
            super("INPUTTYPE", "OTHERTYPE", "output2");
        }
    }

    public static class TestDissectorOne
    extends TestDissector {
        public TestDissectorOne() {
            super("INPUTTYPE", "SOMETYPE", "output1");
        }
    }

    public static class TestDissector
    extends Dissector {
        private String inputType;
        private String outputType;
        private String outputName;
        private final Set<String> outputNames = new HashSet<String>();

        public TestDissector(String inputType, String outputType, String outputName) {
            this.inputType = inputType;
            this.outputType = outputType;
            this.outputName = outputName;
            this.outputNames.add(outputName);
        }

        public void init(String inputtype, String outputtype, String outputname) {
            this.inputType = inputtype;
            this.outputType = outputtype;
            this.outputName = outputname;
            this.outputNames.add(outputname);
        }

        protected void initializeNewInstance(Dissector newInstance) {
            ((TestDissector)newInstance).init(this.inputType, this.outputType, this.outputName);
        }

        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            ParsedField field = parsable.getParsableField(this.inputType, inputname);
            for (String outputname : this.outputNames) {
                parsable.addDissection(inputname, this.outputType, outputname, field.getValue());
            }
        }

        public String getInputType() {
            return this.inputType;
        }

        public List<String> getPossibleOutput() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.outputType + ":" + this.outputName);
            return result;
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            String name = outputname;
            String prefix = inputname + '.';
            if (outputname.startsWith(prefix)) {
                name = outputname.substring(prefix.length());
            }
            this.outputNames.add(name);
            return Casts.STRING_ONLY;
        }
    }
}

